#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class GeneratorExpressionImpl : Expression
	{
		protected Expression _expression;

		protected DeclarationCollection _declarations;

		protected Expression _iterator;

		protected StatementModifier _filter;

		protected GeneratorExpressionImpl()
		{
			InitializeFields();
		}
		
		protected GeneratorExpressionImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		
		protected GeneratorExpressionImpl(Expression expression, Expression iterator, StatementModifier filter)
		{
			InitializeFields();
			Expression = expression;
			Iterator = iterator;
			Filter = filter;
		}
			
		protected GeneratorExpressionImpl(LexicalInfo lexicalInfo, Expression expression, Expression iterator, StatementModifier filter) : base(lexicalInfo)
		{
			InitializeFields();
			Expression = expression;
			Iterator = iterator;
			Filter = filter;
		}

		new public GeneratorExpression CloneNode()
		{
			return Clone() as GeneratorExpression;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.GeneratorExpression;
			}
		}
		
		override public bool Matches(Node node)
		{	
			GeneratorExpression other = node as GeneratorExpression;
			if (null == other) return false;
			if (!Node.Matches(_expression, other._expression)) return false;
			if (!Node.Matches(_declarations, other._declarations)) return false;
			if (!Node.Matches(_iterator, other._iterator)) return false;
			if (!Node.Matches(_filter, other._filter)) return false;
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_expression == existing)
			{
				this.Expression = (Expression)newNode;
				return true;
			}
			if (_declarations != null)
			{
				Declaration item = existing as Declaration;
				if (null != item)
				{
					Declaration newItem = (Declaration)newNode;
					if (_declarations.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_iterator == existing)
			{
				this.Iterator = (Expression)newNode;
				return true;
			}
			if (_filter == existing)
			{
				this.Filter = (StatementModifier)newNode;
				return true;
			}
			return false;
		}
		
		override public object Clone()
		{
			GeneratorExpression clone = (GeneratorExpression)FormatterServices.GetUninitializedObject(typeof(GeneratorExpression));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._expressionType = _expressionType;
			if (null != _expression)
			{
				clone._expression = _expression.Clone() as Expression;
				clone._expression.InitializeParent(clone);
			}
			if (null != _declarations)
			{
				clone._declarations = _declarations.Clone() as DeclarationCollection;
				clone._declarations.InitializeParent(clone);
			}
			if (null != _iterator)
			{
				clone._iterator = _iterator.Clone() as Expression;
				clone._iterator.InitializeParent(clone);
			}
			if (null != _filter)
			{
				clone._filter = _filter.Clone() as StatementModifier;
				clone._filter.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			_expressionType = null;
			if (null != _expression)
			{
				_expression.ClearTypeSystemBindings();
			}
			if (null != _declarations)
			{
				_declarations.ClearTypeSystemBindings();
			}
			if (null != _iterator)
			{
				_iterator.ClearTypeSystemBindings();
			}
			if (null != _filter)
			{
				_filter.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public Expression Expression
		{
			get
			{
				return _expression;
			}

			set
			{
				if (_expression != value)
				{
					OnReplace(_expression, value);
					_expression = value;
					if (null != _expression)
					{
						_expression.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public DeclarationCollection Declarations
		{
			get
			{
				return _declarations;
			}

			set
			{
				if (_declarations != value)
				{
					OnReplace(_declarations, value);
					_declarations = value;
					if (null != _declarations)
					{
						_declarations.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public Expression Iterator
		{
			get
			{
				return _iterator;
			}

			set
			{
				if (_iterator != value)
				{
					OnReplace(_iterator, value);
					_iterator = value;
					if (null != _iterator)
					{
						_iterator.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public StatementModifier Filter
		{
			get
			{
				return _filter;
			}

			set
			{
				if (_filter != value)
				{
					OnReplace(_filter, value);
					_filter = value;
					if (null != _filter)
					{
						_filter.InitializeParent(this);
					}
				}
			}

		}
		
		private void InitializeFields()
		{

			_declarations = new DeclarationCollection(this);

		}
	}
}

