#! /bin/bash

set -e

. ./common.sh

revext="$1"
kernel="$2"
shift 2
packages_with_modules="$*"

testroot

extractdir=${tmpdir}/boot-floppies/extract-tmp-$$

kernel_version=`echo $kernel | sed -e 's/.*kernel-image-//' | \
                        sed -e 's/_.*//'`
rm -rf $extractdir
make_tmpdir $extractdir

info "extracting kernel to $extractdir"
for i in $kernel $packages_with_modules; do
	debug "extracting $i"
	dpkg-deb --extract $i $extractdir
done

if [ "$revext" = lowmem ]; then
	(cd $extractdir/lib/modules/*; 
	rm -rf block ipv? misc net pcmcia fs *MODULES )
fi

if [ -e scripts/rootdisk/modules.purge ]; then
  purgemodules=$(cat scripts/rootdisk/modules.purge)
  cd $extractdir/lib/modules/$kernel_version && rm -f $purgemodules
fi

info "creating module contents file, modcont$revext"
(cd $extractdir;
	for i in lib/modules/*/*; do
		if [ -d  $i ]; then
			echo -n "dir_content_`basename $i`=\"";
			for j in $i/*.o; do
				echo -n `basename $j .o` " " ;
			done ;
			echo \" ;
		fi ;
	done
) > modcont$revext

relax

info "creating modules${revext}.tgz"
(cd $extractdir && tar clf - lib/modules | gzip -9) > modules${revext}.tgz

if [ "$revext" = "" ]; then
	info "appending to modcont$revext"
	(cd $extractdir/lib/modules/*;
		rm -rf block ipv? misc net pcmcia fs scsi *MODULES )

	(cd $extractdir;
		echo -n "rescue_content=\"" ;
		for i in `find lib/modules -name \*.o`; do
			echo -n `basename $i .o` " ";
		done ;
		echo \" ;
	) >> modcont$revext

#	(cd $extractdir && tar clf - lib/modules | gzip -9) > rescmods$revext.tgz
fi

info "creating linux$revext"
if [ "$revext" = pmac ]; then
	# vmlinux-<version> is the 'work' kernel
	# vmlinux.coff-<version> is the kernel for OF booting
	cp $extractdir/boot/vmlinux-* linux$revext
	cp $extractdir/boot/vmlinux.coff-* linux$revext.coff
else
	if [ "$revext" = "-netwinder" ]; then
		cp $extractdir/boot/Image* linux$revext
	else
		cp $extractdir/boot/vmlinuz* linux$revext
	fi
fi
cat $extractdir/boot/System.map-* | gzip -9 > sys_map$revext.gz
# Copy the config getting rid of comments and blank lines
cat $extractdir/boot/config-* | grep -vE '^(#|$)' | gzip -9 > config$revext.gz
rm -rf $extractdir


