#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "dbootstrap.h"
#include "lang.h"

#ifdef _TESTING_
#  define RELEASE_FILE	"../../scripts/rootdisk/messages/C/release_notes"
#else
#  define RELEASE_FILE	"/release_notes"
#endif

int
release_notes (const char *suffix)
{
	struct stat s;
	int fd;
#ifdef USE_LANGUAGE_CHOOSER
    char *fname = (char *)malloc (PATH_MAX);

    if (suffix != NULL)
        snprintf (fname, PATH_MAX, "%s.%s", RELEASE_FILE, suffix);
    else
        strcpy (fname, RELEASE_FILE);

	if (NAME_ISREG (fname, &s) && (fd=open (fname, O_RDONLY)) >= 0)
#else
	if (NAME_ISREG(RELEASE_FILE, &s) && (fd=open(RELEASE_FILE, O_RDONLY)) >= 0)
#endif
    {
        char *buf = (char *)malloc (s.st_size+1);
        size_t num;

		num = read (fd, buf, s.st_size);
		close(fd);
		buf[s.st_size] = '\0';

		wideMessageBox (buf, _("Release Notes"));

        free (buf);
	}
#ifdef USE_LANGUAGE_CHOOSER
    free (fname);
#endif
	return (0);
}

#ifdef _TESTING_
/* To test, compile using: make release_notes_test */
void main(void){
	LOAD_TRMFILE("test.trm");
	get_kver();
	boxInit();

	release_notes (NULL);

	boxFinished();
}
#endif

