#include <string.h>
#include <sys/types.h>
#include <asm/page.h>
#include <sys/swap.h>
#include <sys/mount.h>
#include <stdio.h>
#include "dbootstrap.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"
#include "notail.h"
#include <newt.h>

int check_for_native_partition (struct fdisk_disk **d, int first);

#if #cpu (s390)
int
attach_disk(void)
{
  char line[255];
  char buffer[255];
  char **plist;
  struct d_choices *choices;
  int rs, items=0;
  FILE * f;
  int i;
 
  choices=malloc(5*sizeof(struct d_choices));
  plist=malloc(5*sizeof(char *));
 
  f = fopen("/proc/subchannels", "r");
  if (f) {
    char device[17];
    char sch[17];
    char devtype[17];
    char devmodel[17];
    char inuse[4];
    char * dasd;
    char * dasddescr;
    fgets(line, sizeof line, f);
    fgets(line, sizeof line, f);
    while (fgets(line, sizeof line, f)) {
      if (sscanf(line, "%s %s %s %s %s ", device, sch, devtype, devmodel, inuse) == 5) {
        if((!memcmp(devtype, "3390", 4) || !memcmp(devtype, "3380", 4) ||
           !memcmp(devtype, "9345", 4) || !memcmp(devtype, "9336", 4) ||
           !memcmp(devtype, "3370", 4)) && strcmp(inuse, "yes")) {
          dasd=malloc(17);
          dasddescr=malloc(35);
          strcpy(dasd, device);
          strcpy(dasddescr, device);
          strcat(dasddescr, " ");
          strcat(dasddescr, devtype);
          choices[items].string=dasddescr;
          choices[items].tag=NULL;
          choices[items].state=0;
          plist[items]=dasd;
          items++;
          if ((items%5)==0) {
            choices = realloc(choices,(items+5)*sizeof(struct d_choices));
            plist = realloc(plist,(items+5)*sizeof(char *));
          }
        }
      }
    }
    fclose(f);
  }

  rs = menuBox(_("Select the disk to attach"), _("Select Disk"),
        choices, items, 1);
  if (rs != -1) {
    snprintf(buffer, sizeof(buffer), "echo add %s >/proc/dasd/devices", plist[rs]);
    execlog(buffer, LOG_INFO);
  }

  fdisk_reread();

  if(rs != -1) { 
  f = fopen("/proc/dasd/devices", "r");
  if (f) {
    int status;
    while (fgets(line, sizeof line, f)) {
      if(!strncasecmp((const char *)line, (const char *)plist[rs],
		      strlen(plist[rs]))) {
        if(!strncasecmp((const char *)line+strlen(line)-3, "n/f", 3)) {
          status=yesNoBox(_("This seems to be a fresh disk not yet prepared for Linux. If it is, you must format the disk before you can create partitions.\n\nFormat the disk?"), _("Format the disk?"));
        } else {
          status=twoButtonBox(_("This seems to be an already low-level formatted disk. If the disk has not been used for Linux 2.4 before it is recommended to format and partition it now.\n\nWARNING: All data on this disk will be IRREVERSIBLY LOST!\n\nFormat the disk now?"), _("Format the disk?"), _("Yes"), _("No"), 2);
        }
        if (status == DLG_YES ) {
          INFOMSG("running dasdfmt on disk %s", plist[rs]);
          snprintf(prtbuf, sizeof(prtbuf), "echo yes | dasdfmt -l LX%s -b 4096 -p -n %s 2>/tmp/dasdfmt.log", plist[rs], plist[rs]);
          status = fullscreen_execlog(prtbuf);
          if(status) {
            snprintf(prtbuf, sizeof(prtbuf), _("dasdfmt has reported a problem, exit status %d. See /tmp/dasdfmt.log for details.\n"), status);
            problemBox(prtbuf,_("Problem"));
          }
          INFOMSG("dasdfmt program returned %d", status);
	  snprintf(buffer, sizeof(buffer), "fdasd -a -l LX%s /dev/dasd/%s/device", plist[rs], plist[rs]);
          status = execlog(buffer, LOG_INFO);
	  INFOMSG("automatic fdasd program returned %d", status);
        }
        break;
      }
    }
    fclose(f);
  }
  }

  for(i=0; i<items; i++) {
    free(plist[i]);
    free(choices[i].string);
  }
  free(choices);
  free(plist);

  return 0;
}
#endif

#if #cpu(powerpc)
int
verify_powerpc_mount(char *mount_point, char *type) {
  /* yaboot can read ext2,ext3,xfs,reiserfs, but crippleware filesystems
     like hfs will break make-bootable.
     quik can only read ext2. */
  if (!strncmp(mount_point, "/target/boot", 12)) {
    if (strstr(Arch2, "PowerMac")) {
      int is_newworld = !strcmp(Arch3, "NewWorld");
      if ((!is_newworld
	   && strcmp(type, "ext2"))
	  || (is_newworld
	      && strcmp(type, "ext2")
	      && strcmp(type, "ext3")
	      && strcmp(type, "xfs")
	      && strcmp(type, "reiserfs")))
	{
	  snprintf(prtbuf, sizeof(prtbuf),
		   _("The file system type you have chosen for /boot "
		     "is not compatible with the %s bootloader. Please "
		     "choose one of: ext2%s%s"),
		   is_newworld ? "yaboot" : "quik",
		   is_ext3 ? " ext3" : "",
		   is_xfs ? " xfs" : "");
	  problemBox(prtbuf, _("Choose another file system"));
	  return 1;
	}
      else if (!(((Arch3 != NULL) && (0 == strcmp(Arch3, "NewWorld")))
		 || (0 == strcmp(Arch2, "chrp"))))
	if (DLG_NO == yesNoBox(_("Quik may not work correctly if a separate "
				 "/boot partition is used. Do you wish to continue "
				 "mounting /boot?"),
			       _("Quik problems with /boot not on /")))
	  return 1;
    }
  }
  return 0;
}
#endif

static struct fdisk_disk *
select_drive(void) {
  struct fdisk_disk *disk,**dlist;
  struct d_choices *choices;
  int rs, items=0;

  choices=malloc(5*sizeof(struct d_choices));
  dlist=malloc(5*sizeof(struct fdisk_disk *));

  /* shell version used try_open here. Why ? */
  
  if (NULL == fdisk_disks) {
    problemBox(_("No hard disk drives could be found. Make sure they are cabled correctly and are turned on before the system is started. You may have to change driver settings when you start the system with a command at the \"boot:\" prompt, or you may have to load a driver that is in a loadable module to solve this problem."), _("No hard disk!"));
    return(NULL);
  }
  
  disk = fdisk_disks;
  while (disk) {
    choices[items].string=disk->name;
    choices[items].tag=NULL;
    choices[items].state=0;
    dlist[items]=disk;
    items++;
    if ((items%5)==0) {
      choices = realloc(choices,(items+5)*sizeof(struct d_choices));
      dlist = realloc(dlist,(items+5)*sizeof(struct fdisk_disk *));
    }
    disk = disk->next;
  }
  /* #### FixMe: ID CD's. */
  rs = menuBox(_("Select the drive to partition. SCSI drives are listed in disk ID number order. Only drives that were connected and operating when the system was started will show up in this display. CD-ROM drives may be mis-identified as writable disk drives by this menu."),
	       _("Select Disk Drive"), choices, items, 1);
  if (rs != -1)
    disk = dlist[rs];
  else
    disk = NULL;

  free(dlist);
  free(choices);
  return(disk);
}

int unmount_dir (char* mount_directory) {
    struct fdisk_partition* p;

    sync();
    sprintf(prtbuf, "cat /proc/mounts | grep -q %s", mount_directory);
    if (system(prtbuf)) {
      DEBUGMSG("%s was not mounted, so it was not unmounted.", mount_directory);
      return 0;
    } else {
      p = fdisk_find_partition_by_mntpoint(mount_directory);
      if (p) {
	INFOMSG("Unmounting partition mounted at %s", mount_directory); 
	sprintf(prtbuf, "umount %s", mount_directory);
	if (execlog(prtbuf, LOG_INFO) != 0) {
/*      char * lobuf;
      int i;
      * sometimes, the loop devices are not cleanly detached. This is
       * extremely nasty, so trying to force the detachment first 
      DEBUGMSG("Something may have gone wrong while remove loop devices, forcing detachment");
      lobuf = (char *) malloc(32);* "/dev/loop0" 
      for(i=0;i<4;i++) {
         sync();
         sprintf(lobuf, "/dev/loop%i", i);
         del_loop(lobuf);
      }
      free(lobuf);
      * retry to umount now *
      if(execlog(prtbuf, LOG_INFO) != 0) { */
	  sprintf(prtbuf, _("Attempting to unmount the partition mounted on "
				       "the directory '%s' failed. This could mean you "
				       "have another process running in a directory under "
				       "'%s', or you have another filesystem mounted on a "
				       "mount point under '%s'."), 
	     mount_directory, p->mount_point, p->mount_point);
	  problemBox(prtbuf, _("Unmount Failed"));
	  return 1;
//	} 
   }else {
	  /* successful unmount */
	  if ( p == Root )
	    Root = NULL;
	  return 0;
	}
      } else {
	DEBUGMSG("Partition not found at %s.", mount_directory);
	return 1;      
      }
    }
}

int partition_disk (void) {
  struct fdisk_disk *d;
  struct fdisk_partition *p;
  char *mounts, *swaps, *tmpbuf, *myfdisk; 
  int root_on_disk=0, status=0, expert=0;
  struct stat statbuf;

  sync();
  mounts = swaps = NULL;

  if (! (d = select_drive())) {
    return(1);
  }

  p = d->partitions;

  while (p) {
    if (p->in_use) {
      if (fdisk_fstype_of(p->type) == FSTYPE_SWAP) {
	if (swaps) {
	  addtolist(&swaps,p->name);
        } else {
	  swaps = strdup(p->name);
        }
      } else {
	if (mounts) {
	  addtolist(&mounts,p->name);
        } else {
          mounts = strdup(p->name);
        }
      }  
    }
    p=p->next_by_disk;
  }
  prtbuf[0]='\0';
  if (mounts)
    snprintf(prtbuf, sizeof(prtbuf), _("You have mounted %s from disk %s . If you choose to go ahead and re-partition %s , the filesystem(s) will be un-mounted, and you can re-mount when you have finished partitioning the disk. If you change a previously existing filesystem, you will have to re-initialize that filesystem before you mount again, and any data you installed on it will be erased.\n")
	    ,mounts,d->name,d->name);
  if (swaps) {
    tmpbuf=(char *)malloc(strlen(swaps)+2*strlen(d->name)+320);
    sprintf(tmpbuf, _("You have activated swap partition(s) on '%s'. If you choose to go ahead and re-partition '%s', your swap partition(s) will be de-activated, and you will have to re-initialize and/or re-activate the swap partition(s) after you have re-partitioned '%s'.\n"),
	    swaps, d->name, d->name);
    strcat(prtbuf, tmpbuf);
    free(tmpbuf);
  }
  if ((mounts) || (swaps)) {
    strcat(prtbuf, _("Re-partition the disk?"));
    if ( yesNoBox(prtbuf, _("Re-partition the disk?")) == DLG_NO )
      return (1);
  }
  if (mounts) {
    mounted_reread();
    p = mounted_partitions;
    while (p) {
      if (strstr(mounts, p->name)) {
	root_on_disk = unmount_dir(p->mount_point);
      }
      p=p->next_in_use;
    }
    free (mounts);
  }
  if (swaps) {
    p = swapon_partitions;
    while (p) {
      if (strstr(swaps, p->name)) {
        INFOMSG("turning off swap on %s so we can re-partition", p->name);
	swapoff(p->name);
      }

      p = p->next_in_use;
    }
    free (swaps);
  }
#if #cpu(ia64)
  /* ia64 has cfdisk and parted.  People should really use parted,
   * and create GPT partition tables.
   */
  {
    struct d_choices partitioner_choices[2] = {
	    { "parted", _("for MSDOS and GPT tables"), 0 },
	    { "cfdisk", _("for MSDOS tables only"), 0 },
    };
#define IA64_PARTED_CHIOCE	0
#define IA64_CFDISK_CHOICE	1
    int rs;
    static char buf[32];

    wideMessageBox(_(
"IA64 EFI firmware supports two partition table formats, GPT and\n"
"MSDOS.  MSDOS is the format traditionally used on Intel based\n"
"PCs, while GPT is a new more flexible format.  You are free to\n"
"use whichever you like, however, it is recommended that you use\n"
"GPT.  In either case, you need to ensure that there is a boot\n"
"partition on the system; with MSDOS that is a partition of type\n"
"EF, and with GPT it is a partition with the boot flag set, and\n"
"containing a FAT filesystem.  The boot partition should be at\n"
"least 32MB.  On the next screen you will choose which disk\n"
"partitioning program to use.  Any of the programs can be used to\n"
"manipulate MSDOS tables, although cfdisk is the easiest to use.\n"
"For GPT you have to use parted.  parted is a command line driven\n"
"program with online help, accessed by typing help at the prompt.\n"
"Because GPT partitions are identified by their contents, rather\n"
"than some identifier in the partition table, it is important that\n"
"you use parted to create filesystems (or swap space) in any GPT\n"
"partitions you create.  One exception is the boot partition,\n"
"which you may not want to format, if it is being shared with\n"
"other operating systems."),
		    _("Disk Partitioning"));
    rs = menuBox(_("You must now select the disk partitioning program "
		"you want to use.  Choose parted for manipulating GPT "
		"tables, or any of the programs for MSDOS tables."),
		_("Select Disk Partitioning Program"), partitioner_choices, 2, 1);
    if (rs < 0)
      return 0;
    if (rs == IA64_CFDISK_CHOICE) {
      if (!strcmp(d->partition_format, "gpt")) {
	if (yesNoBox(_("This disk is formatted with a GPT partition table.  There may "
		       "be partitions on the disk that are only visible under parted.  "
		       "In addition, to switch from using a GPT table to an MSDOS "
		       "table, you must use the parted command 'mklabel msdos'.  "
		       "You may then return to cfdisk to do the actual partitioning "
		       "if you wish.\n\nDo you want to run parted now?"),
			_("GPT table detected")) == DLG_YES)
	  rs = IA64_PARTED_CHIOCE;
      }
    }
    snprintf(buf, sizeof(buf), "/sbin/%s", partitioner_choices[rs].tag);
    myfdisk = buf;
  }
#else
  if (NAME_ISEXE("/sbin/parted", &statbuf)) { /* check whether we have parted */
    if(twoButtonBox( _("This set of boot floppies has various programs for partitioning "
		       "of the hard disk. However, to partition with other programs than "
		       "cfdisk (default) is dangerous, you should not try them if you are "
		       "not an expert or if you don't exactly know what you are doing.  "
		       "Which way do you want to go?"),
		     _("CFDISK or Expert mode?"), _("default"), _("expert only"), 1) == DLG_YES)
      myfdisk="/sbin/cfdisk";
    else {
       expert=1;
      if(twoButtonBox( _("Now you have the choice between: fdisk and parted. Fdisk "
			 "is the old program, but allows to do some tricks with the "
			 "partition table. GNU parted is new, not complete and not "
			 "100%% stable, but has features like fs resizing and moving "
			 "of the partitions. Which one should be invoked now?"),
		       _("fdisk or parted?"), _("fdisk"), _("parted"), 2) == DLG_YES)
	myfdisk="/sbin/fdisk";
      else
	myfdisk="/sbin/parted";
    }
  }
  else { /* no parted present, use default cfdisk */
     myfdisk="/sbin/cfdisk";
  }
#endif

#if #cpu(arm)
  /* on RiscPC, use special Acorn partition editor */
  if (strcmp(Arch2, "riscpc") == 0)
     myfdisk="/sbin/acorn-fdisk";
#endif

#if #cpu(s390)
  myfdisk="/sbin/fdasd";
#endif

#if #cpu(i386)
  if (! bootargs.isquiet)
    wideMessageBox(_(
"Lilo, the LInux LOader, when installed in the Master Boot Record,\n"
"(MBR) and the alternative `mbr' program both have support for large\n"
"disks if you have a modern (newer than early 1994-98) BIOS that\n"
"supports LBA and the \"Enhanced Disk Drive Support Specification\".\n"
"Therefore, if you are certain that your BIOS supports the int 0x13\n"
"large disk access extensions, you may partition your drive however you\n"
"like.\n"
"\n"
"However, if you have an older BIOS, neither Lilo's MBR nor the\n"
"alternative `mbr' will be able to load any block of the kernel from a\n"
"disk cylinder numbered higher than 1023.  This is often a problem with\n"
"disks larger than 528MB, coupled with an older (pre 1995-98, depending\n"
"on the manufacturer) BIOS that does not support the int 0x13 large\n"
"disk access extensions.  If your BIOS supports LBA or CHS Translation\n"
"(aka \"Large\"), but does not have the large disk extensions, the MBR\n"
"will be able to address anything below the translated 1024th cylinder,\n"
"usually around 8GB.\n"
"\n"
"One way to solve the problem is to make a small (5-10Mb) partition at\n"
"the beginning of the disk, so that the entire partition is below the\n"
"1023rd cylinder.  For example, make a 5-10Mb primary partition in the\n"
"low cylinder range, marked bootable, another for swap space, one for\n"
"\"/\", and whatever other partitions you like.  Before you install the\n"
"operating system and modules, after you have mounted your \"/\"\n"
"partition, initialize and mount that small partition on \"/boot\".\n"
"This is where the OS kernel will be stored, and thus, Lilo will find\n"
"that all blocks of the kernel reside below the 1024 cylinder boundary.\n"
"\n"
"Please refer to the partitioning section in the Installation Manual\n"
"for slightly more detailed information and references to relevant\n"
"documentation concerning the BIOS large disk access extensions."
	), _("LILO Limitations"));
#elif #cpu(hppa)
  if (! bootargs.isquiet)
    wideMessageBox(_(
"PALO, the PArisc LOader, requires a partition of type 'f0' on the disk\n"
"it is loaded from.  Therefore, if this disk will contain the boot\n"
"loader you must create a partition of type 'f0' of at least 16MB.\n\n"
"A further important restriction is that the partition you load your\n"
"kernel from must reside within the first 2GB of your disk.  The kernel\n"
"lives in /boot, so you can either keep your root file system within the\n"
"first 2GB, or you can create a small partition and mount it as /boot.\n"),
_("PALO Limitations"));
#elif ( #cpu(mips) && !(defined (MIPSEL)) )
  if (! bootargs.isquiet)
    wideMessageBox(_(
"Dvhtool requires a SGI partition label on the disk it puts the\n"
"kernel onto. Therefore, if this disk will contain the kernel in\n"
"the volume header, you must create a SGI disklabel.\n"),
_("Note on Dvhtool installation"));
#endif

  if((is_reiserfs) && ! bootargs.isquiet)
     wideMessageBox(_(
"NOTE: If you plan to create a Reiser filesystem, don't forget the\n"
"additional space that its Journal will eat up.\n\n"
"Usually you can calculate with: (partition size) = \n"
"(expected free space on ReiserFS) + (32MB for the Journal)\n"),
_("Note on additional space for the ReiserFS Journal"));

  if ( NAME_ISEXE(myfdisk, &statbuf )
#if #cpu(powerpc)
       && ( !strstr(Arch2, "PowerMac"))
#elif #cpu(alpha)
       && ! srm_boot
#elif #cpu(mips)
       && ( strcmp(Arch2, "r4k-ip22") != 0 )
#endif
       ) {

#if #cpu(alpha)
    wideMessageBox(_(
"You appear to be booting from MILO or APB.  In order to\n"
"make Linux bootable from the hard drive, you will need to\n"
"install your bootloader (and, in the case of APB, also your\n"
"kernel) on a DOS FAT partition.  If you do not have any FAT\n"
"partitions already, you should create a small one (5 megabytes\n"
"is more than enough) to hold these files.\n"),
		   _("Note on MILO/APB installation"));
#endif

    INFOMSG("running %s to partition %s", myfdisk, d->name);
    snprintf(prtbuf, sizeof(prtbuf), "%s %s", myfdisk, d->name);
    status = fullscreen_execlog(prtbuf);
    if(expert) {
      prtbuf[0]='\0';
      snprintf(prtbuf, sizeof(prtbuf), _("The partition program %s finished with exit status %i. In most cases this indicates an error. Please repartition and try the default cfdisk program if this error appears again.\n"),myfdisk,status);
       problemBox(prtbuf, _("Error Executing Partition Program."));
       return (1);
    }
#ifdef pc_use_cfdisk_err_ret_switch
    switch (status) {
    case 0:
    default:
	break;
    case 3:
	/* Cannot get geometry -- punt!  Will using fdisk on vc2 do
           any good?  I'm not sure what to do in this case. - karlheg */
        ERRMSG("could not determine the drive geometry of %s, cannot partition", d->name);
	problemBox(_("cfdisk has failed while trying to repartition your disk. It failed to divine the geometry of the drive. Maybe you can switch to the second virtual console with Alt-F2 and investigate the problem using fdisk."), 
                   _("Cannot Determine Drive Geometry."));
	return (1);
	break;
    case 4:
	if (twoButtonBox(_("cfdisk has failed while trying to repartition your disk. That may mean your disk's partition table is corrupt, or your disk is `factory clean'.\nIt often helps to wipe out your disk's current partition table and run cfdisk again.\n\nDo you want me to wipe the disk partition table?\n\nWARNING: You will lose any data currently on that disk.\n"),
		     _("Invalid Partition Table"), _("Yes"), _("No"), 2) == DLG_YES) {
            INFOMSG("re-running cfdisk to ignore existing partition table");
	    snprintf(prtbuf, sizeof(prtbuf), "cfdisk -z %s", d->name);
	    status = fullscreen_execlog(prtbuf);
	}
	break;
    }
#else
    if (status != 0) {
#if #cpu(s390)
	if (twoButtonBox(_("fdasd has failed while trying to partition your disk. That may mean your disk's partition table is corrupt, or your disk is not low-level formatted.\nIt often helps to low level format your disk and wipe out it's current partition table and run fdasd again.\n\nDo you want me to low level format the disk?\n\nWARNING: You will lose any data currently on that disk.\n"),
				                     _("Invalid Partition Table"), _("Yes"), _("No"), 2) == DLG_YES) {
	    INFOMSG("running dasdfmt to format the dasd");
	    snprintf(prtbuf, sizeof(prtbuf), "echo yes | dasdfmt -b 4096 -p -f %s 2>/tmp/dasdfmt.log", d->name);
            status = fullscreen_execlog(prtbuf);
            if(status) {
		snprintf(prtbuf, sizeof(prtbuf), _("dasdfmt has reported a problem, exit status %d. See /tmp/dasdfmt.log for details.\n"), status);
		problemBox(prtbuf,_("Problem"));
	    }
	    INFOMSG("dasdfmt program returned %d", status);
	}
#else
#if #cpu(ia64)
	if (twoButtonBox(_("Partitioning of the disk failed.  cfdisk can fail if your disk's partition table is corrupt, or your disk is `factory clean'.\nIt often helps to wipe out your disk's current partition table and try again.\n\nDo you want me to tell cfdisk to wipe the disk partition table?\n\nWARNING: You will lose any data currently on that disk.\n"),
		     _("Partitioning Failed"), _("Yes"), _("No"), 2) == DLG_YES) {
            INFOMSG("running cfdisk telling it to ignore existing partition table");
	    snprintf(prtbuf, sizeof(prtbuf), "cfdisk -z %s", d->name);
	    status = fullscreen_execlog(prtbuf);
	}
#else
	if (twoButtonBox(_("cfdisk has failed while trying to repartition your disk. That may mean your disk's partition table is corrupt, or your disk is `factory clean'.\nIt often helps to wipe out your disk's current partition table and run cfdisk again.\n\nDo you want me to wipe the disk partition table?\n\nWARNING: You will lose any data currently on that disk.\n"),
		     _("Invalid Partition Table"), _("Yes"), _("No"), 2) == DLG_YES) {
            INFOMSG("re-running cfdisk to ignore existing partition table");
	    snprintf(prtbuf, sizeof(prtbuf), "cfdisk -z %s", d->name);
	    status = fullscreen_execlog(prtbuf);
	}
#endif
#endif
    }
#endif /* pc_use_cfdisk_err_ret_switch */

  } else {
    int first = 1;

    /* FIXME: this should probably be split off into a function that
     gives fdisk instructions for all architectures that use it, so
     that they can be read multiple times (i.e. if the user doesn't do
     the right thing, and can't remember how) */
#if #cpu(alpha)
    /* Note that we only get here when using fdisk, i.e. on SRM */
    wideMessageBox(_(
"You appear to be booting from the SRM console.  In order to\n"
"make Linux bootable from the hard drive, you will need to\n"
"create an OSF/1 style disklabel rather than a DOS partition\n"
"table.  Since the 'cfdisk' program is unable to create OSF/1\n"
"disklabels, I will start 'fdisk' instead.  You must use the\n"
"'b' command to enter disklabel mode.\n\n"
"As well, because the 'aboot' second-stage bootloader must\n"
"occupy the first sector of the disk, you will need to leave\n"
"about a megabyte of empty space before the first partition.\n"
"On most drives, it should suffice to start the 'a' partition\n"
"at cylinder 2, or the equivalent in sectors (use the 'u'\n"
"command to switch units, and the 'm' command for help.)\n\n"
"If you don't want to access this disk from any other OS than\n"
"Linux, you should delete the partition 'c' created by fdisk\n"
"on a new disklabel."),
		   _("Using fdisk on SRM"));
#elif #cpu(powerpc)
    if ( ! bootargs.isquiet ) {
    /* Yaboot check: NewWorld PowerMacs */
        if ( ( strstr ( Arch2, "PowerMac" ) ) && ( NULL != Arch3 ) &&
	     	( 0 == strcmp( Arch3, "NewWorld" ) ) ) {
    		wideMessageBox(_(
"The yaboot bootloader requires an 800K Apple_Bootstrap (case sensitive)\n"
"partition on the same disk as the root partition. It is best if the \n"
"Apple_Bootstrap partition is the first on the disk.\n\n"
"You can create the bootstrap partition using the 'b' command in mac-fdisk.\n\n"
"If you do not plan to keep MacOS installed on this disk, you can and\n"
"should remove all of its 'driver' partitions, this can be done using the\n"
"'i' command in mac-fdisk.  The 'i' command creates a new empty partition table.\n"
"If you wish to preserve any existing partitions, do *not* use the 'i' command.\n"
		), _("Notes On Partitioning NewWorld PowerMacs"));
	}
    /* Yaboot check: CHRP */
	else if ( 0 == strcmp( Arch2, "chrp" ) ) {
    		wideMessageBox(_(
				 "The yaboot bootloader, requires an 800K bootstrap partition of type 0x41\n"
				 "on the same disk as the root partition.  It is best if this partition\n"
				 "is the first partition on the disk."),
			       _("Notes On Partitioning CHRP PowerPCs"));
	}
    /* Quik */
	else {
    		wideMessageBox(_(
"If you intend to use Quik as your bootloader, do not create a separate\n"
"/boot partition. Also, the root partition should precede other Linux\n"
"partitions on the disk because Quik writes the boot block to it."
		), _("Notes On Partitioning For Quik"));
	}
    }
#endif

    while (check_for_native_partition(&d, first) != 0) {
      INFOMSG("running fdisk to partition %s", d->name);
      snprintf(prtbuf, sizeof(prtbuf), "fdisk %s", d->name);
      status = fullscreen_execlog(prtbuf);
      first = 0;
    }
  }
  INFOMSG("partition program returned %d", status);
  if (root_on_disk && 
      yesNoBox(_("You changed the partition scheme on a disk which is currently mounted.  Often, in order to work with the new partitions, you may need to reboot the system.  If you reboot, you will be able to carry on with installation from where you left off.\n\nReboot now?"),
	       _("Reboot the system?")) == DLG_YES) {
    INFOMSG("partition changed on mounted disk, rebooting");
    reboot_system();
  }
  return 0;
}

static int
mount_partition (struct fdisk_partition *partition)
{
  char             *mount_point, *real_mount_point, *type;
  int              status = -1;
  struct stat      statbuf;

  /* screen is sometimes not cleared, forcing */
  newtCls();

  if (!(type = fdisk_fstype_name_of (partition->type)))
  {
    snprintf (prtbuf, sizeof(prtbuf), _("Don't know which filesystem type to use for partition %s of type '%s'."),
	     partition->name, fdisk_sysname (partition->type));
    problemBox (prtbuf, _("Invalid filesystem"));
    return 1;
  }
  if (! Root) {
    snprintf(prtbuf, sizeof(prtbuf), _("You must mount your root filesystem (\"/\") before you can mount any other filesystems. Would you like to mount %s as the root filesystem?"),
	    partition->name); 
    if (! bootargs.isquiet &&
	  yesNoBox(prtbuf, _("Mount as the Root Filesystem?")) != DLG_YES)
      return 1;
    mount_point = strdup("/");
    real_mount_point=strdup("/target");
  }
  else
  {
    struct d_choices mount_points[5];
    int i = 0;

    if (fdisk_find_partition_by_mntpoint("/target/boot") == NULL)
    {
      mount_points[i  ].tag    = "/boot";
      mount_points[i++].string = _("A small (5-10Mb) partition at the start of the disk.");
    }
    if (fdisk_find_partition_by_mntpoint("/target/usr") == NULL)
    {
      mount_points[i  ].tag    = "/usr";
      mount_points[i++].string = _("A large partition where most software resides.");
    }
    if (fdisk_find_partition_by_mntpoint("/target/var") == NULL)
    {
      mount_points[i  ].tag    = "/var";
      mount_points[i++].string = _("Variable data such as mail spools and databases.");
    }
    if (fdisk_find_partition_by_mntpoint("/target/home") == NULL)
    {
      mount_points[i  ].tag    = "/home";
      mount_points[i++].string = _("User home directories.");
    }
    if (i > 0)
    {
      mount_points[i].tag    = _("Other");
      mount_points[i].string = _("Enter name of a different mount point.");
    }
 
    snprintf(prtbuf, sizeof(prtbuf), _("Select the mount point for %s"), partition->name);
    status = -1;
    if (i > 0) {
	if ((status = menuBox(prtbuf, _("Select Mount Point"), mount_points, i+1, 1)) < 0)
	    return 1;
    }
    if (status == i || status == -1) { 
      /* user selected "Other", or all regular mount points are taken */
      mount_point = inputBox(prtbuf, _("Select Mount Point"), "/");
      if (! mount_point) 
	return DLG_CANCEL;
      if ( strcmp(mount_point, "/etc") == 0 ) {
        problemBox(_("You cannot set /etc as a mount point.  This directory is required to boot."),
                   _("Problem"));
        return 1;
      }
    }
    else {
      mount_point = strdup(mount_points[status].tag);
    }
    if (NULL == mount_point) return 1;
    real_mount_point = (char *)malloc(9 + strlen(mount_point));
    strcpy(real_mount_point, "/target");
    if (mount_point[0] != '/')
	strcat(real_mount_point, "/");
    strcat(real_mount_point, mount_point);
  }

  if (! NAME_ISDIR( real_mount_point, &statbuf ) ) {
    int WithMode;
    char *p = strchr(real_mount_point, '/');
    p = strchr(p + 1, '/');
    while (1) {
	if ((p = strchr(p + 1, '/')) != NULL)
	    *p = '\0';
	WithMode = strcmp(real_mount_point,"/target/tmp") &&
	           strcmp(real_mount_point,"/target/var/tmp")
	         ? 0755 : 01777;
	DEBUGMSG("making mount point %s", real_mount_point);
	if (! mkdir(real_mount_point, WithMode)) {
	    chmod(real_mount_point, WithMode);
	    chown(real_mount_point, 0, 3); /* root.sys, may be overriden when base is installed */
	} else if (errno != EEXIST){
	    snprintf(prtbuf, sizeof(prtbuf), _("Failed to create directory %s"), real_mount_point);
	    perrorBox(prtbuf);
	    free(real_mount_point);
	    free(mount_point);
	    return 1;
	}
	if (p)
	    *p = '/';
	else
	    break;
    }
  }
  
  if (!strcmp(type, "ext2")) { /* only Linux Native partitions can have these filesystems */
    if ((is_reiserfs) || (is_xfs) || (is_ext3)) {
      FILE *fd;
      char xfsmagic[6];
      char e2fsmagic[4];
      char shfsmagic[11];


      bzero(xfsmagic, sizeof(xfsmagic));
      bzero(e2fsmagic, sizeof(e2fsmagic));
      bzero(shfsmagic, sizeof(shfsmagic));


      fd = fopen(partition->name, "r");
      if (!fd)
	return 1;

      fread (xfsmagic, 5, 1, fd);
      fseek (fd, 65588, SEEK_SET);
      fread (shfsmagic, 10, 1, fd);
      fseek (fd, 1116, SEEK_SET);
      fread (e2fsmagic, 1, 4, fd);

      /* EXT3_FEATURE_COMPAT_HAS_JOURNAL = 0x0004 */
      if ((*e2fsmagic & 0x0004) && is_ext3)
         strcpy(e2fsmagic, "3");  /* reuse it*/
      else
         strcpy(e2fsmagic, "2");

      if (!(strcmp(xfsmagic, "XFSB"))) { /* XFS */
#if #cpu(powerpc)
	if (verify_powerpc_mount(mount_point, "xfs"))
	  return 1;
#endif
	INFOMSG("Mounting XFS partition %s on %s", partition->name, mount_point);
	snprintf(prtbuf, sizeof(prtbuf), "mount -t xfs %s %s", partition->name, real_mount_point);
	status = execlog(prtbuf, LOG_INFO);
      }

      /* thanks to journey@jps.net for the clue about the reiserfs magic number */
      else if (!(strcmp(shfsmagic, "ReIsErFs") && strcmp(shfsmagic, "ReIsEr2Fs"))) /* reiserfs */
	{
#if #cpu (powerpc)
	if (verify_powerpc_mount(mount_point, "reiserfs"))
	  return 1;
#endif
#if 0
	  snprintf(prtbuf, sizeof(prtbuf), _("The \"notail\" option is required on the /boot "
					     "partition for LILO to work properly, and is also "
					     "useful for some other partitions (such as qmail mail "
					     "queue directories).\nIf you do not plan on using LILO "
					     "as a boot loader, you may say No.\n\n"
					     "If in doubt, say yes. It is the safe thing to do.\n\n"
					     "Do you want to mount %s (%s) with the \"notail\" flag?"),
		   mount_point, partition->name);
	  status = yesNoBox(prtbuf, _("Mount with \"notail\"?"));
	  if (status == DLG_YES)
	    {
	      addnotail (partition->name);
	      addnotail (real_mount_point);
	    }
#endif	  
	  INFOMSG("Mounting ReiserFS partition %s on %s", partition->name, real_mount_point);
	  snprintf(prtbuf, sizeof(prtbuf), "mount -t reiserfs -o %s %s %s",
		   status==DLG_YES ? "defaults,notail" : "defaults",
		   partition->name, real_mount_point);
	  status = execlog(prtbuf, LOG_INFO);
	}
      else if (is_ext3) { /* ext2/ext3 */
	if (!strcmp(mount_point, "/boot")) {
	  if (
#if #cpu (powerpc) /* OldWorld PowerPC must use ext2 for /boot */
	      strcmp(Arch3,"NewWorld")
#else
	      0
#endif
	      ) {
	    INFOMSG("Mounting ext2 partition %s on %s", partition->name, real_mount_point);
	    snprintf(prtbuf, sizeof(prtbuf), "mount -t ext2 %s %s",
		     partition->name, real_mount_point);
	  } else {
	    INFOMSG("Mounting ext%s partition %s on %s", e2fsmagic, partition->name, real_mount_point);
	    snprintf(prtbuf, sizeof(prtbuf), "mount -t ext%s %s %s",
		     e2fsmagic, partition->name, real_mount_point);
	    status = execlog(prtbuf, LOG_INFO);
	  }
	} else { /* ext2/ext3, not /boot */
	  INFOMSG("Mounting ext%s partition %s on %s", e2fsmagic, partition->name, real_mount_point);
	  snprintf(prtbuf, sizeof(prtbuf), "mount -t ext%s %s %s",
		   e2fsmagic, partition->name, real_mount_point);
	  status = execlog(prtbuf, LOG_INFO);
	}
      }
      else { /* ext2, ext3 not supported */
	INFOMSG("Mounting ext2 partition %s on %s", partition->name, real_mount_point);
	snprintf(prtbuf, sizeof(prtbuf), "mount -t ext2 %s %s",
		 partition->name, real_mount_point);
	status = execlog(prtbuf, LOG_INFO);
      }
    }
    else { /* ext2 only, no other supported filesystems */
      INFOMSG("Mounting ext2 partition %s on %s", partition->name, real_mount_point);
      snprintf(prtbuf, sizeof(prtbuf), "mount -t ext2 %s %s",
	       partition->name, real_mount_point);
      status = execlog(prtbuf, LOG_INFO);
    }
  }
  else { /* not a Linux Native partition, use partition type to determine fstype. */
    /* if libfdisk reported msdos but we have vfat support, use vfat */
    if(strcmp(type,"msdos")==0 && !is_filesystem_supported("vfat"))
       type="vfat";
    INFOMSG("Mounting %s partition %s on %s", type, partition->name, real_mount_point);
    snprintf(prtbuf, sizeof(prtbuf), "mount -t %s %s %s", type, partition->name, real_mount_point);
    status = execlog(prtbuf, LOG_INFO);
  }
  
  if (status) {
    perrorBox(_("Mount failed"));
    free(real_mount_point);
    free(mount_point);
    return 1;
  } else {
    /*   INFOMSG("Mounted %s partition %s on %s", type, partition->name, real_mount_point); */
  }

  if (!strcmp(mount_point, "/")) {
    Boot = Root = partition;
    if (NAME_ISDIR("/target/lib/modules", &statbuf)) {
      /* we just mounted a partition with kernel and modules already
         installed, so we want to adjust modules symlink */
      frob_lib_modules();
      execlog("depmod -a", LOG_INFO);
    }
  }
  else if (!strcmp(mount_point, "/boot"))
    Boot = partition;

  free(mount_point);
  return 0;
}

/* returns non-zero for "yes, we want cflag" */
static int get_cflag (const char *name) {
#if !(#cpu(s390))
  struct stat statbuf;

  if (! NAME_ISEXE("/sbin/badblocks", &statbuf) ||
      bootargs.isquiet )
#endif
    return 0;

  snprintf(prtbuf, sizeof(prtbuf), _("The system can scan the entire partition "
				     "for un-readable disk blocks and will mark "
				     "any such bad blocks it finds so that they "
				     "will not be used. This requires that every "
				     "block be read, and thus could take a long time, "
				     "but may save you trouble later.  "
				     "Modern disk controllers generally do not need this, "
				     "since they can identify and deal with bad blocks "
				     "automatically, so the default is not to perform this check.\n\n"
				     "Run a bad-block scan on '%s'?"), name);
  return ( twoButtonBox(prtbuf, _("Scan for Bad Blocks?"), _("Yes"), _("No"), 2) == DLG_YES );
}

int init_xfs (void) {
  struct fdisk_partition *p;
  int status;
  int cflag;

  sync();
  p = select_not_mounted(_("Please select the partition to initialize as a Linux \"XFS\" filesystem."),
			 _("Select Partition"), 1, FSTYPE_EXT2); /* FSTYPE_EXT2 should be renamed FSTYPE_LINUX */
  if (!p)
    return 1;

  if (p->size < 16384) {
    problemBox(_("Sorry, this partition has less than 16MB which is the "
		 "minimum size of an XFS filesystem.  Please repartition "
		 "or use another filesystem type."), _("Minimum XFS partition size")); 
    return 1;
  }

  cflag = get_cflag(p->name);

  if (! bootargs.isquiet) {
    snprintf(prtbuf, sizeof(prtbuf), _("You have chosen to initialize %s as a Linux \"XFS\" filesystem. "
		     "This will permanently erase any data on this partition. "
		     "Are you sure you want to do this?"), p->name);
    if (yesNoBox(prtbuf, _("Are You Sure?")) == DLG_NO)
      return 1;
  }

  if (cflag) {
    INFOMSG("Checking %s for bad blocks", p->name);
    snprintf(prtbuf, sizeof(prtbuf), "badblocks -sv %s", p->name);
    boxSuspend();
    printf(CLEAR);
    printf(_("Checking %s for bad blocks...\n"), p->name);
    status = system(prtbuf);
    if (status) {
      ERRMSG("badblock scan with cmd '%s' failed (%d)", prtbuf, status);
      problemBox(_("The filesystem was not created."), _("Problem"));
      return 1;
    }
  }

  INFOMSG("Creating XFS filesystem on %s", p->name);
  snprintf(prtbuf, sizeof(prtbuf), "mkfs.xfs -f %s", p->name);
  boxSuspend();
  if (!cflag)
    printf(CLEAR);
  printf(_("Creating XFS filesystem...\n"));
  DEBUGMSG("Creating XFS filesystem on %s with cmd: %s", p->name, prtbuf);
  status = system(prtbuf);
  boxResume();
  if (status) {
    ERRMSG("Filesystem creation with cmd '%s' failed (%d)", prtbuf, status);
    problemBox(_("The filesystem was not created."), _("Problem"));
    return 1;
  }
  return mount_partition(p);
}

int init_ext (const char *ver)
{
  struct fdisk_partition *p;
  int cflag, status;
  char *jflag;
  const char *extra_hint = "";
  int Oflag = DLG_NO;		/* most people don't need the old linux 2.0 version ext2 */

  if (!strcmp(ver, "2"))
    jflag = "";
  else if (!strcmp(ver, "3"))
    jflag = "-j";
  else
    return 1;

  sync();
  snprintf(prtbuf, sizeof(prtbuf), _("Please select the partition to initialize as a Linux "
				     "\"Ext%s\" filesystem."), ver);
  p = select_not_mounted(prtbuf, _("Select Partition"), 1, FSTYPE_EXT2);
  if (! p)
    return 1;

#if #cpu(arm)
  extra_hint = _(", or with the Netwinder firmware");
  Oflag = DLG_YES;
#elif #cpu(alpha)
  if (!srm_boot) {
    extra_hint = _(", or with the MILO bootloader 2.0.x");
    Oflag = DLG_YES;
  }
#endif
  
#if !(#cpu(mips) || #cpu(s390))
  if (bootargs.isverbose) {
    snprintf(prtbuf, sizeof(prtbuf), _("This version of the Linux kernel has new \"Ext%s\" filesystem "
				       "features not present in kernel versions prior to 2.2.x. "
				       "Using these features, however, means that you will not be "
				       "able to use this filesystem with earlier kernels, such as "
				       "Linux 2.0%s.\n\n"
				       "Do you want to retain Linux kernel 2.0 compatibility?"),
	     ver, extra_hint);
    Oflag = twoButtonBox(prtbuf, _("Pre-2.2 Linux Kernel Compatibility?"),
			 _("Yes"), _("No"), Oflag);
  }
#endif

  cflag = get_cflag(p->name);

  if (! bootargs.isquiet) {
    snprintf(prtbuf, sizeof(prtbuf), _("You have chosen to initialize %s as a Linux "
				       "\"Ext%s\" filesystem. This will permanently "
				       "erase any data on this partition.\n\n"
				       "Are you sure you want to do this?"), p->name, ver);
    if (yesNoBox(prtbuf, _("Are You Sure?")) == DLG_NO)
      return 1;
  }

  INFOMSG("Initializing partition %s as Ext%s for kernel %s or better", 
          p->name, ver, ( Oflag == DLG_NO ? "2.2" : "2.0"));

#if #cpu(s390)
  /* s390 requires that dasdfmt block size and mke2fs block size are the same,
     we choose block size 4096 */
  snprintf(prtbuf, sizeof(prtbuf), "mkfs.ext2 %s -b 4096 %s %s",
            jflag, ( cflag ? "-c" : ""), p->name);
#else 
#if #cpu(alpha)
  /* Alpha-specific workaround for MILO's failure to support 4k blocks */
  if (!(srm_boot || strcmp(Arch2, "nautilus") == 0))
    snprintf(prtbuf, sizeof(prtbuf), "mkfs.ext2 %s -O none -b 1024 %s %s",
	    jflag, ( cflag ? "-c" : ""), p->name);
  else
#endif
  snprintf(prtbuf, sizeof(prtbuf), "mkfs.ext2 %s %s %s %s", jflag, ( Oflag == DLG_NO ? "" : "-O none"),
	  ( cflag ? "-c" : ""), p->name);
#endif
  boxSuspend();
  printf(CLEAR);
  if ( Oflag == DLG_YES )
    printf(_("Creating Ext%s filesystem (with 2.0 kernel compatibility)...\n"), ver);
  else
    printf(_("Creating Ext%s filesystem (for 2.2 and newer kernels only)...\n"), ver);

  DEBUGMSG("Creating filesystem on %s with cmd: %s", p->name, prtbuf);
  status = system(prtbuf);
  boxResume();

  if (status) {
    ERRMSG("Filesystem creation with cmd '%s' failed (%d)", prtbuf, status);
    problemBox(_("The filesystem was not created."), _("Problem"));
    return 1;
  } else
    return mount_partition(p);
}

int init_reiserfs (void) {
  struct fdisk_partition *p;
  int status;
  int cflag, rfsver=2;

  sync();
  p = select_not_mounted(_("Please select the partition to initialize as a Linux \"ReiserFS\" filesystem."),
			 _("Select Partition"),1,FSTYPE_EXT2); /* FSTYPE_EXT2 should be renamed FSTYPE_LINUX */
  if (! p)
    return 1;

  if(p->size < 32848) {
    problemBox(_("Sorry, this partition has less than 8212 blocks (32 MB) which "
		 "are required to create a ReiserFS journal.  Please repartition "
		 "or use another filesystem type."), _("Minimum ReiserFS partition size"));
    return 1;
  }

  cflag = get_cflag(p->name);

  if (! bootargs.isquiet) {
    snprintf(prtbuf, sizeof(prtbuf), _("You have chosen to initialize %s as a Linux \"ReiserFS\" filesystem.  "
		     "This will permanently erase any data on this partition. Are you sure "
		     "you want to do this?"), p->name);
    if (yesNoBox(prtbuf, _("Are You Sure?")) == DLG_NO)
      return 1;
  }
  
  if (bootargs.isverbose && (strcmp(kver,"2.4.0") > 0) ) { 
    if (yesNoBox( _("The running kernel supports the new ReiserFS format 3.6. "
				       "This version should be more stable than the default version 3.5.\n\n"
				       "Unfortunately, stable kernel versions "
				       "prior to version 2.4.1 cannot mount a such filesystem.  "
				       "Would you like to use the new version?\n\nIf you plan to run kernel 2.2.x (with ReiserFS patches), say No.") , _("Use ReiserFS format 3.6?")) == DLG_NO)
        rfsver=1;
  }

  if (cflag) {
    INFOMSG("Checking %s for bad blocks", p->name);
    snprintf(prtbuf, sizeof(prtbuf), "badblocks -sv %s", p->name);
    boxSuspend();
    printf(CLEAR);
    printf(_("Checking %s for bad blocks...\n"), p->name);
    status = system(prtbuf);
    if (status) {
      ERRMSG("badblock scan with cmd '%s' failed (%d)", prtbuf, status);
      problemBox(_("The filesystem was not created."), _("Problem"));
      return 1;
    }
  }

  INFOMSG("Initializing partition %s as ReiserFS", p->name);
  snprintf(prtbuf, sizeof(prtbuf), "mkreiserfs -q --format %s -f -f %s", (rfsver == 1 ? "3.5" : "3.6"), p->name);
  boxSuspend();
  if (!cflag)
    printf(CLEAR);
  printf(_("Creating filesystem...\n"));
  DEBUGMSG("Creating ReiserFS filesystem on %s with cmd: %s", p->name, prtbuf);
  status = system(prtbuf);
  boxResume();
  if (status) {
    ERRMSG("Filesystem creation with cmd '%s' failed (%d)", prtbuf, status);
    problemBox(_("The filesystem was not created."), _("Problem"));
    return 1;
  }
  return mount_partition(p);
}

int init_linux (void) {
  if ((is_xfs) || (is_ext3) || (is_reiserfs)) {
    struct d_choices fs_list[4];
    char *fschoice;
    char bootnotes[PRTBUFSIZE];
    int i = 0;
    int status;

#if #cpu (powerpc)
    if ((strstr(Arch2, "PowerMac")) && (!strcmp(Arch3, "OldWorld")))
      snprintf(bootnotes, sizeof(bootnotes), _("\nNote that quik can only read Ext2 filesystems.  "
					       "To use quik you must use the Ext2 filesystem for "
					       "your root partition.\n\n"));
    else
      snprintf(bootnotes, sizeof(bootnotes), "\n");
#elif #cpu (sparc)
    if (is_xfs)
      snprintf(bootnotes, sizeof(bootnotes), _("\nNote that SILO can only read Ext2 filesytems.  "
					       "You must use the Ext2 filesystem for your root "
					       "partition.  Also note that you must not create an "
					       "XFS filesystem on the first partition of the disk.\n\n"));
    else
      snprintf(bootnotes, sizeof(bootnotes), _("\nNote that SILO can only read Ext2 filesytems.  You "
					       "must use the Ext2 filesystem for your root partition.\n\n"));
#elif #cpu (i386)
    if (is_xfs)
      snprintf(bootnotes, sizeof(bootnotes), _("\nNote that you must not install LILO onto an XFS partition.  "
					       "If your root partition is XFS then you must install LILO "
					       "in the MBR and not in the root partition's boot sector.\n\n"));
    else
      snprintf(bootnotes, sizeof(bootnotes), "\n");
#else
    snprintf(bootnotes, sizeof(bootnotes), "\n");
#endif

    fs_list[i  ].tag    = "Ext2";
    fs_list[i++].string = _("Traditional GNU/Linux filesystem");

    if (is_ext3) {
      fs_list[i  ].tag    = "Ext3";
      fs_list[i++].string = _("Next Generation of Ext2, a journaling filesystem");
    }
    if (is_xfs) {
      fs_list[i  ].tag    = "XFS";
      fs_list[i++].string = _("SGI's advanced, fast, mature journaling filesystem");
    }
    if (is_reiserfs) {
      fs_list[i].tag      = "ReiserFS";
      fs_list[i++].string = _("Younger less mature journaling filesystem");
    }

    status = -1;
    snprintf(prtbuf, sizeof(prtbuf), _("Ext2 is the traditional, standard filesystem for GNU/Linux.  "
				       "It is well tested and proven, however there are alternatives "
				       "available which provide more advanced features, particularly "
				       "journaling.\n\n"
				       "Below is the list of available filesystems.\n%s"
				       "If in doubt choose Ext2.\n"), bootnotes);
    status = menuBox(prtbuf, _("Choose Filesystem Type"), fs_list, i, 1);

    if (status == -1) {
       /* screen is sometimes not cleared, forcing */
       newtCls();

       return 1; /* Cancelled */
    }
    else
       fschoice = strdup(fs_list[status].tag);
    /* screen is sometimes not cleared, forcing */
    newtCls();

    if (!strcmp(fschoice, "Ext2"))
      return init_ext("2");
    else if (!strcmp(fschoice, "Ext3"))
      return init_ext("3");
    else if (!strcmp(fschoice, "XFS"))
      return init_xfs();
    else if (!strcmp(fschoice, "ReiserFS"))
      return init_reiserfs();
    else {
      problemBox(_("Something wicked happened when choosing filesystem type"),
		 _("Bad Thing"));
      return 1;
    }
  } else /* only ext2 is available */
    return init_ext("2");
}

int init_swap (void) {
  struct fdisk_partition *p;
  int cflag, status;

  sync();
  p = select_not_mounted(_("Please select the partition to initialize as a swap device."),
			 _("Select Swap Partition"), 1, FSTYPE_SWAP);
  if (! p)
    return 1;
  cflag = get_cflag(p->name);
  if ( ! bootargs.isquiet ) {
       snprintf(prtbuf, sizeof(prtbuf), _("You have chosen to initialize %s as a swap device. "
					  "This will permanently erase any data on this partition. "
					  "Are you sure you want to do this?"), p->name);
    if ( yesNoBox(prtbuf, _("Are You Sure?")) == DLG_NO )
      return 1;
  }
  INFOMSG("formatting swap partition %s %s",
          p->name, ( cflag ? "with bad block check" : "" ));
#if #cpu(sparc)
  snprintf(prtbuf, sizeof(prtbuf), "mkswap -v1 %s %s",( cflag ? "-c" : ""),p->name);
#else
  snprintf(prtbuf, sizeof(prtbuf), "mkswap %s %s",( cflag ? "-c" : ""),p->name);
#endif
  boxSuspend();
  printf(CLEAR);
  printf(_("Initializing swap partition...\n"));
  status=system(prtbuf);
  boxResume();
  if (status) {
    problemBox(_("The swap partition could not be initialized."),_("Problem"));
    return 1;
  }
  if (swapon(p->name, 0)) {
    snprintf(prtbuf, sizeof(prtbuf), _("The swap partition %s could not be activated"),p->name);
    perrorBox(prtbuf);
    return 1;
  }
  return 0;
}

int no_swap (void) {
  struct fdisk_partition *p;
  
  if (bootargs.isquiet || 
      yesNoBox( _("A swap partition is a good idea for all systems, even ones with lots of memory. It's strongly encouraged that you create one.\n\nIf you have less than 14 megabytes of RAM in your system, you will need to create a swap partition simply so that there is enough virtual memory to finish the installation.\n\nIf you answer \"Yes\" to the following question, the system will not require you to create a swap partition. It's strongly advised that you answer \"No\".\n\nWould you like to do without a swap partition?"),
		_("Do Without a Swap Partition")) == DLG_YES ) {
    INFOMSG("doing without a swap partition");
    if (swapon_partitions) {
      p = swapon_partitions;
      while (p) {
        swapoff(p->name);
        p = p->next_in_use;
      }
    }
    noSwap = 1;
  }
  return 0;
}

int mount_any (void) {
  struct fdisk_partition *p;

  int ntypes = 6;
#ifdef NFSROOT
  /* We allow this for NFSROOT, and check for network config there */
  ntypes++;
#endif
  p=select_not_mounted( _("Please select the partition to mount."), _("Select Partition"), ntypes,
		FSTYPE_EXT2,FSTYPE_MINIX,FSTYPE_MSDOS,FSTYPE_AFFS,FSTYPE_HFS,FSTYPE_ADFS, FSTYPE_NFS);
  if (!p) return 1;
  return mount_partition(p);
}

int unmount_any (void) {
  struct fdisk_partition *p;
  p = select_mounted(_("Select the partition to unmount"), _("Select Partition"));
  if (p == NULL) return 1;
  return unmount_dir(p->mount_point);
}

int activate_swap (void) {
  struct fdisk_partition *p;

  p = select_not_mounted(_("Please select the partition to activate as a swap device."),
			 _("Select Swap Partition"), 1, FSTYPE_SWAP);
  if (! p)
    return 1;

  if ( ! bootargs.isquiet ) {
    snprintf(prtbuf, sizeof(prtbuf), _("You have chosen to activate %s as a swap device. This will permanently erase any data on this partition. Are you sure you want to do this?"),
	    p->name);
    if ( yesNoBox(prtbuf, _("Are You Sure?")) == DLG_NO )
      return 1;
  }
  if (swapon(p->name, 0)) {
    snprintf(prtbuf, sizeof(prtbuf), _("The swap partition %s could not be activated"),
	    p->name);
    perrorBox(prtbuf);
    return 1;
  }
  return 0;
}

int view_partitions (void) {
  struct fdisk_disk *d;
  struct fdisk_partition *p;

  d = fdisk_disks;
  if (d) {
    /*
     *  TRANS: This allows nice formatting for partition table.
     *
     *  Formatting chart:
     *
     * |         1         2         3         4         5         6         7         8
     * |12345678901234567890123456789012345678901234567890123456789012345678901234567890
     * |                                                                     |
     * |      123456789          12345678901234567                           |
     * |Device         Mounted on                 Type                       |
     * |-------------  -------------------------  -------------------------  |
     * |/dev/hda1      /target/boot               Linux native               |
     * |/dev/hda2      swap                       Linux swap                 |
     * |/dev/hda3      /target                    Linux native               |
     * |/dev/hda4       -- N/A --                 DOS Extended               |
     * |/dev/hda5      /target/usr                Linux native               |
     * |/dev/hda6      /target/var                Linux native               |
     * |/dev/hda7      /target/home               Linux native               |
     * |/dev/hda8      /target/usr/local          Linux native               |
     * |/dev/hda9       -- Not mounted --         Linux native               |
     * |1234567890123  1234567890123456789012345  1234567890123456789012345  |
     * |             12                         12                           |
     *
     * karlheg -> Longest device name I know about is: /dev/ida/c0d0 == 13 chars.
     */
    strcpy(prtbuf, _("The following partitions have been detected:\n"
		     "\n"
		     "Device         Mounted on                 Type\n"
		     "-------------  -------------------------  -------------------------"));
    strcat(prtbuf, "\n");
    while (d) {
      p = d->partitions;
      if (p) {
        while (p) {
	  char *mp;
	  /* Use fstype to reduce the number of compares needed in this IF statement */
	  int fstype = fdisk_fstype_of(p->type);
	  if (fstype == FSTYPE_SWAP) {
	    mp = (p->in_use) ? _("swap") : _(" -- Not in use --");
	  }
	  else if ((fstype == FSTYPE_EXTPART) || (fstype == FSTYPE_UNKNOWN))
	  {
	    mp = _(" -- Not available --");
	  }
	  else {
	    mp = (p->mount_point) ? p->mount_point : _(" -- Not mounted --");
	  }
          snprintf(prtbuf + strlen(prtbuf), (size_t)71, /* No more than 70 characters per line. */
		   _("%-13s  %-25s  %-25s\n"), p->name, mp, fdisk_sysname(p->type));
          p = p->next_by_disk;
        }
      } else {
        sprintf(prtbuf + strlen(prtbuf),
		_("Disk %s has no partitions defined!"), d->name);
	strcat(prtbuf, "\n");
      }
      d = d->next;
      strcat(prtbuf, "\n");
    }
    wideMessageBox(prtbuf, _("Partitions List"));
    return 0;
  } else {
    problemBox(_("No hard disk drives could be found. Make sure they are cabled correctly and are turned on before the system is started. You may have to change driver settings when you start the system with a command at the \"boot:\" prompt, or you may have to load a driver that is in a loadable module to solve this problem."), _("No hard disk!"));
    return 1;
  }
}

/*
 * Check for a partition table that could be understood by the boot monitor
 * (eg. SMD disk label on sparc, MS-DOS partition table on x86, ...)
 *
 * This function should return 1 to continue running fdisk again and again.
 * It is called the first time just before running fdisk (with first=1)
 * therefore it should return 1 at least once.
 */
int check_for_native_partition( struct fdisk_disk **d, int first ) {
  /* check for non native disk label before running fdisk */
  if (! first) {
    /* before checking for some kind of partition table format, the disk
     * should be reread because the partition table could have changed.
     * Note1: don't have to be done the first time.
     * Note2: since d will not be valid past fdisk_reread(), we need to
     *        reassign it after the call. */
    struct fdisk_disk *disk;
    char *diskname = strdup( (*d)->name );
    fdisk_reread();
    disk = fdisk_disks;
    while (disk) {
      if (0 == strcmp( diskname, disk->name ))
	break;
      disk = disk->next;
    }
    free( diskname );
    *d = disk;
  }
#if #cpu(sparc)
  if ( (*d) &&
       (*d)->partition_format &&
       0 != strcmp((*d)->partition_format, "sun") ) {
    snprintf(prtbuf, sizeof(prtbuf), _("%s appears not to have a Sun disk label. This means you will not be able to boot directly from this disk. You can create a Sun disk label with the option 's' in fdisk.\n"), (*d)->name);
    if (first)
      strcat(prtbuf, _("Do you still want to partition this disk?"));
    else
      strcat(prtbuf, _("Are you sure you want to keep this partition table?"));
    /* returns 1 if first & YES or !first & NO, 0 otherwise */
    return (yesNoBox(prtbuf, _("Unknown disk label")) == DLG_NO) ^ first;
  }
#elif #cpu(alpha)
  if (srm_boot) {
    if ((*d) && (*d)->partition_format
	&& 0 != strcmp((*d)->partition_format, "osf")) {
      snprintf(prtbuf, sizeof(prtbuf),
	       _("%s appears not to have an OSF/1 disk label.  "
		 "This means you will not be able to boot directly "
		 "from this disk.  You can create an OSF/1 disk label "
		 "with the option 'b' in fdisk.\n"), (*d)->name);
      if (first) {
	strcat(prtbuf, _("Do you still want to partition this disk?"));
	return (yesNoBox(prtbuf, _("Unknown disk label")) == DLG_YES);
      } else {
	strcat(prtbuf,
	       _("Are you sure you want to keep this partition table?"));
	return (yesNoBox(prtbuf, _("Unknown disk label")) == DLG_NO);
      }
    }
  }

#elif #cpu(powerpc)
  /* Yaboot */
  if (!first) {
    if ( ( strstr( Arch2, "PowerMac" ) ) && 
	 ( NULL != Arch3 ) && 0 == strcmp( Arch3, "NewWorld" ) ) {

      struct fdisk_partition *bootstrap;
      bootstrap = fdisk_find_partition_by_type( PTYPE_MAC_BOOT );
      if ( NULL == bootstrap ) {
	first = yesNoBox( _("No Apple_Bootstrap partition was detected. "
			    "Do you wish to partition the disk again?"),
			  _("Missing Bootstrap Partition")) == DLG_YES;
      }
      else if ( 800 > bootstrap->size ) {
	first = yesNoBox( _("The Apple_Bootstrap partition must be at least 800K.  "
			    "Do you wish to partition the disk again?"),
			  _("Bootstrap Partition Too Small")) == DLG_YES;
      }
    }
    else if ( 0 == strcmp( Arch2, "chrp" ) ) {
      
      struct fdisk_partition *bootstrap;
      bootstrap = fdisk_find_partition_by_type( PTYPE_CHRP_BOOT );
      if ( NULL == bootstrap ) {
	first = yesNoBox( _("No CHRP (type 0x41) bootstrap partition was detected.  "
			    "Do you wish to partition the disk again?"),
			  _("Missing Bootstrap Partition")) == DLG_YES;
      }
      else if ( 800 > bootstrap->size ) {
	first = yesNoBox( _("The CHRP bootstrap partition must be at least 800K.  "
			    "Do you wish to partition the disk again?"),
			  _("Bootstrap Partition Too Small")) == DLG_YES;
      }
    }
  }

#else /* neither sparc nor alpha */
    /* XXX: Check for MS-DOG partition table? */
#endif
  /* returns 1 if first, 0 otherwise to run fdisk only once */
  return first;
}

#ifdef _TESTING_

void usage(char * name)
{
  fprintf(stderr, "Usage: %s (mount | swap | partition) [subarch]\n", name);
}

int main(int argc, char* argv[])
{
  int test_mount = 0, test_swap = 0, test_partition = 0;
  LOAD_TRMFILE("test.trm");
  get_kver();
  if (argc < 2) {
    usage(argv[0]);
    return 1;
  }

  /* totally losing, but I don't care */
  if (strcmp(argv[1], "mount") == 0) {
    test_mount = 1;
  } else if (strcmp(argv[1], "swap") == 0) {
    test_swap = 1;
  } else if (strcmp(argv[1], "partition") == 0) {
    test_partition = 1;
  } else {
    usage(argv[0]);
    return 1;
  }

  if (argc == 3)
    Arch2 = argv[2];
  else
    Arch2 = "";

  fdisk_reread();
  boxInit();

  if (test_mount) {
    while (mount_any() == 0)
        fdisk_reread();
  } else if (test_swap)
    init_swap();
  else
    partition_disk();

  boxFinished();
  return 0;
}

#endif
