#! /bin/sh
# chandev helper functions for the initial network setup on s390
#
# written by Stefan Gybas and Frank Kirschner
# maintained by the boot-floppies team, debian-boot@lists.debian.org
# copyright (c) 2001
# This is free software under the GNU General Public License.


# Get the key bit of the specified channel type
# Parameters: $1: the channel type as string (required)
# Returns: $ans: the key bit in hexadecimal notation (0x..)
get_chantype () {
  if [ -f /proc/chandev ]; then
    ans=`grep "^chan_type key bitfield" /proc/chandev | sed -e "s/.*$1=\(0x[0-9a-f]*\).*/\\1/"`
  else
    ans="0xff"
  fi
}

# Print the header for print_chandevnos
print_chandevheader () {
  if [ -f /proc/chandev ]; then
    sed -n -e "1,/^channels detected/d;/^[ =]/p" /proc/chandev
  fi
}

# Print all lines from /proc/chandev matching a specific channel type key bit
# Parameters: $1: the channel type key bit in hexadecimal notation (required)
# Returns: stdout: all matching lines, order is from /proc/chandev
print_chandevnos () {
  if [ -f /proc/chandev ]; then
    sed -n -e "1,/^channels detected/d;/^0x.... 0x.... 0x../p" /proc/chandev | /usr/lib/netsetup/changrep $1
  fi
}
