// *************************************************************************
//
// Copyright (C) 2004-2006 Bruno PAGES  All rights reserved.
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifndef RELATIONDATA_H
#define RELATIONDATA_H

#include "ClassMemberData.h"
#include "Labeled.h"
#include "AType.h"

class QTextStream;

class BrowserRelation;
class BrowserAttribute;
class BrowserNode;
class BrowserClass;

struct RoleData {
  // UML (except some cases to save memory)
  MyStr role;
  SharedStr multiplicity;
  MyStr init_value;
  MyStr comment;
  UmlVisibility uml_visibility : 8;	// : 4 useless here, : 8 faster than : 4 ?
  UmlVisibility cpp_visibility : 8;	// : 4 useless here, : 8 faster than : 4 ?
  bool isa_class_relation : 1;
  bool isa_volatile_relation: 1;
  bool isa_const_relation : 1;
  bool java_transient : 1;		// java
  bool idl_truncatable_inheritance : 1;	// idl inheritance
  
  // C++
  bool cpp_virtual_inheritance : 1;
  bool cpp_mutable: 1;
  SharedStr cpp_decl;
  
  // Java
  SharedStr java_decl;
  SharedStr java_annotation;
  
  // Idl
  BrowserAttribute * idl_case;	// exclusive with idl_explicit_case
  SharedStr idl_explicit_case;
  SharedStr idl_decl;
};

class RelationData : public ClassMemberData, public Labeled<RelationData> {
  Q_OBJECT
    
  friend class RelationDialog;
  
  protected:
    static IdDict<RelationData> all;
  
    // Uml
    bool is_deleted : 8;	// 1 useless here, 8 faster than 1 ?
    UmlCode type: 8;		// 1 useless here, 8 faster than 1 ?
    MyStr name;
    RoleData a;
    RoleData b;
    BrowserRelation * start;
    BrowserRelation * end;
    BrowserNode * end_removed_from;
    AType association;		// class association
    
    virtual void send_uml_def(ToolCom * com, BrowserRelation * rel);
    virtual void send_cpp_def(ToolCom * com, BrowserRelation * rel);
    virtual void send_java_def(ToolCom * com, BrowserRelation * rel);
    virtual void send_idl_def(ToolCom * com, BrowserRelation * rel);
    
  public:
    RelationData(UmlCode e, int id = 0);
    RelationData(const BrowserRelation * model, BrowserRelation * r);
    virtual ~RelationData();
    void garbage(BrowserRelation * r);
    void copy(RelationData * model);
        
    virtual bool deletedp() const;
    virtual void set_deletedp(bool y);
    virtual void delete_it();
    virtual void undelete(QString & warning, QString & renamed);
    bool undelete(QString & warning, QString & renamed,
		  BrowserRelation * rel, bool & br_deleted);
        
    BrowserRelation * set_start_end(BrowserRelation * s, BrowserClass * e);
    void edit();
    bool check_end_visibility();
    bool navigable(BrowserRelation *) const;
    BrowserClass * get_start_class() const;
    BrowserClass * get_end_class() const;
    BrowserRelation * get_start() const { return start; };
    BrowserRelation * get_end() const { return end; };
    void unidir_change_dest(BrowserNode * e);
    
    UmlCode get_type() const { return type; };
    void set_type(UmlCode e);
    
    const char * get_name() const { return name; };
    QString get_name(BrowserRelation *) const;
    void set_name(const QString &);
    virtual QString definition(bool full) const;
    virtual void set_stereotype(const QString &);
    virtual void set_stereotype(const QCString &);
    virtual void set_stereotype(const char *);
    
    bool is_a(const BrowserRelation * br) const { return br == start; };
    
    const char * get_role_a() const { return a.role; };
    const char * get_role_b() const { return b.role; };
    bool wrong_role_a_name(const QString &);
    bool wrong_role_b_name(const QString &);
    
    AType get_association() const { return association; }
    void set_association(const AType & t);
    
    const char * get_multiplicity_a() const { return a.multiplicity; };
    const char * get_multiplicity_b() const { return b.multiplicity; };
      
    bool get_isa_class_relation_a() const { return a.isa_class_relation; };
    bool get_isa_class_relation_b() const { return b.isa_class_relation; };
    
    bool get_isa_const_relation_a() const { return a.isa_const_relation; };
    bool get_isa_const_relation_b() const { return b.isa_const_relation; };
    
    UmlVisibility get_uml_visibility_a() const { return a.uml_visibility; };
    UmlVisibility get_uml_visibility_b() const { return b.uml_visibility; };
    virtual UmlVisibility get_visibility(BrowserNode *);
    
    const char * get_comment_a() const { return a.comment; };
    const char * get_comment_b() const { return b.comment; };
    void  set_comment_a(const char * s) { a.comment = s; };
    void set_comment_b(const char * s) { b.comment = s; };
    
    bool get_cpp_virtual_inheritance() const { return a.cpp_virtual_inheritance; };
    
    UmlVisibility get_cpp_visibility_a() const { return a.cpp_visibility; };
    UmlVisibility get_cpp_visibility_b() const { return b.cpp_visibility; };
    
    const char * get_cppdecl_a() const { return a.cpp_decl; };
    const char * get_cppdecl_b() const { return b.cpp_decl; };
    
    const char * get_javadecl_a() const { return a.java_decl; };
    const char * get_javadecl_b() const { return b.java_decl; };
    
    const char * get_idldecl_a() const { return a.idl_decl; };
    const char * get_idldecl_b() const { return b.idl_decl; };
    static const char * get_idlcase(const RoleData & role);
    static void set_idlcase(RoleData & role, BrowserAttribute * a, const char * e);
    bool get_idl_truncatable() const { return a.idl_truncatable_inheritance; };
    
    void select_in_browser(bool prefer_start) const;
    
    void save(QTextStream &, bool ref, QString & warning) const;
    static RelationData * read_ref(char * &, bool complete = FALSE);
    static RelationData * read(char * &, char * &);
    
    static bool uni_directional(UmlCode);
    static const QString & default_name(UmlCode e);
    static bool isa_association(UmlCode e);
    
    bool tool_cmd(ToolCom * com, BrowserRelation * rel, const char * args);
    
    static void clear(bool old);
    static void update_idmax_for_root();
    void renumber(int phase, BrowserRelation * br);
    bool is_writable(const BrowserRelation * br) const;
    
  protected slots:
    void end_deleted();
    void on_delete();
};

#endif
