// *************************************************************************
//
// Copyright (C) 2004-2006 Bruno PAGES  All rights reserved.
//
// This file is part of the BOUML Uml Toolkit.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// e-mail : bouml@free.fr
// home   : http://bouml.free.fr
//
// *************************************************************************

#ifdef WIN32
#pragma warning (disable: 4150)
#endif

#include <qfont.h>
#include <qpopupmenu.h> 

#include "UseCaseDiagramWindow.h"
#include "UseCaseDiagramView.h"
#include "BrowserUseCaseDiagram.h"
#include "DiagramCanvas.h"
#include "UcUseCaseCanvas.h"
#include "PackageCanvas.h"
#include "FragmentCanvas.h"
#include "SubjectCanvas.h"
#include "UcClassCanvas.h"
#include "IconCanvas.h"
#include "RelationCanvas.h"
#include "SimpleRelationCanvas.h"
#include "NoteCanvas.h"
#include "TextCanvas.h"
#include "UmlPixmap.h"
#include "UmlDrag.h"
#include "BrowserClass.h"
#include "BrowserUseCase.h"
#include "MenuTitle.h"
#include "myio.h"

UseCaseDiagramView::UseCaseDiagramView(QWidget * parent, UmlCanvas * canvas, int id)
    : DiagramView(parent, canvas, id) {
  load("Use Case");
}

void UseCaseDiagramView::menu(const QPoint&) {
  QPopupMenu m(0);
  QPopupMenu formatm(0);
  
  m.insertItem(new MenuTitle("Use case diagram menu", m.font()), -1);
 
  switch (default_menu(m, 20)) {
  case EDIT_DRAWING_SETTING_CMD:
    ((BrowserUseCaseDiagram *) the_canvas()->browser_diagram())->edit_settings();
    break;
  case RELOAD_CMD:
    // pure drawing modifications are lost
    // mark the diagram modified because the undid modifications
    // may be saved in the file are not saved in memory
    load("Use Case");
    window()->package_modified();
    break;
  }
}

void UseCaseDiagramView::contentsMousePressEvent(QMouseEvent * e) {
  if (!window()->frozen()) {
    UmlCode action = window()->buttonOn();
    
    switch (action) {
    case UmlClass:
      {
	history_protected = TRUE;
	unselect_all();
	window()->selectOn();
	history_save();
	
	BrowserNode * b = 
	  BrowserClass::get_class(((BrowserNode *) window()->browser_diagram()->parent()),
				  "actor");
	
	if (b != 0) {
	  UcClassCanvas * uc = 
	    new UcClassCanvas(b, the_canvas(), e->x(), e->y(), 0);
	  
	  uc->show();
	  uc->upper();
	  window()->package_modified();
	}
      }
      break;
    case UmlUseCase:
      {
	history_protected = TRUE;
	unselect_all();
	window()->selectOn();
	history_save();
	
	BrowserNode * b = 
	  BrowserUseCase::get_use_case(((BrowserNode *) window()->browser_diagram()->parent()));
	
	if (b != 0) {
	  UcUseCaseCanvas * uc = 
	    new UcUseCaseCanvas(b, the_canvas(), e->x(), e->y(), 0);
	  uc->show();
	  uc->upper();
	  window()->package_modified();
	}
      }
      break;
      case UmlSubject:
	{
	  unselect_all();
	  window()->selectOn();
	  history_save();
	  
	  SubjectCanvas * f = 
	    new SubjectCanvas(the_canvas(), e->x(), e->y(), 0);
	  
	  f->show();
	  f->upper();
	  window()->package_modified();
	}
	break;
    default:
      DiagramView::contentsMousePressEvent(e);
      return;
    }
    
    canvas()->update();
    history_protected = FALSE;
  }
}

void UseCaseDiagramView::dragEnterEvent(QDragEnterEvent * e) {
  abort_line_construction();
  
  if (!window()->frozen() &&
      (UmlDrag::canDecode(e, UmlClass, TRUE, TRUE) ||
       UmlDrag::canDecode(e, UmlUseCase, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlPackage, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlRelations, TRUE, TRUE) ||
       UmlDrag::canDecode(e, UmlSimpleRelations, TRUE, TRUE) ||
       UmlDrag::canDecode(e, UmlClassDiagram, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlUseCaseDiagram, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlSeqDiagram, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlColDiagram, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlObjectDiagram, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlComponentDiagram, FALSE, TRUE) ||
       UmlDrag::canDecode(e, UmlDeploymentDiagram, FALSE, TRUE)))
    e->accept();
  else
    e->ignore();
}

void UseCaseDiagramView::dropEvent(QDropEvent * e) {
  BrowserNode * bn;
  QPoint p = viewportToContents(e->pos());
  
  if ((bn = UmlDrag::decode(e, UmlClass)) != 0) {
    history_save();
    
    UcClassCanvas * uc = 
      new UcClassCanvas(bn, the_canvas(), p.x(), p.y(), 0);
    
    history_protected = TRUE;
    uc->show();
    uc->upper();
    canvas()->update();
    history_protected = FALSE;
    window()->package_modified();
  }
  else if ((bn = UmlDrag::decode(e, UmlUseCase)) != 0) {
    history_save();
    
    UcUseCaseCanvas * uc = 
      new UcUseCaseCanvas(bn, the_canvas(), p.x(), p.y(), 0);
    
    history_protected = TRUE;
    uc->show();
    uc->upper();
    canvas()->update();
    history_protected = FALSE;
    window()->package_modified();
  }
  else if ((bn = UmlDrag::decode(e, UmlPackage)) != 0) {
    history_save();
    
    PackageCanvas * pk = 
      new PackageCanvas(bn, the_canvas(), p.x(), p.y(), 0);
    
    history_protected = TRUE;
    pk->show();
    pk->upper();
    canvas()->update();
    window()->package_modified();
  }
  else if ((bn = UmlDrag::decode(e, UmlRelations, TRUE)) != 0) {
    history_save();
    
    history_protected = TRUE;
    RelationCanvas::drop(bn, the_canvas());
    canvas()->update();
    history_protected = FALSE;
  }
  else if ((bn = UmlDrag::decode(e, UmlSimpleRelations, TRUE)) != 0) {
    history_save();
    
    history_protected = TRUE;
    SimpleRelationCanvas::drop(bn, the_canvas());
    canvas()->update();
    history_protected = FALSE;
  }
  else if (((bn = UmlDrag::decode(e, UmlClassDiagram)) != 0) ||
	   ((bn = UmlDrag::decode(e, UmlUseCaseDiagram)) != 0) ||
	   ((bn = UmlDrag::decode(e, UmlSeqDiagram)) != 0) ||
	   ((bn = UmlDrag::decode(e, UmlColDiagram)) != 0) ||
	   ((bn = UmlDrag::decode(e, UmlObjectDiagram)) != 0) ||
	   ((bn = UmlDrag::decode(e, UmlComponentDiagram)) != 0) ||
	   ((bn = UmlDrag::decode(e, UmlDeploymentDiagram)) != 0)) {
    history_save();
    
    IconCanvas * ic = new IconCanvas(bn, the_canvas(), p.x(), p.y(), 0);
    
    history_protected = TRUE;
    ic->show();
    ic->upper();
    canvas()->update();
    history_protected = FALSE;
    window()->package_modified();
  }
}

void UseCaseDiagramView::save(QTextStream & st, QString & warning,
			      bool copy) const {
  DiagramItemList items(canvas()->allItems());
  DiagramItem * di;
  
  if (!copy)
    // sort is useless for a copy
    items.sort();
  
  st << "format " << FILEFORMAT << "\n";
  
  // save first class use_cases packages fragment subject notes and icons
  
  for (di = items.first(); di != 0; di = items.next()) {
    switch (di->type()) {
    case UmlClass:
    case UmlUseCase:
    case UmlNote:
    case UmlText:
    case UmlPackage:
    case UmlFragment:
    case UmlSubject:
    case UmlIcon:
      if (!copy || di->copyable())
	di->save(st, FALSE, warning);
      // no break
    default:
      break;
    }
  }

  // then saves relations
  
  for (di = items.first(); di != 0; di = items.next())
    if ((!copy || di->copyable()) &&
	(IsaRelation(di->type()) || IsaSimpleRelation(di->type())))
      di->save(st, FALSE, warning);
  
  // then saves anchors
  
  for (di = items.first(); di != 0; di = items.next())
    if ((!copy || di->copyable()) && (di->type() == UmlAnchor))
      di->save(st, FALSE, warning);
  
  if (!copy && (preferred_zoom != 0)) {
    nl_indent(st);
    st << "preferred_whz " << preferred_size.width() << ' '
      << preferred_size.height() << ' ' << preferred_zoom;
  }
  
  nl_indent(st);
  st << "end\n";
}

void UseCaseDiagramView::read(char * st, char * k) {
  UmlCanvas * canvas = the_canvas();
  
  // reads first the class use_cases package icons and notes
  while (UcClassCanvas::read(st, canvas, k) ||
	 UcUseCaseCanvas::read(st, canvas, k) ||
	 NoteCanvas::read(st, canvas, k) ||
	 TextCanvas::read(st, canvas, k) ||
	 IconCanvas::read(st, canvas, k) ||
	 PackageCanvas::read(st, canvas, k) ||
	 FragmentCanvas::read(st, canvas, k) ||
	 SubjectCanvas::read(st, canvas, k))
    k = read_keyword(st);
  
  // then reads relations and anchors
  while (ArrowCanvas::read(st, canvas, k) ||
	 RelationCanvas::read(st, canvas, k) ||
	 SimpleRelationCanvas::read(st, canvas, k))
    k = read_keyword(st);
  
  if (!strcmp(k, "preferred_whz") || !strcmp(k, "prefered_whz")) {
    preferred_size.setWidth(read_unsigned(st));
    preferred_size.setHeight(read_unsigned(st));
    preferred_zoom = read_double(st);
    k = read_keyword(st);
  }
  
  if (strcmp(k, "end"))
    wrong_keyword(k, "end");
}


