#ifndef _PRMAINEDITOR_CPP_
#define _PRMAINEDITOR_CPP_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>

#include "prMainEditor.h"
#include "prPartEditor.h"
#include "addon.h"
#include "song.h"
#include "loader.h"
#include "table.h"
#include "ltdl.h"


#include "alsaSeqlib.c"
#include "alsaSeqmidi.c"


int generalAddonsSize = 3;
const char * generalAddons[] = { "quantizeAll", "quantizeLength", "fixedLength" };
int output = 0;

// extern Song * sonG;

char * parameter(const char * name, const char * alt, int argc, char ** argv) {
  char * ret = 0;
  if ((strcmp(name,"x")==0)) {
    for (int i=1; i<argc; i++) {
      if (argv[i][0] != '-') ret = strdup(argv[i]);
      else i++;
    }
  } else
    for (int i=0; i<argc; i++) {
      if ((strcmp(argv[i],name)==0)||(strcmp(argv[i],alt)==0)) {
	ret = strdup(argv[i+1]);
      }
      continue;
    }
  return ret;
}

class PrFactory;

PrFactory * factory = 0;
PrMainEditor * mainEditor = 0;
Song * sonG = 0;
Table * selectioN = 0;
Table * selectionMemory = 0;

char ** addons(const char * name, const char * alt, int argc, char ** argv, int & count) {
  char ** ret = 0;
  count = 0;
  for (int i=0; i<argc-1; i++) if ((strcmp(argv[i],name)==0)||(strcmp(argv[i],alt)==0)) count++;
  count += generalAddonsSize;
  ret = new char*[count];
  int c = 0;
  for (int i=0; i<argc-1; i++) {
    if ((strcmp(argv[i],name)==0)||(strcmp(argv[i],alt)==0)) ret[c++] = strdup(argv[i+1]);
  }
  for (int i=0; i<generalAddonsSize; i++) {
    ret[c++] = strdup(generalAddons[i]);
  }
  return ret;
}


PrMainEditor::PrMainEditor(int argc, char** argv) : _addon_count(0), _editor_background(1), _project_dir(0) {
  for (int i=0;i<MAXACTIONS;i++) _action_list[i] = 0;
  for (int i=0;i<MAXEDITORS;i++) _editor_list[i] = 0;

  _print_in_partiture = true;
  _print_in_piano_system = false;
  _file_name = strdup("untitled.bms");
  _undo_memory = 20;
  _grid = 384;

  selectioN = new Table();
  selectionMemory = new Table();

  //
  // Addons:
  // -------
  //


  int count = 0;
  char ** addonList = addons("--addon", "-a",argc,argv,count);
  _addons = new OpFunction[MAXACTIONS];
  _action_track = new OpTrack[MAXACTIONS];

  //
  // loop through the addon parameters:
  //
  for (int i=0; i<count; i++) {
    char * name = addonList[i];
    insertAddon(name);
  }
}

PrMainEditor::~PrMainEditor()
{
  closeEditors();
  // should probably delete lots of stuff here...

}

bool PrMainEditor::insertAddon(char * arg) {
  bool ok = false;
  char * name = 0;

  if (arg != 0) {
    const char * DLERROR;
    char * addon = new char[50];
    char * opdesc = new char[50];
    char * opctgr = new char[50];
    char * opcont = new char[50];
    char * optrack = new char[50];
    int len = strlen(arg);
    char * ext = arg+len-3; // 3 = ".so"

    if (strcmp(ext,".la")==0) {
      //
      // library specified
      //
      // cout << "lib: " << arg << endl;
      arg = rindex(arg,'/') + 1;
      len = strlen(arg);
      char * nameptr = arg + 14; // 14 = "libBrahmsAddon"
      name = new char[len-14-2];        // 14 = "libBrahmsAddon", 3 = ".so"
      snprintf(name,len-14-2,"%s",nameptr);
      // cout << "name: " << name << endl;
      if (name[0] < 97) name[0] += 32;
    } else {
      //
      // name specified
      //
      name = arg;
    }

    sprintf(addon,"libBrahmsAddon%s.la",name);
    if (addon[14] > 96) addon[14] -= 32; // capitalize first letter, (so "dump" -> "Dump")

    sprintf(opdesc,"%s_name",name);
    sprintf(opctgr,"%s_category",name);
    sprintf(opcont,"%s_context",name);
    sprintf(optrack,"%s_track",name);

#ifdef DEBUGIT
    cout << "trying to open addon " << name << ": " << addon << " ..." << endl;
#endif
    lt_dlhandle handleAddon = lt_dlopen (addon);
    if (!handleAddon) {
      cout << "error open addon: " << lt_dlerror() << endl;
      // exit(1);
    } else {

#ifdef DEBUGIT
      cout << "loading symbol " << name << " ..." << endl;
#endif
      OpFunction getAddon = (OpFunction) lt_dlsym(handleAddon,name);
      if ((DLERROR = lt_dlerror()) != NULL)  cout << "error sym: " << DLERROR << endl;
      else {
#ifdef DEBUGIT
	cout << "loading symbol " << opdesc << " ..." << endl;
#endif
	OpDescriptor description = (OpDescriptor) lt_dlsym(handleAddon,opdesc);
	if ((DLERROR = lt_dlerror()) != NULL)  cout << "error sym: " << DLERROR << endl;
	else {
#ifdef DEBUGIT
	  cout << "loading symbol " << opctgr << " ..." << endl;
#endif
	  OpCategory category = (OpCategory) lt_dlsym(handleAddon,opctgr);
	  if ((DLERROR = lt_dlerror()) != NULL)  cout << "error sym: " << DLERROR << endl;
	  else {
#ifdef DEBUGIT
	    cout << "loading symbol " << opcont << " ..." << endl;
#endif
	    OpContext context = (OpContext) lt_dlsym(handleAddon,opcont);
	    if ((DLERROR = lt_dlerror()) != NULL)  cout << "error sym: " << DLERROR << endl;
	    else {
#ifdef DEBUGIT
	      cout << "trying to load new tracktype " << optrack << " ..." << endl;
#endif
	      OpTrack tracktype = (OpTrack) lt_dlsym(handleAddon,optrack);
	      if ((DLERROR = lt_dlerror()) != NULL)  {
#ifdef DEBUGIT
		cout << "info: no tracktype on sym: " << DLERROR << endl; tracktype = 0;
#endif
	      }
	      
	      _addons[_addon_count]            = getAddon;
	      _action_list[_addon_count]       = description();
	      _action_category[_addon_count]   = category();
	      _action_context[_addon_count]    = context();
	      _action_track[_addon_count]      = tracktype;
	      _addon_count++;
	      ok = true;
	    }
	  }
	}
      }
    }
  }
  return ok;
}

void PrMainEditor::removeAddon(int i) {
  if (i>=0 && i<_addon_count) {
    // TODO: destroy addon i
    for (int j=i; j<_addon_count-1; j++) {
      _addons[j]          = _addons[j+1];
      _action_list[j]     = _action_list[j+1];
      _action_category[j] = _action_category[j+1];
      _action_context[j]  = _action_context[j+1];
      _action_track[j]    = _action_track[j+1];
    }
    _addon_count--;
  }
}


//int PrMainEditor::gridx() { return _grid; cout << "takex " << _grid << endl; }

void PrMainEditor::setGrid(int i) { _grid = i; }

void PrMainEditor::setEditorBackground(int i) { _editor_background = i; }

void PrMainEditor::loadSong(int argc, char ** argv) {
  //
  // Load Song:
  // ----------
  //
  
  char * fname = parameter("x","x",argc,argv);
  
  if (sonG!=0) delete sonG;
  
  if (fname==0) {
    sonG = new Song();
  } else {
    sonG = Loader::load(fname);
    if (sonG!=0) {
      setFilename(fname);
    } else {
      cout << "not a Brahms file" << endl;
      sonG = Loader::loadMidi(fname);
      if (sonG!=0) {
	int len = strlen(fname);
	if (len>3 && fname[len-4]=='.') {
	  fname[len-3] = 'b'; fname[len-2] = 'm'; fname[len-1] = 's';
	  setFilename(fname);
	} else {
	  char * filename = new char[len+4];
	  sprintf(filename, "%s.mid", fname);
	  setFilename(filename);
	  delete filename;
	}
      } else {
	cout << "not a midi file" << endl;
	sonG = new Song();
      }
    }
  }
}

char ** PrMainEditor::actionList() { return _action_list; }

char * PrMainEditor::description(int i) { return _action_list[i]; }

OpTrack PrMainEditor::actionTrack(int i) { return _action_track[i]; }

char * PrMainEditor::actionCategory(int i) { return _action_category[i]; }

int PrMainEditor::actionContext(int i) { return _action_context[i]; }

void PrMainEditor::performAction(int i, Element * target) {
  Addon * op =  (_addons)[i](target);
  sonG->doo(op);
  update();
}

char ** PrMainEditor::categories() {
  char ** ret = 0;
  ret = new char*[MAXACTIONS];
  int c = 0;
  for (int i=0; i<MAXACTIONS; i++) {
    if (_action_list[i]!=0) {
      bool newcat = true;
      for (int k=0; k<c; k++) if (strcmp(_action_category[i],ret[k])==0) newcat = false;
      if (newcat) ret[c++] = strdup(_action_category[i]);
    }
  }
  for (int i=c; i<MAXACTIONS; i++) ret[i] = 0;
  return ret;
}

int * PrMainEditor::actionListByCategory(char* cat) {
  int * ret = new int[MAXACTIONS];
  int c = 0;
  for (int i=0; i<MAXACTIONS; i++) {
    if (_action_list[i]!=0 && strcmp(_action_category[i],cat)==0) ret[c++] = i;
  }
  for (int i=c; i<MAXACTIONS; i++) ret[i] = -1;
  // for (int i=0; ret[i]!=-1; i++) { cout << i << ": " << ret[i] << endl; }
  return ret;
}

Track * PrMainEditor::createAddonTrack(int i) {
  Track * tr = 0;
  if (i>=0 && _action_track[i]!=0) tr = (_action_track)[i]();
  return tr;
}

Track * PrMainEditor::createAddonTrack(const char * desc) {
  if (desc==0) return 0;
  int k = -1;
  for (int i=0; i<MAXACTIONS && _action_list[i]!=0; i++) {
    // cout << "comparing " << desc << " with " << _action_list[i] << endl;
    if (_action_list[i]!=0 && strcmp(_action_list[i],desc)==0) { k = i; break; }
  }
  return createAddonTrack(k);
}



void PrMainEditor::addEditor(PrPartEditor * ed) {
  int i=0;
  for (i=0; _editor_list[i]!=0; i++) {}
  if (i<MAXEDITORS) _editor_list[i] = ed;
  else {
    cout << "PANIC: more than " << MAXEDITORS << " editors opened" << endl;
    delete ed;
  }
  mainEditor->ui(SELECTIONS,false);
  mainEditor->ui(MEMORY,false);
}

void PrMainEditor::removeEditor(PrPartEditor * ed) {
  int ind = -1;
  for (int i=0; _editor_list[i]!=0; i++)
    if (_editor_list[i] == ed) ind = i;
  if (ind!=-1) {
    for (int i = ind; _editor_list[i]!=0; i++)
      _editor_list[i] = _editor_list[i+1];
  }
}

PrPartEditor * PrMainEditor::editor(int i) {
  return _editor_list[i];
}

void PrMainEditor::dumpEditors() {
  cout << "\nOpen editors:\n" << endl;
  for (int i=0; _editor_list[i]!=0; i++)
    cout << i << ": " << _editor_list[i]->name() << endl;
}

void PrMainEditor::closeEditors() {
  for (int i=0; _editor_list[i]!=0; i++) {
    PrPartEditor * e = _editor_list[i];
    removeEditor(e);
    delete e;
  }
}

void PrMainEditor::ui(GuiEvents ev, bool flag) {
  // if event concerns selection or memory (the copy/cut buttons), only update if no editors are open
  if ( (ev!=SELECTIONS && ev!=MEMORY) || (_editor_list[0]==0) )
    gui(ev,flag);

  // update(); // slows down things a little bit!
  for (int i=0; _editor_list[i]!=0; i++) {
    _editor_list[i]->gui(ev,flag);
  }
}

void PrMainEditor::ui() {
  for (int i=0; _editor_list[i]!=0; i++) {
    _editor_list[i]->update();
  }
}

void PrMainEditor::setFilename(char * str) {
  if (str!=0) {
    int i = 0;
    int len = strlen(str);
    char * fn = str;
    for (i=len-1; i>=0 && str[i]!='/'; i--) {}
    if (i<0) {
      _file_name = strdup(str);
    } else {
      fn = str+i+1;
      _file_name = strdup(fn);
    }
  }
}

int PrMainEditor::undoMemory() { return _undo_memory; }

void PrMainEditor::setUndoMemory(int i) { _undo_memory = i; }


/* printing */

void PrMainEditor::sPP(bool p) { _print_in_partiture = p; }

void PrMainEditor::sPPS(bool p) { _print_in_piano_system = p; }


/* project stuff */

void PrMainEditor::setProjectDir(char * dir) { _project_dir = dir; }

#endif
