#ifndef _COPYSELECTION_CPP_
#define _COPYSELECTION_CPP_

#include <iostream.h>

#include "copySelection.h"
#include "element.h"
#include "compound.h"

#include "track.h"
#include "event.h"
#include "song.h"
#include "table.h"
#include "reference.h"

extern Song * sonG;
extern Table * selectioN;
extern Table * selectionMemory;


CopySelection::CopySelection() : Operation(), _oldTable(0) {
  _type = COPYSELECTION;
  _description = "copy selection";
  _to_be_undone = false;
  _oldTable = selectionMemory;
  _delete = _oldTable;

  // selectionMemory = (Table*) selectioN->copy(); // does not work, since copying references does not duplicate the values
  selectionMemory = new Table();
  for (Reference * r = (Reference*)selectioN->first(); r != 0; r = (Reference*) Element::next(r)) {
    selectionMemory->add(new Reference( r->getValue()->copy() ));
  }

}


CopySelection::CopySelection(const CopySelection&  el) : Operation(el) {
  _type = COPYSELECTION;
  _oldTable = el._oldTable;
  _delete = el._delete;
}

CopySelection::~CopySelection() {
  if (_oldTable!=0) {
    ((Compound*)_oldTable)->scratch();
    delete _oldTable;
  }
}

void CopySelection::undo() {
  cout << "MEM undo 1:\n" << selectionMemory << endl;
  Table * tmp = selectionMemory;
  selectionMemory = _oldTable;
  _oldTable = tmp;
  _delete = _oldTable;
  cout << "MEM undo 2:\n" << selectionMemory << endl;
}

void CopySelection::redo() {
  cout << "MEM redo 1:\n" << selectionMemory << endl;
  Table * tmp = _oldTable;
  _oldTable = selectionMemory;
  selectionMemory = tmp;
  _delete = _oldTable;
  cout << "MEM redo 2:\n" << selectionMemory << endl;
}



// ---------------
// virtuals:
//

ostream & CopySelection::print(int dep, ostream & s) const {
  s << spc(dep) << "<COPYSELECTION />" << endl;
  return s;
}

void CopySelection::flush(const char * c) const {
  cout << c << "COPYSELECTION" << endl;
}

Element * CopySelection::copy() const {
  return new CopySelection(*this);
}




#endif
