/***************************************************************************
*	Brutal Chess Pre-Alpha Build
*	- alphabetaplayer.h
*
*	Authors: Maxwell Lazaroff, Michael Cook, and Joe Flint
*	Date Created : November 5th, 2005
*	Last Modified: November 5th, 2005
*
*	- description - Implements the AlphaBeta ChessPlayer.
***************************************************************************/

#ifndef _ALPHABETAPLAYER_H
#define _ALPHABETAPLAYER_H

#include "chessplayer.h"
#include "board.h"
#include "boardmove.h"

class
AlphaBetaPlayer : public ChessPlayer
/***************************************************************************
*   AlphaBetaPlayer implementation
*
*   - This is a player that will use a alpha beta tree to be extremely
*   efficient and totally whoop ass if given enough time.
***************************************************************************/
{
public :

	//******** CONSTRUCTOR ********
	
	AlphaBetaPlayer() : ChessPlayer("AlphaBeta AI-Player") {}

	virtual bool requiresInput() { return false; }

	virtual ChessPlayer* dup() const { return new AlphaBetaPlayer(); }

	virtual BoardMove decide_move(const Board & board, bool & player);

};

#endif // _ALPHABETAPLAYER_H

// End of file alphabetaplayer.h
