/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SFTP_H
#define INCLUDED_SFTP_H

/*------- inlude files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QPROCESS_H
#include <qprocess.h>
#define INCLUDED_QPROCESS_H
#endif // INCLUDED_QPROCESS_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H


/*------- class declaration:
-------------------------------------------------------------------*/
class SFtp : public QProcess
{
    Q_OBJECT

// ******* CONTRUCTION / DESTRUCTION *******
public:
    SFtp( const QString&, const QString&, const QString& );
    ~SFtp();
private:
    SFtp( const SFtp& );
    SFtp& operator=( const SFtp& );

// ******* TYPES *******
private:
    typedef enum {
        None = 0,
        Login,
    } Op;

// ******* MEMBERS *******
private:
    const QString d_server;
    const QString d_user;
    const QString d_passwd;
    Op d_op;

// ******* METHODS *******
public:
    bool run();
    void stop();
private slots:
    void read_stdout();
    void read_stderr();
};

#endif // INCLUDED_SFTP_H
