/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SETTINGS_H
#define INCLUDED_SETTINGS_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_QSTRINGLIST_H
#include <qstringlist.h> 
#define INCLUDED_QSTRINGLIST_H
#endif // INCLUDED_QSTRINGLIST_H

/*------- class declaration:
-------------------------------------------------------------------*/
class Settings
{
public:	
	static void save( const QString& in_group, const QString& in_key, const QString& in_data );
	static void save( const QString& in_group, const QString& in_key, const int in_data );
	static void save( const QString& in_group, const QString& in_key, const QStringList& in_data );
	static bool read( const QString& in_group, const QString& in_key, QString& out_data );
	static bool read( const QString& in_group, const QString& in_key, int& out_data );
	static void read( const QString& in_group, const QString& in_key, QStringList& out_data );
};

#endif // INCLUDED_SETTINGS_H
