/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "SystemInfoMemory.h"
#include "SystemCall.h"
#include "Shared.h"
#include <vector>
using namespace std;

const QString SystemInfoMemory::d_hdr_label[NumberOfColumns] = {
	"",
	QT_TR_NOOP( "Total" ),
	QT_TR_NOOP( "Used" ),
	QT_TR_NOOP( "Free" ),
	QT_TR_NOOP( "Shared" ),
	QT_TR_NOOP( "Buffers" ),
	QT_TR_NOOP( "Cached" )
};


//*******************************************************************
// SystemInfoMemory                                      CONSTRUCTOR
//*******************************************************************
SystemInfoMemory::SystemInfoMemory( QWidget* const in_parent )
: QListView( in_parent )
, d_syscall( new SystemCall( this ) )
{
	for( int i = 0; i < NumberOfColumns; ++i ) {
		addColumn( tr( d_hdr_label[i] ) );
		setColumnAlignment( i, ( i == Type ) ? Qt::AlignLeft : Qt::AlignRight );
	}
	setSelectionMode( Extended );
	setAllColumnsShowFocus( TRUE );
	setSorting( -1 );
	
	connect( d_syscall, SIGNAL( finished( int ) ), this, SLOT( finished( int ) ));
	vector<QString> parameters;
	parameters.push_back( "free" );
	parameters.push_back( "-t" );
	parameters.push_back( "-o" );
	d_syscall->run( parameters );
}
// end of SystemInfoMemory

//*******************************************************************
// ~SystemInfoMemory                                      DESTRUCTOR
//*******************************************************************
SystemInfoMemory::~SystemInfoMemory()
{
	if( d_syscall ) {
		delete d_syscall;
		d_syscall = 0;
	}
}
// end of ~SystemInfoMemory

//*******************************************************************
// finished                                             PRIVATE slot
//*******************************************************************
void SystemInfoMemory::finished( int )
{
	vector<QString> stdout_lines;
	vector<QString> stderr_lines;
		
	d_syscall->result( stdout_lines, stderr_lines );
	delete d_syscall;
	d_syscall = 0;
		
	if( FALSE == stdout_lines.empty() ) {
		QStringList lines = QStringList::split( '\n', stdout_lines[0] );
		QStringList::Iterator it = lines.begin();
		++it;
		while( it != lines.end() ) {
			add_item( *it );
			++it;
		}
	}
}
// end of finished

//*******************************************************************
// add_item                                                  PRIVATE
//********************************************************************
void SystemInfoMemory::add_item( const QString& in_line )
{
	const QStringList elements = QStringList::split( ' ', in_line );
	
	QListViewItem* const item = new QListViewItem( this );
	if( item ) {
		const int n = elements.size();
		for( int i = 0; i < n; ++i ) {
			if( i != Type ) {
				const QString str = Shared::num2str( elements[i].toULong(), ',' );
				item->setText( i, str );
			}
			else {
				item->setText( i, elements[i] );
			}
		}
	}
}
// end of add_item
