#ifndef __BTANKS_HUD_H__
#define __BTANKS_HUD_H__

/* Battle Tanks Game
 * Copyright (C) 2006-2007 Battle Tanks team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <sigc++/sigc++.h>
#include "export_btanks.h"
#include "sdlx/surface.h"
#include "sdlx/font.h"
#include "math/v3.h"
#include "alarm.h"

#include <map>
#include <set>
#include <string>
#include <vector>

class Font;
class Object;

class BTANKSAPI Hud : public sigc::trackable {
public: 
	Hud(const int w, const int h);
	void toggleMapMode(); 
	
	void render(sdlx::Surface &window) const;

	void renderSplash(sdlx::Surface &window) const;
	const bool renderLoadingBar(sdlx::Surface &window, const float old_progress, const float progress, const bool splash = true) const;
	void renderRadar(const float dt, sdlx::Surface &window, const std::vector<v3<int> > &specials, const sdlx::Rect &viewport);
	void renderStats(sdlx::Surface &surface);

	~Hud();
	
private: 
	void initMap();
	void onDestroyMap(const std::set<v3<int> > & cells);

	void generateRadarBG(const sdlx::Rect &viewport);

	void renderMod(const Object *obj, sdlx::Surface &window, int &xp, int &yp, const std::string &name, const int icon_w, const int icon_h) const;

	const sdlx::Surface *_background, *_loading_border, *_loading_item, *_splash, *_splitter, *_screen_splitter, *_icons;
	sdlx::Surface _radar_bg, _radar;
	const sdlx::Font *_font, *_big_font;
	const sdlx::Surface *_pointer;
	mutable int _pointer_dir;
	Alarm _update_radar;
	typedef std::map<const std::string, int> IconMap;
	IconMap _icons_map;

	enum MapMode {MapNone, MapSmall, MapFull} _map_mode;
};


#endif

