# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk

from config import packages
from pkg_store import pkg_store
from msg_exception import errorhandler

class pkg_view:
    """package treeview stuff"""

    @errorhandler
    def __init__(self, xml):
        self.xml = xml

        self.tv = xml.get_widget("tv_packages")
        
        # Package Column
        self.crt_pkg = gtk.CellRendererText()
        self.tvc_pkg = gtk.TreeViewColumn("Package",
            self.crt_pkg, text=pkg_store.COLUMN_PACKAGE)
        self.tv.insert_column(self.tvc_pkg, 0)

        # Type Column
        self.crt_type = gtk.CellRendererText()
        self.tvc_type = gtk.TreeViewColumn("BTS Type",
            self.crt_type, text=pkg_store.COLUMN_TYPE)
        self.tv.insert_column(self.tvc_type, 1)

        # Data Column
        self.crt_data = gtk.CellRendererText()
        self.tvc_type = gtk.TreeViewColumn("BTS Data",
            self.crt_data, text=pkg_store.COLUMN_DATA)
        self.tv.insert_column(self.tvc_type, 2)

        self.load()

    @errorhandler
    def load(self):
        """Initialize the data model"""
        model = pkg_store()
        for pkg in packages.get_all():
            model.append(pkg)
        
        self.tv.set_model(model)

    @errorhandler
    def get_selection(self):
        """Get a list with the selected packages"""

        selection = self.tv.get_selection()
        model, rows = selection.get_selected_rows()

        pkgs = []
        for row in rows:
            pkgs.append(model.get(model.get_iter(row)))

        return pkgs

# vim: tabstop=4 expandtab shiftwidth=4
