--
-- Modificación de campos y funciones de la BD para la adaptacion para el plugin de Inventario
--
\echo "********* INICIADO FICHERO DE ESTRUCTURA DEL PLUGIN DE TIPOS DE TRABAJO *********"

\echo ":: Establecemos los mensajes minimos a avisos y otros parametros ... "
\echo -n ":: "
SET client_min_messages TO WARNING;
SET log_min_messages TO WARNING;
-- SET log_error_verbosity TO TERSE;
BEGIN;

--
-- Estas primeras funciones cambiar� los tipos de columnas que est� como flotantes a NUMERIC.
-- Se trata de un parche que se desea aplicar para almacenar los tipos monetarios
-- ya que actualmente se encuantran almacenados como 'doubles' y es preferible
-- que se almacenen como tipo 'numeric'.
-- Todas devuelven como valor num�ico el nmero de filas influenciadas por el cambio
-- NOTA: Si alguien sabe como pasar por par�etro un nombre de tabla y campo a modificar se
-- har� mucho m� sencillito porque s�o habr� que implementar un funci� ya que siempre
-- hay que hacer lo mismo.
--

--
-- Función auxiliar para borrar funciones limpiamente
--
create or replace function drop_if_exists_table (text) returns INTEGER AS '
DECLARE
tbl_name ALIAS FOR $1;
BEGIN
IF (select count(*) from pg_tables where tablename=$1) THEN
 EXECUTE ''DROP TABLE '' || $1;
RETURN 1;
END IF;
RETURN 0;
END;
'
language 'plpgsql';


create or replace function drop_if_exists_proc (text,text) returns INTEGER AS '
DECLARE
proc_name ALIAS FOR $1;
proc_params ALIAS FOR $2;
BEGIN
IF (select count(*) from pg_proc where proname=$1) THEN
 EXECUTE ''DROP FUNCTION '' || $1 || ''(''||$2||'') CASCADE'';
RETURN 1;
END IF;
RETURN 0;
END;
'
language 'plpgsql';



-- ========================== CONTROL DE STOCK =======================


CREATE OR REPLACE FUNCTION aux() RETURNS INTEGER AS '
DECLARE
	as RECORD;
BEGIN

	SELECT INTO as * FROM pg_tables  WHERE tablename=''tipotrabajo'';
	IF NOT FOUND THEN

		CREATE TABLE tipotrabajo (
		idtipotrabajo SERIAL PRIMARY KEY,
		nomtipotrabajo varchar NOT NULL,
		colortipotrabajo VARCHAR
		);

		
		CREATE TABLE almacentipotrabajo (
		idtipotrabajo integer NOT NULL REFERENCES tipotrabajo(idtipotrabajo),
		idalmacen integer NOT NULL REFERENCES almacen(idalmacen),
		numpers   integer DEFAULT 1 NOT NULL,
		PRIMARY KEY (idtipotrabajo, idalmacen)
		);
		
		ALTER TABLE trabajador ADD COLUMN idtipotrabajo integer REFERENCES tipotrabajo(idtipotrabajo);
		
	END IF;

	SELECT INTO as * FROM pg_attribute WHERE attname=''colortipotrabajo'';
	IF NOT FOUND THEN
		ALTER TABLE tipotrabajo ADD COLUMN colortipotrabajo VARCHAR;
	END IF;

	RETURN 0;
END;
'   LANGUAGE plpgsql;
SELECT aux();
DROP FUNCTION aux() CASCADE;
\echo "Creo las tablas de tipo de trabajo y de almacentipotrabajo, tambien agrego el campo idtipotrabajo a la tabla de trabajador"

-- ================================================Actualizada la revision de la base de datos a la version==============================


-- Agregamos nuevos parametros de configuraci�.
--
CREATE OR REPLACE FUNCTION actualizarevision() RETURNS INTEGER AS '
DECLARE
	as RECORD;
BEGIN
	SELECT INTO as * FROM configuracion WHERE nombre=''DBRev-TiposTrabajo'';
	IF FOUND THEN
		UPDATE CONFIGURACION SET valor=''0.10.1-0001'' WHERE nombre=''DBRev-TiposTrabajo'';
	ELSE
		INSERT INTO configuracion (nombre, valor) VALUES (''DBRev-TiposTrabajo'', ''0.10.1-0001'');
	END IF;
	RETURN 0;
END;
'   LANGUAGE plpgsql;
SELECT actualizarevision();
DROP FUNCTION actualizarevision() CASCADE;
\echo "Actualizada la revision de la base de datos a la version"


DROP FUNCTION drop_if_exists_table(text) CASCADE;
DROP FUNCTION drop_if_exists_proc(text,text) CASCADE;


COMMIT;
