# Copyright (C) 2006 Aaron Bentley
# <aaron.bentley@utoronto.ca>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from bzrlib.branch import Branch
from bzrlib.builtins import cmd_branch, cmd_checkout
from bzrlib.config import LocationConfig
from bzrlib.errors import BzrCommandError
from bzrlib.osutils import pathjoin, basename, abspath, getcwd
from bzrlib.urlutils import local_path_to_url

def cbranch(from_location, to_location=None, revision=None, lightweight=False):
    from_location = from_location.rstrip('/')
    if to_location is None:
        to_location = pathjoin(getcwd(), basename(from_location))
    config = LocationConfig(abspath(to_location))
    b_root = config.get_user_option("cbranch_root")
    if b_root is None:
        raise BzrCommandError("Can't find cbranch_root in branches.conf")
    b_loc = pathjoin(b_root, basename(to_location))
    cmd_branch().run(from_location, b_loc, revision=revision)
    cmd_checkout().run(b_loc, to_location, lightweight=lightweight)
    b = Branch.open(to_location)
    b.set_parent(local_path_to_url(from_location))
