/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

public class LineCap extends Enum {

    static final private int _BUTT = 0;

    static final public LineCap BUTT = new LineCap(_BUTT);

    static final private int _ROUND = 1;

    static final public LineCap ROUND = new LineCap(_ROUND);

    static final private int _SQUARE = 2;

    static final public LineCap SQUARE = new LineCap(_SQUARE);

    static final private LineCap[] theInterned = new LineCap[] { BUTT, ROUND,
            SQUARE };

    static private java.util.Hashtable theInternedExtras;

    static final private LineCap theSacrificialOne = new LineCap(0);

    static public LineCap intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        LineCap already = (LineCap) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new LineCap(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private LineCap(int value) {
        value_ = value;
    }

    public boolean test(LineCap other) {
        return (value_ & other.value_) == other.value_;
    }
}
