/* Copyright (C) 2005 The cairomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __CAIROMM_H
#define __CAIROMM_H

/** @mainpage Cairomm: A C++ wrapper for the cairo graphics library
 *
 * @section License
 * Cairomm is available under the terms of the LGPL license
 *
 * @section Introduction
 * If you're just beginning to learn cairomm, a good place to start is with the
 * Cairo::Surface and Cairo::Context classes.  In general terms, you draw onto
 * a Surface using the graphics settings specified in your Context.
 *
 */

#include <cairomm/context.h>
#include <cairomm/surface.h>
#include <cairomm/fontoptions.h>
#include <cairomm/pattern.h>
#include <cairomm/path.h>
#include <cairomm/enums.h>

#endif //__CAIROMM_H

// vim: ts=2 sw=2 et
