#include <qthread.h>

class MyThread: public QThread
{
  public:
    virtual void run();
};

void MyThread::run()
{
  qDebug(" Thread %x started", QThread::currentThread());
  for( int count = 0; count < 4; count++ ) {
    sleep( 1 );
    qDebug( "Ping from %x (count %d)!",
            QThread::currentThread(), count );
  }
}

int main()
{
  MyThread a;
  MyThread b;
  MyThread c;
  qDebug( "main: Starting Threads...");
  a.start();
  b.start();
  c.start();
  qDebug( "main: Waiting for thread termination...");
  a.wait();
  b.wait();
  c.wait();
  qDebug( "main: Terminating...");
}

