/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2001 The Caudium Group
 * Copyright  1994-2001 Roxen Internet Software
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_layout_manager.pike,v 1.12.2.3.2.1 2001/09/24 11:10:57 kiwi Exp $
 */

#include <module.h>
inherit "module";

inherit "caudiumlib";

//
//! module: CAMAS: Layout Manager
//!  Layout Manager Module for CAMAS.<br />
//!  This module provides CAMAS the names of layouts (e.g. skins) that can
//!  be used. You can use this module to force a layout different than the
//!  default one when there is user definied "Layout Filesystem" in the
//!  current configuration.<br />
//!  <b>This module is automatically selected if you select "CAMAS: Main 
//!  module".</b>
//! inherits: module
//! inherits: caudiumlib
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_layout_manager.pike,v 1.12.2.3.2.1 2001/09/24 11:10:57 kiwi Exp $
//

constant cvs_version = "$Id: camas_layout_manager.pike,v 1.12.2.3.2.1 2001/09/24 11:10:57 kiwi Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Layout Manager";
constant module_doc  = "Layout Manager Module for CAMAS.<br />"
                       "This module provides CAMAS the names of layouts (e.g. "
                       "skins) that can be used. You can use this module to "
                       "force a layout different than the default one when is "
                       "user definied \"Layout Filesystem\" in the current "
                       "configuration.<br /><b>This module is automaticaly "
                       "selected if you select \"CAMAS: Main module\".</b>";
constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)

mapping (string:object) layouts = ([ ]);

void create () {
  defvar ("nodefault", 0, "Hide the Default layout", TYPE_FLAG,
	  "If custom layouts are available, hide the 'Default' layout from the users.", 0,
	  lambda () { return (sizeof (my_configuration ()->get_providers ("camas_layout")) == 1); });

  defvar ("debug", 0, "Debug", TYPE_FLAG,
	  "When on, debug messages will be logged in Caudium's debug logfile. "
	  "This information is very useful to the developers when fixing bugs.");
}

void init_layouts (object conf) {
  array (object) providers = conf->get_providers ("camas_layout");
  if (sizeof (providers))
    foreach (providers, object p)
      if (p->name () != "NONE")
	layouts[p->name ()] = p;
}

void add_layout (object p) {
  if (layouts[p->name ()])
    write ("warning: layout overwriting [" + p->name () + "] ...\n");

  layouts[p->name ()] = p;
}

void remove_layout (object p) {
  if (p && layouts[p->name ()])
    m_delete (layouts, p->name ());
}

void start (int num, object conf) {
  init_layouts (conf);
}

string status () {
  string out = "CAMAS Layouts Manager Module :<br />";
  if (sizeof (layouts)) {
    array tmp = sort (indices (layouts));
    if (QUERY (nodefault))
      tmp -= ({ "Default" });
    if (sizeof (tmp)) {
      out += sprintf ("Provides th%ss%s layout%s :<ul>",
		      (sizeof (tmp) == 1) ? "i" : "e",
		      (sizeof (tmp) == 1) ? "" : "e",
		      (sizeof (tmp) == 1) ? "" : "s");
      foreach (tmp, string l)
	out += "<li>" + l + "</li>";
      out += "</ul>";
    }
    else
      out += "Default Layout";
  }
  return out;
}

array (string) list_layouts () {
  array lay = sort (indices (layouts));
  return ((sizeof (layouts) > 1) && QUERY(nodefault)) ? (lay - ({ "Default" })) : lay;
}

string query_provides ()
{
  return ("camas_layout_manager");
}

string get_layout (string layout, void|int screen) {
  string lay_str = 0;
  if (layouts[layout] && layouts[layout]->get_layout)
    lay_str = layouts[layout]->get_layout (screen);

  if (!lay_str && QUERY(debug))
    write ("camas_layout_manager: did no find screen '" + screen + "' in layout '" + layout + "'\n");

  return (lay_str) ? lay_str : layouts["Default"]->get_layout (screen);
}

int has_frameset (string layout) {
  //write ("LM::has_frameset () " + ((layouts[layout] && layouts[layout]->has_frameset) ? layouts[layout]->has_frameset () : 0) + "\n");
  return (layouts[layout] && layouts[layout]->has_frameset) ? layouts[layout]->has_frameset () : 0;
}

string get_frameset (string layout) {
  //write ("LM::get_frameset (" + layout + ") => " + ((layouts[layout] && layouts[layout]->get_frameset) ? layouts[layout]->get_frameset () : "") + "\n");
  return (layouts[layout] && layouts[layout]->get_frameset) ? layouts[layout]->get_frameset () : "";
}

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: nodefault
//! If custom layouts are available, hide the 'Default' layout from the users.
//!  type: TYPE_FLAG
//!  name: Hide the Default layout
//
//! defvar: debug
//! When on, debug messages will be logged in Caudium's debug logfile. This information is very useful to the developers when fixing bugs.
//!  type: TYPE_FLAG
//!  name: Debug
//
