(*********************************************************************************)
(*                Cameleon                                                       *)
(*                                                                               *)
(*    Copyright (C) 2005 Institut National de Recherche en Informatique et       *)
(*    en Automatique. All rights reserved.                                       *)
(*                                                                               *)
(*    This program is free software; you can redistribute it and/or modify       *)
(*    it under the terms of the GNU Library General Public License as            *)
(*    published by the Free Software Foundation; either version 2 of the         *)
(*    License, or  any later version.                                            *)
(*                                                                               *)
(*    This program is distributed in the hope that it will be useful,            *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of             *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *)
(*    GNU Library General Public License for more details.                       *)
(*                                                                               *)
(*    You should have received a copy of the GNU Library General Public          *)
(*    License along with this program; if not, write to the Free Software        *)
(*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA                   *)
(*    02111-1307  USA                                                            *)
(*                                                                               *)
(*    Contact: Maxence.Guesdon@inria.fr                                          *)
(*                                                                               *)
(*********************************************************************************)

(* $Id$ *)



class buffer mode =
  let buf = GText.buffer () in
  object(self)
    val mutable mode = mode
    method set_mode (m : Ed_mode.mode) =
      mode <- m;
      List.iter
        (fun (name, props) ->
          ignore (buf#create_tag ~name props))
        mode#keywords;
(*      buf#create_tag ~name:"error" [`FOREGROUND "red"; `WEIGHT `BOLD];*)
      self#retag_all_buffer

    method retag_all_buffer =
      buf#remove_all_tags ~start: buf#start_iter ~stop: buf#end_iter;
      self#tag ~start: buf#start_iter ~stop: buf#end_iter;

    method tag ~start ~stop = ()

    initializer
      self#set_mode mode;

  end
