/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ITKFiltersExtension.h"
// include generated actions headers
#include "CannyEdgeDetection.h"
#include "SobelEdgeDetection.h"
#include "GradientMagnitude.h"
#include "GradientMagnitudeRecursiveGaussian.h"
#include "Derivative.h"
#include "Laplacian.h"
#include "LaplacianRecursiveGaussian.h"
#include "LaplacianSharpening.h"
#include "MeanFilter.h"
#include "MedianFilter.h"
#include "MorphologicalOperators.h"
#include "GaussianFilter.h"
#include "AnisotropicDiffusion.h"
#include "ConnectedComponents.h"


// --------------- declare the extension -------------------
Q_EXPORT_PLUGIN2(itkfiltersextension, ITKFiltersExtension);

// --------------- getActions -------------------
void ITKFiltersExtension::init() {
    registerNewAction(CannyEdgeDetection);
    registerNewAction(SobelEdgeDetection);
    registerNewAction(GradientMagnitude);
    registerNewAction(GradientMagnitudeRecursiveGaussian);
    registerNewAction(Derivative);
	registerNewAction(Laplacian);
	registerNewAction(LaplacianRecursiveGaussian);
	registerNewAction(LaplacianSharpening);
	registerNewAction(MeanFilter);
	registerNewAction(MedianFilter);
	registerNewAction(MorphologicalOperators);
	registerNewAction(GaussianFilter);
	registerNewAction(AnisotropicDiffusion);
	registerNewAction(ConnectedComponents);
}

