/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef AUDIOSAMPLE_HPP
#define AUDIOSAMPLE_HPP

#include <qshared.h>

#include "SoundAttributes.h"


typedef unsigned long SamplePos;

class CAudioSample
{
private:
   void Init();
   void ReInit();
   void Reset();
   void CalculateOffsets() const;

protected:
   struct SampleData: public QShared // internal
   {
     SoundAttributes Attributes;
     int BytesPerSample;
     int PositionOffset[SoundAttributes::MaxPosition]; ///< Mapping from channel to memory offset in raw stream

      void *pMemBuffer;         ///< All classes use a memory buffer
      SamplePos BufLength;      ///< Buffer Length in samples

      SamplePos BufStartOffset; ///< In case this is a portion of a larger sample(stream), this is the position within that sample
   } *m_pData;


   CAudioSample(const SoundAttributes &attrs, SamplePos buffer_length);

   void SetSoundAttributes(const SoundAttributes &) const;
   int GetBytesPerSample() const;

   bool CreateBuffer(const SoundAttributes &attrs, SamplePos buffer_length);
   // ResizeBuffer(SamplePos buffer_length);
   void Detach();

public:
   CAudioSample();
   CAudioSample(const CAudioSample &);
   virtual ~CAudioSample();

   CAudioSample &operator =(const CAudioSample &audio_sample);
   //CAudioSample Copy() const;

   SoundAttributes GetSoundAttributes() const;
   bool IsNull() const;

   virtual SamplePos TotalLength() const;
   virtual bool CanSeek() const;
   virtual bool SeekTo(SamplePos offset);

   virtual int GetValue(SamplePos offset, SoundAttributes::Position channel) const;
   virtual void SetValue(SamplePos offset, SoundAttributes::Position channel, int value);
};

#endif
