#ifndef WEBCAMVIEWER_HPP
#define WEBCAMVIEWER_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qpixmap.h>
#include <qbutton.h>
#include <qdatetime.h>
#include <qglobal.h>
#include <qtimer.h>
#include <qurloperator.h>
#include <qvaluelist.h>
#if QT_VERSION >= 0x30000
#include <qprocess.h>
#endif

#include "lib/FTPClient.h"
#include "AudioDevice.h"
#include "AudioDisplayVolume.h"
#include "VideoDevice.h"

#include "gui/AudioSettingsDlg.h"
#include "gui/SnapshotSettingsDlg.h"
#include "gui/TimeSnapshot.h"

#include "CamWindow.h"
#include "BasicPanel.h"
#include "ImagePanelRGB.h"
#include "ImagePanelYUV.h"

class CWebCamViewer: public CCamWindow
{
   Q_OBJECT
private:
   enum {
     pbt_ctl_size,
     pbt_ctl_video,
     pbt_ctl_input,
     pbt_ctl_tuner,
     pbt_mute,
     pbt_config,
     pbt_showsnap,
     pbt_snapshot,
     pbt_timesnap,
     pbt_snd_config,
     pbt_MAX,
   } PushButtons;
   QToolButton *pButton[pbt_MAX];

   CVideoDevice *pVideo;	///< The video device
   CCamPanel *pViewer;		///< The main image viewer
   CBasicPanel *pLastSnapshot;	///< Extra panel that shows the last snapshot
   QTimer m_SizeTimer;		///< Helper timer for adjustSize()

   CVideoOptions *pVOptions;	///< Our options
   CSnapshotSettingsDlg *m_pSnapshotSettingsDlg;	///< Configuration dialog

   int m_SnapInterval, m_SnapCounter;
   QTimer *pSnapTimer;
   QLabel *pSnapLabel;

   /// Upload data
   struct FTPCommandStruct
   {
      int Command;
      QString Param[4];
   };

   struct _Upload {
     CFTPClient *pClient;
     QList<FTPCommandStruct> Commands;

     QString LocalFile, RemoteFile;

     QTime StartTime;
     bool ErrorCondition;
   } Upload;

#if QT_VERSION >= 0x30000
   struct _Command {
     QProcess Process;
     QString FileName;
     bool Delete;
   } m_ExternalCommand;
#endif

   void StartFTPUpload(const QString &local, const QString &remote, bool);
   void StopFTP();
   void TriggerNextFTPCommand();

   void StartSubProcess(const QString &command, const QString &filename, bool del_after_use);

private slots:
   void ClickedVideoConfig();
   void ClickedShowLastSnapshot();
   void ClickedTimeSnapDlg();
   void ClickedSoundOnOff();

   void FTPChangeState(int command, int new_state, int result, const QString &server_msg);
   void NextFTPCommand();
   void FTPClosed();

   void SubProcessDone();

   void StartTimeSnap(int interval);
   void StopTimeSnap();
   void TimeSnapTick();
   void TakeSnapshot();

//   void UpdateAudioDisplay();
   void CycleNextChannel();
   void CyclePrevChannel();
   void NewChannelSelected();

protected:
   void RecalcTotalViewSize();

protected slots:
   void DeviceChangedSize(const QSize &size);
   void DeviceError(int err_no);

   void CallAdjustSize();

public:
   CWebCamViewer(CVideoDevice *video, QWidget *parent = 0, const char *name = 0);
   virtual ~CWebCamViewer();

virtual void showMaximized();
};

#endif
