/**
  \class CCodecImageViewer
  \brief Helper viewer for CodecImage

*/

#include <qpainter.h>

#include "CodecImageViewer.h"

CCodecImageViewer::CCodecImageViewer(CCodecImage *y, CCodecImage *u, CCodecImage *v, QWidget *parent, const char *name, WFlags f)
	: QWidget(parent, name, f | WRepaintNoErase)
{
   m_pCodecY = y;
   m_pCodecU = u;
   m_pCodecV = v;
   Resize();
}

// private

// protected
void CCodecImageViewer::paintEvent(QPaintEvent *e)
{
   QPainter p(this);
   p.drawImage( 0, 0, m_QImageY);
   p.drawImage( 0, h, m_QImageU);
   p.drawImage(w2, h, m_QImageV);
}


   // public

void CCodecImageViewer::Resize()
{
   int i;

   w = m_pCodecY->Width();
   h = m_pCodecY->Height();
   w2 = w / 2;
   h2 = h / 2;

   m_QImageY.create( w,  h, 8, 256);
   m_QImageU.create(w2, h2, 8, 256);
   m_QImageV.create(w2, h2, 8, 256);

   if (w > 0 && h > 0)
   {
     for (i = 0; i < 256; i++)
     {
        m_QImageY.setColor(i, qRgb(i, i, i));
        m_QImageU.setColor(i, qRgb(i, i, i));
        m_QImageV.setColor(i, qRgb(i, i, i));
     }
   }
   setFixedSize(w, h + h2);
}

/** Convert image from CCodecImage into QImage */
void CCodecImageViewer::Update()
{
   if (m_pCodecY != 0)
     m_pCodecY->Store(w, h, m_QImageY.bits());

   update(); // repaint
}
