.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkDefine.man,v 2.1 1994/04/21 00:46:10 kuma Exp $ NEC;
.TH "RKDEFINEDIC" "3"
.SH "NAME"
\f4RkDefineDic\f1 \- define specified candidates in the dictionary
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkDefineDic(cxnum, dicname, wordrec)
int cxnum;
char *dicname;
char *wordrec;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkDefineDic\f1 defines specified candidates in the dictionary named by \f2dicname\f1.  Specify the word to add in the character string \f2wordrec\f1, which is written in the format:
.P
.RS
reading   part-of-speech information   kanji candidate
.RE
.P
Writing \f2wordrec\f1, for example, as 
.P
.RS
(HIRAGANA)     #T35     (KANJI)  ...
.RE
.P
will specify a candidate whose part of speech #T35 is defined by the reading "(HIRAGANA)" and whose spelling matches "(KANJI)".
.SH "RETURN VALUE"
This function returns \f40\f1 if successful; otherwise it returns \f4-1\f1.  It also returns \f4-1\f1, without doing anything, if it has been run in a conversion mode context.
