#
#   Copyright (C) 1998, 1999, 2000, 2001 Loic Dachary
#
#   This program is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation; either version 2, or (at your option) any
#   later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software 
#   Foundation, Inc. 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA.
#
# 
# $Header: /cvsroot/catalog/catalog/Makefile.PL,v 1.54 2001/07/11 12:09:09 loic Exp $
#
# This -*- perl -*- script writes the Makefile for Catalog

require 5;
use strict;

#--- Configuration section ---

my(@programs_to_install) = qw(convert_dmoz sengacontrib);

use ExtUtils::MakeMaker;

require "conf/lib.pl";

version_check('DBI', '1.13', 'require DBI;');
version_check('MD5', '1.7', 'require MD5;');
version_check('CGI', '2.74', 'require CGI;');
version_check('XML::Parser', '2.28', 'require XML::Parser;');
version_check('XML::DOM', '1.25', 'require XML::DOM;');
version_check('HTML::Parser', '3.11', 'require HTML::Parser;');
version_check('Text::Iconv', '1.1', 'require Text::Iconv;');
version_check('Text::Query', '0.07', 'require Text::Query;');
version_check('Text::Query::BuildSQL', '0.07', 'require Text::Query::BuildSQL;');

my($subdirs) = "cgi-bin conf example images doc";

sub MY::postamble { 
return '
clean ::
	rm -fr t/fulcrum t/tmp t/conf/mysql.conf t/conf/install.conf
	rm -fr t/conf/db.conf t/conf/fulltext.conf

ptags:
	ptags lib/Catalog.pm lib/Catalog/???*.pm lib/Catalog/db/*pm lib/Catalog/tools/[cmst]*.pm

cvs_diff_tag :
	$(MAKE) realclean
	cvs diff -c -r`sed "s/^T//" CVS/Tag` > `sed "s/^T//" CVS/Tag`-`date "+%Y%m%d"`.diff

realclean ::
	rm -fr MANIFEST.bak Catalog-*

install:: 
	for i in ' . $subdirs . ' ; do ( cd $$i ; $(MAKE) install ) ; done
	@echo ; echo "Read the Catalog management guide chapter in the Catalog documentation "
	@echo "at http://www.senga.org/Catalog/"
	@echo "Go to the URL http://www.mymachine.org/Catalog/ for the ready to use example."

';
}

WriteMakefile(
  'VERSION_FROM' => 'lib/Catalog.pm',
  'NAME'	 => 'Catalog',
  'DIR'          => [ split(" ", $subdirs) ],
  'EXE_FILES'    => [ 'bin/convert_dmoz', 'bin/index_dmoz' ],
  'MAN1PODS'     => { 'doc/Catalog.pod' => 'blib/man1/Catalog.1' },
  'dist'         => { COMPRESS => 'gzip', SUFFIX => '.gz' },
);


