/*
 * Caudium - An extensible World Wide Web server
 * Copyright <A9> 2000 The Caudium Group
 * Copyright <A9> 1994-2000 Roxen Internet Software
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <module.h>
inherit "module";
inherit "caudiumlib";

constant cvs_version = "$Id: explicit_hostname.pike,v 1.6 2003/02/28 16:27:06 kiwi Exp $";

//! module: Explicit Hostname Redirector
//!  The explicit hostname redirector is designed with only one purpose in mind. The module examines the host header of any incoming request and if it doesn't match one of the hostnames configured in the configuration interface then it redirects the connection to an explicit hostname.
//! type: MODULE_PRECACHE | MODULE_FIRST
//! inherits: module
//! inherits: caudiumlib
//! cvs_version: $Id: explicit_hostname.pike,v 1.6 2003/02/28 16:27:06 kiwi Exp $

constant thread_safe = 1;
constant module_name = "Explicit Hostname Redirector";
constant module_doc = "The explicit hostname redirector is designed with only one purpose in mind. The module examines the host header of any incoming request and if it doesn't match one of the hostnames configured in the configuration interface then it redirects the connection to an explicit hostname.";
constant module_unique = 1;
constant module_type = MODULE_PRECACHE | MODULE_FIRST ;

multiset allowed_hosts = (< >);

void create() {
	defvar( "allowhosts", ({ }), "Allowed Hostnames", TYPE_STRING_LIST, "A comma seperated list of hostname's for which connections will be passed on to the webserver without redirection." );
	defvar( "redirectto", "", "Redirect To", TYPE_STRING, "The hostname to redirect the connection to if it doesn't match one of the hostnames specified. Be careful not to create redirection loops!" );
}

void start() {
	allowed_hosts = mkmultiset( query( "allowhosts" ) );
}


mapping first_try( object id ) {
  return id->misc->redir;
}
void precache_rewrite(object id) {
  // If this is empty, shouldn't it always redirect then? Seems to me like a logic
  // error, neh? No allowed hosts == always redirect?
  // --david
  if ( !sizeof(allowed_hosts) ) {
    return;
  }
  if ( allowed_hosts[ id->request_headers->host ] ) {
    return;
  } else {
    // http/https disambiguation borrowed from redirect.pike
    string p = "", prot = "http://";
    if(id->ssl_accept_callback) {
      // This is an SSL port. Not a great check, but what is one to do?
      p = ":443";
      prot = "https://";
    }
    id->misc->redir = Caudium.HTTP.redirect( sprintf( "%s%s%s%s", prot,
                                             query( "redirectto" ),
                                             p,
                                             id->raw_url ));
    return;
  }
}

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: allowhosts
//! A comma seperated list of hostname's for which connections will be passed on to the webserver without redirection.
//!  type: TYPE_STRING_LIST
//!  name: Allowed Hostnames
//
//! defvar: redirectto
//! The hostname to redirect the connection to if it doesn't match one of the hostnames specified. Be careful not to create redirection loops!
//!  type: TYPE_STRING
//!  name: Redirect To
//
