/*
 * KON2 - Kanji ON Console -
 * Copyright (C) 1992-1996 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)
 *
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT

 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include        <stdio.h>
#include        <stdlib.h>
#include        <sys/types.h>
#include        <sys/file.h>
#include        <string.h>
#include        <unistd.h>
#include        <sys/ipc.h>
#include        <sys/shm.h>

#include        <font.h>

int main(void)
{
    int i, shmid;
    FontInfo *fi;

    printf("\n No. ShmId Font Name       Size  MemSize\n"
             "+---+-----+---------------+-----+-------+\n");

    for(i = 0; fSRegs[i].registry; i++)
    {
        if ((shmid = GetShmId(i|CHR_SFLD)) < 0) continue;

        if ((fi = (FontInfo*)shmat(shmid, 0, SHM_RDONLY)))
          printf("%3X %6d %-15s %2dx%2d %7d\n",
               i, shmid, fDRegs[i].registry,
               fi->width, fi->high, fi->size);

    }

    for(i = 0; fDRegs[i].registry; i++)
    {
        if ((shmid = GetShmId(i|CHR_DFLD)) < 0) continue;

        if ((fi = (FontInfo*)shmat(shmid, 0, SHM_RDONLY)))
          printf("%3X %6d %-15s %2dx%2d %7d\n",
               i, shmid, fDRegs[i].registry,
               fi->width, fi->high, fi->size);

    }
    
    printf("\n");
    return 0;
}

