/***************************************************************************
                          NewAudioCdCompilationView.cpp  -  description
                             -------------------
    begin                : Sun Nov 18 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>

/* QT includes */
#include <qpainter.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qgrid.h>
#include <qevent.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>

/* KDE includes */
#include <kcontainer.h>
#include <kmainwindow.h>
#include <kprogress.h>
#include <kio/job.h>
#include <kio/jobclasses.h>

/* cdbakeoven includes */
#include "NewAudioCdCompilationView.h"
#include "CdboCompilationView.h"
#include "cdbakeoven.h"

#include "widgets/AudioTreeCntPanel.h"
#include "widgets/AudioEstimatePnl.h"
//#include "widgets/fileViews/FilesListView.h"
//#include "widgets/fileViews/FoldersListView.h"
#include "widgets/fileViews/AudioCompilationTreeView.h"

NewAudioCdCompilationView::NewAudioCdCompilationView(CDBakeOvenApp * cdboApp, QWidget *parent, const char *name) :
			CdboCompilationView(cdboApp, parent, name){
	
	initView();
}

NewAudioCdCompilationView::~NewAudioCdCompilationView(){
}

void NewAudioCdCompilationView::initView(){

// -------------------- TargetTreeCntPanel ------------------------
	targetCnt = new AudioTreeCntPanel(this);
	targetCnt->resize(10,10);

// --------------------  CompilationTreeView ------------------------
	compilView = new AudioCompilationTreeView(this, "audioCompilView");
  	compilView ->setFocusPolicy(QWidget::ClickFocus);
  	compilView ->setCDBOApp(cdboApp);

// --------------------  EstimatePnl ------------------------
  	estimate = new AudioEstimatePnl(this,"estimate" );
  	compilView->setEstimate(estimate);
  	
  	
  	
//=============== SLOTS & SIGNALS =====================================
	
						
	
						
//////////////////////INNER//////////////////////////
							
	
	connect( targetCnt->getShowPropBtn(), SIGNAL(clicked()),
						compilView, SLOT(slotProperties()) );
	
	connect( targetCnt->getDeleteNodeBtn(), SIGNAL(clicked()),
						compilView, SLOT(remove()) );
	connect( targetCnt->getIsoPropBtn(), SIGNAL(clicked()),
						compilView, SLOT(compilSettingsSlot()) );
						
	connect( targetCnt->getBurnBtn(), SIGNAL(clicked()),
						compilView, SLOT(createCD()) );
						
						
}
//==============================
void NewAudioCdCompilationView::saveOptions(){
	//estimate->saveOptions();
}
//==============================
void NewAudioCdCompilationView::showTargetControl(bool doShow){
	if(!doShow)
		targetCnt->hide();
	else
		targetCnt->show();
}
//==============================
void NewAudioCdCompilationView::showEstimate(bool doShow){
	if(!doShow)
		estimate->hide();
	else
		estimate->show();

}

