/***************************************************************************
                          cdbakeoven.h  -  description
                             -------------------
    begin                : Fri May 18 23:05:50 EDT 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDBAKEOVEN_H
#define CDBAKEOVEN_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

#include <qlist.h>

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kio/job.h>



// forward declaration of the CDBakeOven classes
class CDBakeOvenView;
class KProgress;
class QLabel;
class QPushButton;


//KProcess cdboProc;
/**
  * The base class for CDBakeOven application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of CDBakeOvenView creates your center view, which is connected
  * to the window's Doc object.
  * CDBakeOvenApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class CDBakeOvenApp : public KMainWindow
{
  Q_OBJECT

  friend class CDBakeOvenView;

signals:
	void longProcessCanceled();
	void longProcessCanceled(QString);	
	void settingsChanged();
	void newList();
	void newList(QString);
	
	void saveList();
	void saveListAs();
	void loadSession();
	
public:
    /** construtor of CDBakeOvenApp, calls all init functions to create the application.
     */
    CDBakeOvenApp(QWidget* parent=0, const char* name=0);
    ~CDBakeOvenApp();
    /** opens a file specified by commandline option
     */
    void openDocumentFile(const KURL& url=0);
	/** try to show main dialog if */
    void tryToShowMainDialog();
	void popUpSettings(int type);

public slots:
	void emitSettingsChanged();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** clears the document in the actual view to reuse it as the new document */
    void slotAudioNew();
    /** clears the document in the actual view to reuse it as the new document */
    void slotDataNew();
     /** clears the document in the actual view to reuse it as the new document */
     void slotAdvancedNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(const KURL& url);
	/** pops up main dialog */
    void slotShowMainDialog();
    /** pops up main dialog */
    void popupCopyDialog();
    /** pops up settings dialog */
    void popupSettingsDialog();
    /** pops up erase dialog */
    void popupEraseDialog();
    /** pops up music dialog */
    void popupMusicDialog();
    /** pops up new cd dialog */
    void popupNewCdDialog();
    /** pops up new Data cd dialog */
    void  popupNewDataCdDialog();
    void  popupFixateCdDialog();
	/* bla bla */
    void cancelOperation();

    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();

    void slotFileSaveAs();
	void slotFileSave();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the toolbar
     */
    void slotShowCompilContPnl();
    	/** toggles the toolbar
     */
    void slotShowSourceContPnl();
    	/** toggles the toolbar
     */
    void slotShowEstimatePnl();
    	/** toggles the toolbar
     */
    void slotShowFilterPnl();
    /** toggles the statusbar
     */
     void loadSessionSlot();
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    //void slotNewFileName(const QString &text);


//////+++++++++++++++++++++++++++++++////////
	void startShowProgress();
	void stopShowProgress();
	
	/* a way to register a job */
	inline void addJob(KIO::Job *job) { jobs.append(job);}
	inline void removeJob(KIO::Job *job) { jobs.remove(job); }
	
protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /* reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);
    	
protected slots:
 	virtual void timerEvent(QTimerEvent *event);

private:
	KConfig *config;
    	CDBakeOvenView *view;

    	// KAction pointers to enable/disable actions
	KToggleAction* viewToolBar;
    	KToggleAction* viewStatusBar;
    	
    	
    	KAction* fileNewMusic;
    	KAction* fileNewData;
    	KAction* fileNewAdvancedData;
    	KAction* fileNewMix;
    	
    	KToolBarPopupAction* fileNewAction;
    	KListAction* fileNewListAction;
    	
    	KAction* fileOpen;
    	KRecentFilesAction* fileOpenRecent;

    	
    	KAction* quit;
    	KAction* showMainDialog;
    	KAction* showSettingsDialog;
    	KAction* showCopyDialog;
    	KAction* showFixateDialog;
    	KAction* showEraseDialog;
    	KAction* showCreateDialog;
    	KAction* loadSessionAction;
    	KAction* fileSave;
    	KAction* fileSaveAs;
    	
    	KToggleAction* showFilterPnl;
    	KToggleAction* showEstimatePnl;
    	KToggleAction* showSourceContPnl;
    	KToggleAction* showCompilContPnl;
    	
	//---------------------
    	
    	QList <KIO::Job>jobs;
    	
    	KProgress *progress;
    	QLabel *info;
    	QLabel *status;
    	QPushButton *cancelOperationBtn;
    	
    	int eTimeId;
  	int lastPercent;

	bool shouldShowMainDialog;
	bool isRunningSomething();
};
#endif // CDBAKEOVEN_H