/***************************************************************************
                          ExpandPnl.cpp  -  description
                             -------------------
    begin                : Fri May 18 23:05:50 EDT 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "ExpandPnl.h"

#include <qframe.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kiconloader.h>
#include <kapp.h>
#include <kconfig.h>

/* 
 *  Constructs a ExpandPnl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
ExpandPnl::ExpandPnl(QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    	if ( !name )
		setName( "ExpandPnl" );
	config = kapp->config();
	id = "Generic Item In ExpandPnl is";
}
//========================================
void ExpandPnl::addCustomWidget(QWidget* customWidget){
    config->setGroup("General Options");		
	expanded =! config->readBoolEntry(id + " Expanded", true);
    expandPnlLayout = new QHBoxLayout( this );
    expandPnlLayout->setSpacing( 0 );
    expandPnlLayout->setMargin( 0 );

    expandBtnFrm = new QFrame( this, "expandBtnFrm" );
    expandBtnFrm->setMaximumSize( QSize( 8, 32767 ) );
    expandBtnFrm->setFrameShape( QFrame::NoFrame );
    expandBtnFrm->setFrameShadow( QFrame::Plain );
    expandBtnFrmLayout = new QVBoxLayout( expandBtnFrm ); 
    expandBtnFrmLayout->setSpacing( 0 );
    expandBtnFrmLayout->setMargin( 0 );

    expandBtn = new QToolButton( expandBtnFrm, "expandBtn" );
    expandBtn->setMaximumSize( QSize( 8, 32767 ) );
    expandBtn->setText( tr( "" ) );
    expandBtn->setPixmap( UserIcon("2vertrightarrow") );
    //expandBtn->setAutoRaise( TRUE );
    expandBtnFrmLayout->addWidget( expandBtn );
    expandPnlLayout->addWidget( expandBtnFrm );
	this->customWidget = customWidget;
    expandPnlLayout->addWidget( customWidget );

    // signals and slots connections
    connect( expandBtn, SIGNAL( clicked() ), this, SLOT( expandSlot() ) );
	expandSlot();

}

/*  
 *  Destroys the object and frees any allocated resources
 */
ExpandPnl::~ExpandPnl(){
}
//========================
void ExpandPnl::saveOptions(){
	config->setGroup("General Options");		
	config->writeEntry(id + " Expanded", expanded);
}
//===============================================================
void ExpandPnl::expandSlot(){
	if(!customWidget) 	return;
	if(expanded){
    		customWidget->hide();
    		expandBtn->setPixmap( UserIcon("2vertleftarrow") );
    	}
    	else{
    		customWidget->show();
    		expandBtn->setPixmap( UserIcon("2vertrightarrow") );
    	}
    	expanded = !expanded;
}

//===============================================================
void ExpandPnl::expandSlot(bool doExpand){
	if(!customWidget || expanded == doExpand) 	return;
	if(!doExpand){
    		customWidget->hide();
    		expandBtn->setPixmap( UserIcon("2vertleftarrow") );
    	}
    	else{
    		customWidget->show();
    		expandBtn->setPixmap( UserIcon("2vertrightarrow") );
    	}
    	expanded = !expanded;
}
