/***************************************************************************
                          AudioCompilationTreeView.h  -  description
                             -------------------
    begin                : Sun Nov 18 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef AUDIOCOMPILATIONLISTVIEW_H
#define AUDIOCOMPILATIONLISTVIEW_H

#include <qwidget.h>
#include <qlistview.h>
#include <qevent.h>
#include <qdict.h>

#include <kio/job.h>
#include <klistview.h>

#include "CompilationTreeView.h"

class QPopupMenu;
class QListViewItem;
class AudioEstimatePnl;
class KConfig;

class AudioCompilationTreeView : public CompilationTreeView  {
   Q_OBJECT
public:
	AudioCompilationTreeView( QWidget *parent=0L, const char *name=0L);
	~AudioCompilationTreeView();
	
	void setEstimate(AudioEstimatePnl *e);

public slots:	
	virtual bool addItem(QString);
	virtual void updateSettings();
	virtual void compilSettingsSlot();	


	void recalculate();
	void longProcessCanceled(QString);
	void createCD();
		
	
signals:
	void processStarted();
	void longProcessStarted(KIO::Job *);
	void processDone();
	void longProcessDone(KIO::Job *);
	void haveStatus(const QString &);
			

protected slots:	
	void audioPickerDone(KIO::Job *);
	void popupMenuSlot(QListViewItem*, const QPoint&, int);

protected:	
	virtual inline QString getType() { return "New Audio CD"; }
	virtual void resetTotal();
	virtual void subtractFromTotal(int);
	
private:
	bool canAccept(QString path);
	bool pickAudioFromDir(QString path);
	void addFileItem(QString path, QString name);
	
	AudioEstimatePnl *estimate;
	KConfig *config;
	QStringList extList;
	bool cdboDtct;
	
	
	//QPopupMenu *folderMenu;
	QPopupMenu *fileMenu;
	QPopupMenu *isoMenu;

	int hiddenIndex;
	int hiddenFIndex;
	int createIsoIndex;
	int createIsoIndexInFileMenu;
	int createIsoIndexInFolderMenu;
	bool showHidden;
	int haveItemsIndex;
	int createCDIndex;
	int createISOIndex;
	
	
};
#endif