#This is the main tcl library for anything that the user can see and manipulate.

proc interface {} {
	global cfg
	wm title . "CDRBQ - [version]"

	menu .menubar

	menu .menubar.bbq -tearoff 0
	.menubar add cascade -label "BBQ" -menu .menubar.bbq -underline 0

	set m .menubar.bbq
	$m add command -label {Have a Cook-Off} -accelerator "F1" -underline 7 -command {toast}
	$m add command -label {Quit} -accelerator "F10" -underline 0 -command {destroy .}
	bind . "<Key F1>" {toast}
	bind . "<Key F10>" {destroy .}

	menu .menubar.tricks -tearoff 0
	set m .menubar.tricks

	.menubar add cascade -label "Do Tricks" -menu $m -underline 0
	$m add command -label "Read CDROM to create ISO image" -underline 21 -command {read_iso}
	$m add command -label "Read CDROM to create a CUE/BIN image" -underline 23 -command {read_cuebin}
	$m add command -label "Read audio tracks from CDROM" -underline 5 -command {read_audio}
	$m add command -label "Blank a CDRW media" -underline 0 -command {blank_cdrw}
	$m add command -label "Fixate a multisession CD" -underline 0 -command {fix_cdrw}

	menu .menubar.pref -tearoff 0
	set m .menubar.pref
	.menubar add cascade -label "Preferences" -menu $m -underline 0
	$m add command -label "Save settings" -accelerator "F5" -underline 0 -command {pref_save 0}
	$m add command -label "Load settings" -accelerator "F6" -underline 0 -command {pref_load 0}
	$m add command -label "Load default settings" -accelerator "F7" -underline 5 -command {pref_init 0}
	bind . "<Key F5>" {pref_save 1}
	bind . "<Key F6>" {pref_load 1}
	bind . "<Key F7>" {pref_init 1}

	menu .menubar.help -tearoff 0
	set m .menubar.help
	.menubar add cascade -label "Help" -menu $m -underline 0
	$m add command -label "About" -accelerator "F11" -underline 0 -command {help}
	$m add command -label "Clarifications" -accelerator "F12" -underline 0 -command {help_clarify}
	bind . "<Key F11>" {help}
	bind . "<Key F12>" {help_clarify}

	. configure -menu .menubar -width 200 -height 150

	frame .audio
	label .audio.la -text {Audio Track List}
	frame .audio.f -border 3 -relief sunken
	listbox .audio.f.lb -height 16 -width 30 -selectmode browse  -yscrollcommand {.audio.f.sb set} -xscrollcommand {.audio.f.sb2 set}
	scrollbar .audio.f.sb -orient v -command {.audio.f.lb yview}
	scrollbar .audio.f.sb2 -orient h -command {.audio.f.lb xview}
	frame .audio.m
	button .audio.m.up -text {Move up} -command {
		set num [.audio.f.lb curselection]
		if {""==$num} return
		if {$num==0} return
		flip $num
		incr num -1
		.audio.f.lb selection set $num
		.audio.f.lb see $num
	}
	button .audio.m.dn -text {Move Down} -command {
		set num [.audio.f.lb curselection]
		if {""==$num} return
		incr num 1
		if {$num==[.audio.f.lb index end]} return
		flip $num
		.audio.f.lb selection set $num
		.audio.f.lb see $num
	}
	frame .audio.ar -relief flat
	button .audio.ar.add -text {Add} -command {
	audio_add
	}
	button .audio.ar.rem -text {Remove} -command {
	audio_remove
	}
	button .audio.remall -text {Remove All} -command audio_removeall

	button .audio.preview -text {Preview Track} -command preview_audio

	label .lds -text "Data Track Source"

	frame .ds -border 3 -relief sunken
	radiobutton .ds.none -text {Make audio-only disk} -variable {cfg(ds)} -value none
	radiobutton .ds.mk -text {Make data track on the fly} -variable {cfg(ds)} -value mkisofs
	radiobutton .ds.pre -text {Use pre-made data track} -variable {cfg(ds)} -value premade
	entry .ds.tname -width 20 -font 7x14
	.ds.tname insert 0 "image.iso"

	## Andrew found the missing code, so now TK8 users (of which I have become)
	## can reap the benefits of a standard dialog.

	# Lets make the selection button if you have tk8.0 +
	if {[info tclversion] >= 8.0} {
		button .ds.select -text {Select} -command {my_image}
	} else {
		button .ds.select -text {Select} -command {
		perusefile
			.ds.tname delete 0 end
			.ds.tname insert 0 $perusedfile
		}
	}
	
	
	label .lm -text {Data Track Creation Options}
	frame .m -border 3 -relief sunken
	
	frame .m.scan
	checkbutton .m.scan.all -text {Keep all files (backups etc.)} -variable {cfg(all)}
	checkbutton .m.scan.links -text {Follow SymLinks} -variable {cfg(follow)}

	frame .m.file
	checkbutton .m.file.joliet -text {Joliet support} -variable {cfg(joliet)}
	checkbutton .m.file.trans -text {Translation Tables (old)} -variable {cfg(trans)}

	frame .m.rock -border 0 -relief flat
	label .m.rock.l -text {Rock Ridge:}
	radiobutton .m.rock.none -text {None} -variable {cfg(rock)} -value none
	radiobutton .m.rock.rational -text {Rationalized} -variable {cfg(rock)} -value rat
	radiobutton .m.rock.literal -text {Literal} -variable {cfg(rock)} -value lit

	frame .m.volid -border 0
	label .m.volid.l -text {Volume ID (name)}
	entry .m.volid.e -width 32 -font 7x14
	frame .m.root -border 0 -relief flat
	label .m.root.l -text {Root of Tree}
	entry .m.root.e -width 24 -font 7x14
	button .m.root.p -text "Peruse" -command {
		peruse
		.m.root.e delete 0 end
		.m.root.e insert 0 $perused
	}

	frame .m.custom -border 0
	checkbutton .m.custom.use -text "Use Custom Layout" -variable custom(use)
	button .m.custom.b -text {Set Custom Layout} -command custom_layout

	frame .m.boot
	checkbutton .m.boot.check -text "El Torito Bootable CD" -variable boot
	button .m.boot.opts -text "Boot Setup" -command boot_setup

	label .lc -text {cdrecord options}
	frame .c -border 3 -relief sunken
	frame .c.flag
	checkbutton .c.flag.dummy -text {Dummy Burn} -variable {cfg(dummy)}
	checkbutton .c.flag.eject -text {Eject when done} -variable {cfg(eject)}
	button .c.flag.pad -text "Padding..." -command padbox
	frame .c.opts
	checkbutton .c.opts.dao -text {DAO} -variable {cfg(dao)}
	checkbutton .c.opts.bf -text {Buffer Protection} -variable {cfg(burnfree)}
	checkbutton .c.opts.fix -text {Fixate CD} -variable {cfg(fix)}
	checkbutton .c.opts.ob -text {Allow Overburn} -variable {cfg(ob)}
	frame .c.dev -border 0 -relief flat
	label .c.dev.l -text {Device}
	entry .c.dev.e -width 20 -font 7x14 -textvariable cfg(device)
	button .c.flag.modes -text "Modes..." -command modebox
	frame .c.speed
	label .c.speed.l -text "Speed:"
	radiobutton .c.speed.1 -text "1x" -variable cfg(speed) -value 1
	radiobutton .c.speed.2 -text "2x" -variable cfg(speed) -value 2
	radiobutton .c.speed.4 -text "4x" -variable cfg(speed) -value 4
	radiobutton .c.speed.8 -text "8x" -variable cfg(speed) -value 8
	radiobutton .c.speed.12 -text "12x" -variable cfg(speed) -value 12
	radiobutton .c.speed.16 -text "16x" -variable cfg(speed) -value 16
	# added a new frame to avoid skewering the window dimensions
	frame .c.speed2
	# A blank label sucks, but it looks prettier.
	label .c.speed2.l -text "      "
	radiobutton .c.speed2.20 -text "20x" -variable cfg(speed) -value 20
	radiobutton .c.speed2.24 -text "24x" -variable cfg(speed) -value 24
	radiobutton .c.speed2.32 -text "32x" -variable cfg(speed) -value 32
	radiobutton .c.speed2.40 -text "40x" -variable cfg(speed) -value 40
	radiobutton .c.speed2.48 -text "48x" -variable cfg(speed) -value 48
	radiobutton .c.speed2.50 -text "50x" -variable cfg(speed) -value 50
	radiobutton .c.speed2.52 -text "52x" -variable cfg(speed) -value 52


	pack .audio -side right -anchor n -fill x -expand true
	pack .audio.la -side top
	pack .audio.f -side top -expand true -fill x
	pack .audio.f.sb2 -side bottom -fill x
	pack .audio.f.lb -side left -fill x -expand true
	pack .audio.f.sb -side left -fill y
	pack .audio.m -side top
	pack .audio.m.up -side left
	pack .audio.m.dn -side left
	pack .audio.ar -side top
	pack .audio.ar.add -side left
	pack .audio.ar.rem -side left
	pack .audio.remall -side top
	pack .audio.preview -side bottom
	pack .lds -side top
	pack .ds -side top -padx 5
	pack .ds.none -side bottom -anchor w
	pack .ds.mk -side bottom -anchor w
	pack .ds.pre -side left -anchor w
	pack .ds.tname -side left -anchor w
	pack .ds.select -side right -anchor n
	pack .lm -side top
	pack .m -side top
	pack .m.scan -side top -fill x
	pack .m.scan.all -side left
	pack .m.scan.links -side right
	pack .m.file -side top -fill x
	pack .m.file.joliet -side left
	pack .m.file.trans -side left
	pack .m.rock -side top -anchor w
	pack .m.rock.l -side left
	pack .m.rock.none -side left
	pack .m.rock.rational -side left
	pack .m.rock.literal -side left
	pack .m.volid -side top -anchor w
	pack .m.volid.l -side left
	pack .m.volid.e -side left
	pack .m.root -side top -anchor w -fill x
	pack .m.root.l -side left
	pack .m.root.e .m.root.p -side left
	pack .m.custom -side top -fill x
	pack .m.custom.use -side left
	pack .m.custom.b -side right
	pack .m.boot -side top -anchor w -fill x
	pack .m.boot.check -side left
	pack .m.boot.opts -side left -expand 1
	pack .lc -side top
	pack .c -side top
	pack .c.flag -side top
	pack .c.flag.dummy -side left
	pack .c.flag.eject -side left
	pack .c.flag.pad -side left
	pack .c.opts -side top
	pack .c.opts.dao -side left
	pack .c.opts.bf -side left
	pack .c.opts.fix -side left
	pack .c.opts.ob -side right
	pack .c.dev -side top
	pack .c.dev.l -side left
	pack .c.dev.e -side left
	pack .c.flag.modes -side right
	pack .c.speed -side top
	pack .c.speed.l .c.speed.1 .c.speed.2 .c.speed.4 .c.speed.8 .c.speed.12 .c.speed.16 -side left
	pack .c.speed2 -side bottom
	pack .c.speed2.l .c.speed2.20 .c.speed2.24 .c.speed2.32 .c.speed2.40 .c.speed2.48 .c.speed2.50 .c.speed2.52 -side left
	
	frame .spacer -height 10
	pack .spacer -side top
}

proc padbox {} {

global cfg
catch {destroy .pad}
toplevel .pad
wm title .pad {Padding Options}

frame .pad.audio
checkbutton .pad.audio.cb -text {Pad Audio Tracks} -variable {cfg(apad)}
message .pad.audio.amesg -text {This option will pad audio track data to be a multiple of 2352 bytes. The padding is done with all zeroes which means complete silence. See also PCM vs. WAV in help.}
frame .pad.data
checkbutton .pad.data.cb -text {Pad Data Track} -variable {cfg(dpad)}
message .pad.data.dmesg -text {This option appends 15 sectors of zeroes to each data track. This works around a bug in very old Linux kernels.}
button .pad.ok -text Dismiss -command {destroy .pad}

pack .pad.audio -fill x
pack .pad.audio.cb -side left -anchor n
pack .pad.audio.amesg
pack .pad.data -fill x
pack .pad.data.cb -side left -anchor n
pack .pad.data.dmesg
pack .pad.ok
}


proc modebox {} {

	global cfg
	catch {destroy .mode}
	toplevel .mode
	wm title .mode {Mode Options}

	frame .mode.f -height 10 -width 40
	label .mode.f.amesg -text {Make sure you know what you are doing before you use any of these options.}
	label .mode.f.amesg2 -text {The defaults will be correct except for special circumstances.}
	frame .mode.f2
	radiobutton .mode.f2.mode1 -text "CD-ROM Mode 1" -variable {cfg(cd_mode)} -value "-data"
	radiobutton .mode.f2.mode2 -text "CD-ROM Mode 2" -variable {cfg(cd_mode)} -value "-mode2"
	radiobutton .mode.f2.xa1 -text "CD-ROM XA Mode 1" -variable {cfg(cd_mode)} -value "-xa1"
	radiobutton .mode.f2.xa2 -text "CD-ROM XA Mode 2" -variable {cfg(cd_mode)} -value "-xa2"
	frame .mode.f3
	checkbutton .mode.f3.cdi -text "CDI Audio" -variable {cfg(cdi)}
	checkbutton .mode.f3.multi -text "Multisession" -variable {cfg(multi)}
	frame .mode.driver
	label .mode.driver.amesg3 -text {CDRDAO (cue/bin) special driver options}
	radiobutton .mode.driver.none -text "none" -variable {cfg(mmc)} -value ""
	radiobutton .mode.driver.cdd2600 -text "cdd2600" -variable {cfg(mmc)} -value "cdd2600"
	radiobutton .mode.driver.plextor -text "plextor" -variable {cfg(mmc)} -value "plextor"
	radiobutton .mode.driver.plextor-scan -text "plextor-scan" -variable {cfg(mmc)} -value "plextor-scan"
	radiobutton .mode.driver.generic-mmc -text "generic-mmc" -variable {cfg(mmc)} -value "generic-mmc"
	radiobutton .mode.driver.generic-mmc-raw -text "generic-mmc-raw" -variable {cfg(mmc)} -value "generic-mmc-raw"
	radiobutton .mode.driver.ricoh-mp6200 -text "ricoh-mp6200" -variable {cfg(mmc)} -value "ricoh-mp6200"
	frame .mode.driver2
	radiobutton .mode.driver2.yamaha-cdr10x -text "yamaha-cdr10x" -variable {cfg(mmc)} -value "yamaha-cdr10x"
	radiobutton .mode.driver2.teac-cdr55 -text "teac-cdr55" -variable {cfg(mmc)} -value "teac-cdr55"
	radiobutton .mode.driver2.sony-cdu920 -text "sony-cdu920" -variable {cfg(mmc)} -value "sony-cdu920"
	radiobutton .mode.driver2.sony-cdu948 -text "sony-cdu948" -variable {cfg(mmc)} -value "sony-cdu948"
	radiobutton .mode.driver2.taiyo-yuden -text "taiyo-yuden" -variable {cfg(mmc)} -value "taiyo-yuden"
	radiobutton .mode.driver2.toshiba -text "toshiba" -variable {cfg(mmc)} -value "toshiba"

	button .mode.ok -text Dismiss -command {destroy .mode}

	pack .mode.f -fill x
	pack .mode.f.amesg -fill x
	pack .mode.f.amesg2 -fill x
	pack .mode.f2
	pack .mode.f2.mode1 -side left -anchor n
	pack .mode.f2.mode2 -side left -anchor n
	pack .mode.f2.xa1 -side left -anchor n
	pack .mode.f2.xa2 -side left -anchor n
	pack .mode.f3
	pack .mode.f3.cdi -side left -anchor n
	pack .mode.f3.multi -side bottom -anchor n
	pack .mode.driver
	pack .mode.driver.amesg3 -fill x
	pack .mode.driver.none -side left -anchor n
	pack .mode.driver.cdd2600 -side left -anchor n
	pack .mode.driver.plextor -side left -anchor n
	pack .mode.driver.plextor-scan -side left -anchor n
	pack .mode.driver.generic-mmc -side left -anchor n
	pack .mode.driver.generic-mmc-raw -side left -anchor n
	pack .mode.driver.ricoh-mp6200 -side left -anchor n
	pack .mode.driver2
	pack .mode.driver2.yamaha-cdr10x -side left -anchor n
	pack .mode.driver2.teac-cdr55 -side left -anchor n
	pack .mode.driver2.sony-cdu920 -side left -anchor n
	pack .mode.driver2.sony-cdu948 -side left -anchor n
	pack .mode.driver2.taiyo-yuden -side left -anchor n
	pack .mode.driver2.toshiba -side left -anchor n
	pack .mode.ok

}



proc peruse {} {
	# Just browse directories
	
	global perused
	
	set perused ""
	
	catch {destroy .peruse}
	toplevel .peruse
	wm title .peruse {Peruse Folders}
	
	frame .peruse.dir -border 0 -relief flat 
	frame .peruse.mod -border 0 -relief flat 
	frame .peruse.control -border 0 -relief flat
	menubutton .peruse.dir.up -menu .peruse.dir.up.m -relief raised -border 2
	button .peruse.dir.ok -text {<-- Accept}
	listbox .peruse.mod.lb -height 10 -width 20 -selectmode browse -yscrollcommand {.peruse.mod.sb set}
	scrollbar .peruse.mod.sb -orient v -command {.peruse.mod.lb yview}
	button .peruse.control.go -text {Delve}
	button .peruse.control.cancel -text {Cancel}
	
	pack .peruse.dir -side top -fill x
	pack .peruse.mod -side top -fill x
	pack .peruse.control -side top -fill x
	pack .peruse.dir.up -side left
	pack .peruse.dir.ok -side right
	pack .peruse.mod.lb -side left -fill y -anchor w
	pack .peruse.mod.sb -side left -fill y -anchor w
	pack .peruse.control.go -side left -expand 1
	pack .peruse.control.cancel -side left -expand 1
	
	peruse_populate [pwd]
	tkwait window .peruse
}

proc perusefile {} {
	# Just browse files
	
	global perusedfile
	
	set perusedfile ""
	
	catch {destroy .perusefile}
	toplevel .perusefile
	wm title .perusefile {Peruse Files}
	
	frame .perusefile.dir -border 0 -relief flat 
	frame .perusefile.mod -border 0 -relief flat 
	frame .perusefile.control -border 0 -relief flat
	menubutton .perusefile.dir.up -menu .perusefile.dir.up.m -relief raised -border 2
	button .perusefile.dir.ok -text {<-- Accept}
	listbox .perusefile.mod.lb -height 10 -width 20 -selectmode browse -yscrollcommand {.perusefile.mod.sb set}
	scrollbar .perusefile.mod.sb -orient v -command {.perusefile.mod.lb yview}
	button .perusefile.control.go -text {Delve}
	button .perusefile.control.cancel -text {Cancel}

	pack .perusefile.dir -side top -fill x
	pack .perusefile.mod -side top -fill x
	pack .perusefile.control -side top -fill x
	pack .perusefile.dir.up -side left
	pack .perusefile.dir.ok -side right
	pack .perusefile.mod.lb -side left -fill y -anchor w
	pack .perusefile.mod.sb -side left -fill y -anchor w
	pack .perusefile.control.go -side left -expand 1
	pack .perusefile.control.cancel -side left -expand 1
	
	perusefile_populate [pwd]
	tkwait window .perusefile
}

proc peruse_populate dir {
	
	set tmp [file tail $dir]
	if {$tmp == ""} {set tmp /}
	.peruse.dir.up configure -text $tmp
	
	set m .peruse.dir.up.m
	catch {
		destroy $m
	}
	menu $m -tearoff 0
	
	set up /
	foreach dcomp [file split $dir] {
		set up [file join $up $dcomp]
		$m add command -label $dcomp -command "peruse_populate \"$up\""
	}
	
	.peruse.mod.lb delete 0 end
	set tmp [lsort [glob $dir/.* $dir/*]]
	foreach dcan $tmp {
		if [file isdirectory $dcan] {
			set tail [file tail $dcan]
			if {$tail != "." && $tail != ".."} {
				.peruse.mod.lb insert end $tail
			}
		}
	}

	## Bindings
	
	.peruse.control.cancel config -command {
		set perused ""
		destroy .peruse
	}
	.peruse.dir.ok config -command [subst {
		set perused "$dir"
		destroy .peruse
	}]
	
	set go [subst -nocommands {
		if {[.peruse.mod.lb get active] != ""} {
			peruse_populate [file join "$dir" [.peruse.mod.lb get active]]
		} else bell
	}]

	bind .peruse.mod.lb <Double-1> $go
	.peruse.control.go config -command $go
	
}

proc perusefile_populate dir {
	
	set tmp [file tail $dir]
	if {$tmp == ""} {set tmp /}
	.perusefile.dir.up configure -text $tmp
	
	set m .perusefile.dir.up.m
	catch {
		destroy $m
	}
	menu $m -tearoff 0
	
	set up /
	foreach dcomp [file split $dir] {
		set up [file join $up $dcomp]
		$m add command -label $dcomp -command "perusefile_populate \"$up\""
	}
	
	.perusefile.mod.lb delete 0 end
	if {[catch {lsort [glob $dir/.* $dir/*]} catchvar]} {
			set tmp ""
	} else {
			set tmp $catchvar
	}

	foreach dcan $tmp {
		set tail [file tail $dcan]
		if {$tail != "." && $tail != ".."} {
			.perusefile.mod.lb insert end $tail
		}
	}
	
	## Bindings
	
	.perusefile.control.cancel config -command {
		set perusedfile ""
		destroy .perusefile
	}
	.perusefile.dir.ok config -command [subst {
		set perusedfile "$dir"
		destroy .perusefile
	}]
	
	set go [subst -nocommands {
		if {[.perusefile.mod.lb get active] != ""} {
		 perusefile_populate [file join "$dir" [.perusefile.mod.lb get active]]
		} else bell
	}]
	
	bind .perusefile.mod.lb <Double-1> $go
	.perusefile.control.go config -command $go
}


proc boot_setup {} {
	global cfg
	
	catch {destroy .boot}
	toplevel .boot
	wm title .boot {Bootable CD Setup}


	frame .boot.img -border 0 -relief flat
	frame .boot.cat -border 0 -relief flat
	frame .boot.cmd -border 0 -relief flat
	label .boot.img.l -text {Boot Image Path}
	label .boot.cat.l -text {Boot Catalog Path}
	entry .boot.img.e -width 20 -font 7x14
	entry .boot.cat.e -width 20 -font 7x14

	# Got TK8? You get a pretty button.
	if {[info tclversion] >= 8.0} {
		button .boot.img.b -text {Select} -command open_bootfile
		button .boot.cat.c -text {Select} -command open_catfile
	}

	button .boot.cmd.ok -text {OK} -command {
		set $cfg(bootimg) [.boot.img.e get]
		set $cfg(bootcat) [.boot.cat.e get]
		destroy .boot
	}
	button .boot.cmd.cancel -text {Cancel} -command {
		destroy .boot
	}
	button .boot.cmd.revert -text {Revert} -command {
		.boot.img.e delete 0 end
		.boot.cat.e delete 0 end
		.boot.img.e insert 0 $cfg(bootimg)
		.boot.cat.e insert 0 $cfg(bootcat)
	}

	# Populate Data Fields
	.boot.img.e insert 0 $cfg(bootimg)
	.boot.cat.e insert 0 $cfg(bootcat)

	pack .boot.img -side top -fill x
	pack .boot.cat -side top -fill x
	pack .boot.cmd -side top -fill x
	pack .boot.img.l -side left
	pack .boot.cat.l -side left
	pack .boot.img.e -side right
	pack .boot.cat.e -side right
	pack .boot.cmd.ok -side left -expand 1
	pack .boot.cmd.cancel -side left -expand 1
	pack .boot.cmd.revert -side left -expand 1

	# Got TK8? You get a pretty button.
	if {[info tclversion] >= 8.0} {
		pack .boot.img.b -side right
		pack .boot.cat.c -side right
	}

}


proc get_mp3_burn_info {} {
	# Returns either the empty list, indicating a cancelation,
	# or the temp directory.

	global perused

	set warn {\
You have chosen to burn an MPEG compressed file as an audio track. This will not be the same quality as the original from which it was made. However, the burn can proceed if given a space to uncompress the audio files.

Do you wish to proceed?}

	set go [sure $warn]
	if {!$go} {
		return {}
	}

	set df [exec -keepnewline df]

	catch {destroy .df}
	toplevel .df
	wm title .df {Free Disk Space}

	text .df.t -width 80 -height 10 -setgrid 1 -yscrollcommand {.df.sb set}
	scrollbar .df.sb -orient v -command {.df.t yview}

	.df.t insert end "Please browse to a directory with sufficient free space.\n\n"
	.df.t insert end $df
	.df.t config -state disabled

	pack .df.sb -side right -fill y
	pack .df.t -side left

	peruse
	destroy .df

	alert "Be aware that the MP3 conversion process typically takes some time."

	return $perused
}


proc custom_layout {} {

	global custom

	catch {destroy .custom}
	toplevel .custom
	wm title .custom {Custom CD Layout}


	frame .custom.dirs -border 0 -relief flat 
	frame .custom.table -border 0 -relief flat 
	frame .custom.cmds -border 0 -relief flat 
	frame .custom.help -border 0 -relief flat 
	label .custom.dirs.a -text {Make contents of:} 
	label .custom.dirs.b -text {Show up on CD within:} 
	
	foreach x {0 1 2 3 4 5 6 7 8 9} {
		frame .custom.table.$x -border 0 -relief flat 
		button .custom.table.$x.peruse -text {Peruse} -command "custom_peruse $x"
		entry .custom.table.$x.from -width 25 -font 7x14 
		entry .custom.table.$x.to -width 25 -font 7x14 
		
		button .custom.table.$x.clear -text {Clear} -command [subst {
		.custom.table.$x.from delete 0 end
		.custom.table.$x.to delete 0 end
		}]
		
		pack .custom.table.$x -side top -fill x
		pack .custom.table.$x.peruse -side left -anchor w
		pack .custom.table.$x.from -side left -anchor w
		pack .custom.table.$x.clear -side right -anchor e
		pack .custom.table.$x.to -side right -anchor e
		
	}
	
	scrollbar .custom.help.sb -orient v -command {} -command {.custom.help.t yview}
	text .custom.help.t -width 70 -height 10 -setgrid 1 -yscrollcommand {.custom.help.sb set}
	button .custom.cmds.ok -text {OK} -command {
		set from {}
		set to {}
		foreach s [pack slaves .custom.table] {
		 lappend from [$s.from get]
		 lappend to [$s.to get]
		}
		set custom(from) $from
		set custom(to) $to
		set custom(use) 1
		destroy .custom
	}
	button .custom.cmds.revert -text {Revert} -command {
		foreach s [pack slaves .custom.table] from $custom(from) to $custom(to) {
		 $s.from delete 0 end
		 $s.to delete 0 end
		 $s.from insert 0 $from
		 $s.to insert 0 $to
		}
	}
	button .custom.cmds.cancel -text {Cancel} -command {
	destroy .custom
	}
	
	pack .custom.dirs -side top -fill x
	pack .custom.table -side top -fill x
	pack .custom.cmds -side top -fill x
	pack .custom.help -side top -fill both -expand 1
	pack .custom.dirs.a -side left -anchor w
	pack .custom.dirs.b -side right -anchor e
	pack .custom.help.sb -side right -fill y -anchor e
	pack .custom.help.t -side right -fill both -anchor w
	pack .custom.cmds.ok -side left -expand 1
	pack .custom.cmds.revert -side left -expand 1
	pack .custom.cmds.cancel -side left -expand 1
	
	.custom.cmds.revert invoke
	
	.custom.help.t insert 1.0 {              Custom CD Layout Help

This was always the biggest pain for me. I want stuff from the hard
drive from arbitrary places to show up on the final CD in (other)
arbitrary places.

I've tried to make this fairly general. Name what you want on the
left, and where to put it on the right. The one thing to remember
is that if you put a directory on the left, you have to give it
a name on the right unless you want a whole bunch of files sprayed
all over the root of the CD.

The names you give on the right do not have to exist anywhere
except your imagination. If they don't exist within other parts of
what you burn, the directories will be automatically created to
exist on the CD. Directories created in this way will be owned by
root.root and have permissions 555 (read/exec for all).

I'm not yet sure how these custom layouts interact with bootable
CD creation. I think that you specify the boot paths relative to
the final CD image. I know it works that way in the simple case.

}
	
	.custom.help.t tag add cool 1.0 2.0
	.custom.help.t tag config cool -font 10x20
	.custom.help.t tag config cool -background blue
	.custom.help.t tag config cool -foreground white
	
	.custom.help.t config -state disabled
}


proc custom_peruse x {
	global perused
	peruse
	if {$perused != ""} {
		.custom.table.$x.from delete 0 end
		.custom.table.$x.from insert 0 $perused
	}
}

proc my_image {} {
	## TK8.0+ Dialog for file selection
	
	set types {
		{{ISO9660 Images}   {.iso}        }
		{{XCD-Roast Images} {.raw}        }
		{{CUE Files} {.cue}               }
		{{All Files}        *             }
	}
	set image [tk_getOpenFile -filetypes $types -defaultextension *.raw -initialdir /iso -title {Choose Image}]
	.ds.tname delete 0 250
	.ds.tname insert 0 $image
	
}

proc peruse_block args {
	# This procedure should use the "peruse" strategy to let
	# the user select a block-special file.
	# Also, I'm going to re-write the layout so it looks better.
	#
	
	global perusedfile
	set perusedfile ""
	
	set w ".perusefile"

	catch {destroy $w} 
	toplevel $w
	wm title $w {Peruse Block Devices}
	
	frame $w.up
	frame $w.dir
	frame $w.file
	frame $w.ctl
	
	menubutton $w.up.mb -menu $w.up.mb.m -relief raised -border 2
	
	listbox $w.dir.lb  -yscrollcommand [list $w.dir.sb set]
	listbox $w.file.lb -yscrollcommand [list $w.file.sb set]
	
	scrollbar $w.dir.sb  -orient v -command [list $w.dir.lb yview]
	scrollbar $w.file.sb -orient v -command [list $w.file.lb yview]
	
	button $w.ctl.accept -text accept -command {}
	button $w.ctl.cancel -text cancel -command {}
	
	pack $w.up -side top -fill x
	pack $w.dir $w.file $w.ctl -side left -fill y
	pack $w.dir.sb $w.file.sb -side right -fill y
	pack $w.dir.lb $w.file.lb $w.up.mb -side left
	pack $w.ctl.accept $w.ctl.cancel -side top
	
	
	peruse_block_populate "/dev"         
	tkwait window $w

	return $perusedfile
}


proc peruse_block_populate dir {
	# Here we fill in the info for the peruse window and
	# configure up the bindings.
	
	set w ".perusefile"
	
	# Configure the menu button
	set tmp [file tail $dir]
	if {$tmp == ""} {set tmp /}
	$w.up.mb configure -text $tmp
	
	# Replace the menu
	set m $w.up.mb.m
	catch {destroy $m}
	menu $m -tearoff 0
	
	set up /
	foreach dcomp [file split $dir] {
		set up [file join $up $dcomp]
		$m add command -label $dcomp -command "peruse_block_populate \"$up\""
	}
	
	
	### Populate the list boxes:
	
	# empty them
	$w.dir.lb delete 0 end
	$w.file.lb delete 0 end
	
	# enumerate the interesting files
	set file_list [lsort [glob -nocomplain -- $dir/.* $dir/*]]
	
	# place them in the correct box
	foreach file $file_list {
		set tail [file tail $file]
		if {$tail != "." && $tail != ".."} {
			file stat $file stat
			set type $stat(type)
			
			if {$type == "directory"} {
				$w.dir.lb insert end [file tail $file]
			} elseif {$type == "blockSpecial"} {
				$w.file.lb insert end [file tail $file]
			}
		}
	}
	
	## Bindings
	
	$w.ctl.cancel config -command {
		set perusedfile ""
		destroy .perusefile
	}
	$w.ctl.accept config -command [list peruse_block_accept $dir]
	
	set go [subst -nocommands {
		if {[$w.dir.lb get active] != ""} {
			peruse_block_populate [file join "$dir" [$w.dir.lb get active]]
		} else bell
	}]
	
	bind $w.dir.lb <Double-1> $go
	# .perusefile.control.go config -command $go
	
	
	}
	proc peruse_block_accept dir {
	
	# If appropriate, pluck the currently selected file name from the file
	# list and set it into the return global.
	
	global perusedfile
	
	set w ".perusefile"
	
	set chosen [$w.file.lb get active]
	
	if {$chosen != ""} {
		set perusedfile [file join $dir $chosen]
		destroy $w
	}
	
}
