(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

open Encodings

val split_qname: Utf8.t -> string * Utf8.t

exception UnknownPrefix of Utf8.t

include Custom.T with type t = int  (* Namespaces (URIs) *)
val mk: Utf8.t -> t
val mk_ascii: string -> t
val value: t -> Utf8.t
val empty : t
val value: t -> Utf8.t

val xml_ns: t

type qname = t * Utf8.t
module QName : sig
  include Custom.T with type t = qname
  val to_string: t -> string
  val print: Format.formatter -> t -> unit
end


type table  (* prefix => namespace *)
val serialize_table: table Serialize.Put.f
val deserialize_table: table Serialize.Get.f
val empty_table: table  (* Contains only xml *)
val def_table: table (* Contains xml,xsd,xsi *)
val add_prefix: Utf8.t -> t -> table -> table
val dump_table: Format.formatter -> table -> unit

val get_table: table -> (Utf8.t * Utf8.t) list
val mk_table: (Utf8.t * Utf8.t) list -> table

val process_start_tag:
  table -> string -> (string * string) list -> 
    table * qname * (qname * Utf8.t) list

(*
val print_qname: Format.formatter -> qname -> unit 
*)

val map_tag: table -> Utf8.t -> qname
val map_attr: table -> Utf8.t -> qname
val map_prefix: table -> Utf8.t -> t

(* Support for printing XML documents *)

module Printer : sig
  type printer

  val printer: table -> printer
  val register_tag: printer -> qname -> unit
  val register_attr: printer -> qname -> unit

  val prefixes: printer -> (Utf8.t * t) list
  val tag: printer -> qname -> string
  val attr: printer -> qname -> string
end
    

(***)

module InternalPrinter : sig
  val set_table: table -> unit

  val any_ns: t -> string
  val tag: qname -> string
  val attr: qname -> string

  val dump: Format.formatter -> unit
end

(*
val register_prefix : Utf8.t -> t -> unit
val prefix : t -> Utf8.t

val dump_prefix_table : Format.formatter -> unit
*)
