//
// PropertyDefinitionCollection.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Fri Apr 21 16:46:45 CEST 2006
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil {

	using System;
	using System.Collections;

	using Mono.Cecil.Cil;

	public sealed class PropertyDefinitionCollection : IPropertyDefinitionCollection {

		IList m_items;
		TypeDefinition m_container;

		public event PropertyDefinitionEventHandler OnPropertyDefinitionAdded;
		public event PropertyDefinitionEventHandler OnPropertyDefinitionRemoved;

		public PropertyDefinition this [int index] {
			get { return m_items [index] as PropertyDefinition; }
			set { m_items [index] = value; }
		}

		object IIndexedCollection.this [int index] {
			get { return m_items [index]; }
		}

		public TypeDefinition Container {
			get { return m_container; }
		}

		public int Count {
			get { return m_items.Count; }
		}

		public bool IsSynchronized {
			get { return false; }
		}

		public object SyncRoot {
			get { return this; }
		}

		public PropertyDefinitionCollection (TypeDefinition container)
		{
			m_container = container;
			m_items = new ArrayList ();
		}

		public void Add (PropertyDefinition value)
		{
			if (OnPropertyDefinitionAdded != null && !this.Contains (value))
				OnPropertyDefinitionAdded (this, new PropertyDefinitionEventArgs (value));
			m_items.Add (value);
		}

		public void Clear ()
		{
			if (OnPropertyDefinitionRemoved != null)
				foreach (PropertyDefinition item in this)
					OnPropertyDefinitionRemoved (this, new PropertyDefinitionEventArgs (item));
			m_items.Clear ();
		}

		public bool Contains (PropertyDefinition value)
		{
			return m_items.Contains (value);
		}

		public int IndexOf (PropertyDefinition value)
		{
			return m_items.IndexOf (value);
		}

		public void Insert (int index, PropertyDefinition value)
		{
			if (OnPropertyDefinitionAdded != null && !this.Contains (value))
				OnPropertyDefinitionAdded (this, new PropertyDefinitionEventArgs (value));
			m_items.Insert (index, value);
		}

		public void Remove (PropertyDefinition value)
		{
			if (OnPropertyDefinitionRemoved != null && this.Contains (value))
				OnPropertyDefinitionRemoved (this, new PropertyDefinitionEventArgs (value));
			m_items.Remove (value);
		}

		public void RemoveAt (int index)
		{
			if (OnPropertyDefinitionRemoved != null)
				OnPropertyDefinitionRemoved (this, new PropertyDefinitionEventArgs (this [index]));
			m_items.RemoveAt (index);
		}

		public void CopyTo (Array ary, int index)
		{
			m_items.CopyTo (ary, index);
		}

		public IEnumerator GetEnumerator ()
		{
			return m_items.GetEnumerator ();
		}

		public PropertyDefinition [] GetProperties (string name)
		{
			ArrayList ret = new ArrayList ();
			foreach (PropertyDefinition prop in this)
				if (prop.Name == name)
					ret.Add (prop);

			return ret.ToArray (typeof (PropertyDefinition)) as PropertyDefinition [];
		}

		public void Accept (IReflectionVisitor visitor)
		{
			visitor.VisitPropertyDefinitionCollection (this);
		}
	}
}
