/***************************************************************************
                          interface_callbacks_main.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  f This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "interface.h"


void Interface::on_button_main_file_clicked() {

			int action;
			file_menu_popup = new Window_File_Popup;
			file_menu_popup->poll_until_action(*kit);
			action=file_menu_popup->action;
			delete file_menu_popup;

			switch (action) {

				case Window_File_Popup::PRESSED_LOAD: {
 		
					run_song_load_menu();
				} break;

				case Window_File_Popup::PRESSED_SAVE_CURRENT: {

					if (song->variables.filename=="") break;
	                                file_manager->save_module((char*)song->variables.filename.c_str());
				} break;
				case Window_File_Popup::PRESSED_SAVE_AS: {

	                                run_song_save_menu();
				} break;
				case Window_File_Popup::PRESSED_NEW: {

                                        okcancel_dialog = new Dialog_OkCancel("Proceed to erase all the data...\n\nAre you sure? ",*kit);

					if (okcancel_dialog->get_action()==Dialog_OkCancel::OK) {
					
						realtime_keyboard.instrument_stop_all();
						realtime_keyboard.sample_stop_all();
					      	player->play_stop();

						variables_lock->grab();
						song->reset_data();
						variables_lock->release();

						update_all_widgets();
					}
                                        delete okcancel_dialog;

				} break;
				case Window_File_Popup::PRESSED_QUIT: {

					delete_event_impl(NULL);
				} break;
			}


}

void Interface::on_entry_main_song_name_changed(){

	if (main_entries_updating_in_progress) return;

	song->variables.name=entry_main_song_name.get_text();

}

void Interface::on_button_main_play_prev_pattern_clicked() {

	player->goto_previous_order();
}

void Interface::on_button_main_stop_clicked() {

	player->play_stop();
	
	if (current_page==PATTERN_EDITOR_PAGE)	tracker.grab_focus();
}

void Interface::on_button_main_play_clicked() {

	player->play_start_song();			
}

void Interface::on_button_main_play_next_pattern_clicked() {

	player->goto_next_order();
}

void Interface::on_button_main_play_pattern_clicked(){

	player->play_start_pattern(editor.get_current_pattern());
	
	if (current_page==PATTERN_EDITOR_PAGE)	tracker.grab_focus();

}

void Interface::on_button_main_play_custom_clicked()
{

	if (editor.is_mark_active()) {

		player->play_start(editor.get_marked_pattern(),-1,editor.get_marked_row());
	} else {
		int from_order=song->find_pattern_in_orderlist(editor.get_current_pattern());

		if (from_order!=-1) {

			player->play_start(-1,from_order,editor.get_cursor_y());

		} else {

			player->play_start(editor.get_current_pattern(),-1,editor.get_cursor_y());
		}
	}				

}

void Interface::on_button_main_help_clicked() {

	Window_Help help(current_page);
 	help.poll_until_action(*kit);
}

gint Interface::on_main_key_pressed(GdkEventKey* event) {

	bool alt,shift,control;
        int handled=0;
	alt=event->state & GDK_MOD1_MASK;
	shift=event->state & GDK_SHIFT_MASK;
	control=event->state & GDK_CONTROL_MASK;

        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	switch (event->keyval) {


		case GDK_F1: {
	   		on_button_main_help_clicked();
     		} break;
		case GDK_F2: {
                        if (current_page==PATTERN_EDITOR_PAGE) break;
			notebook_main.set_page(PATTERN_EDITOR_PAGE);
			handled=TRUE;
			gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");
		} break;
		case GDK_F3: {

			notebook_main.set_page(SAMPLE_LIST_PAGE);

		} break;
		case GDK_F4: {

			notebook_main.set_page(INSTRUMENT_LIST_PAGE);

		} break;
		case GDK_F11: {

			notebook_main.set_page(ORDERPAN_PAGE);

		} break;
		case GDK_F12: {

			notebook_main.set_page(VARIABLES_PAGE);

		} break;

		case GDK_F5: {

			if (!player->is_playing()) {

				player->play_start_song();
			}

			notebook_main.set_page(INFO_PAGE);			

       			} break;
		case GDK_F6: {
                        if (shift) {
                                player->play_start_song_from_order(editor.orderlist_get_cursor_y());

			} else {

				player->play_start_pattern(editor.get_current_pattern());
			}
		} break;
		case GDK_F7: {

			if (control) break;
		
			if (editor.is_mark_active()) {

				player->play_start(editor.get_marked_pattern(),-1,editor.get_marked_row());
			} else {
                                int from_order=song->find_pattern_in_orderlist(editor.get_current_pattern());

				if (from_order!=-1) {

					player->play_start(-1,from_order,editor.get_cursor_y());

				} else {

					player->play_start(editor.get_current_pattern(),-1,editor.get_cursor_y());
				}
			}				


		} break;

		case GDK_F8: {

                        realtime_keyboard.instrument_stop_all();
                        realtime_keyboard.sample_stop_all();

			player->play_stop();				

		} break;

		case GDK_KP_Divide: {
		
			editor.default_octave_lower();
			tracker.queue_draw();
			update_main_editing_entries();

		} break;
		case GDK_KP_Multiply: {
		
			editor.default_octave_raise();;
			tracker.queue_draw();
			update_main_editing_entries();

		} break;

		case GDK_Escape: {

			int action;
			file_menu_popup = new Window_File_Popup;
			file_menu_popup->poll_until_action(*kit);
			action=file_menu_popup->action;
			delete file_menu_popup;

			switch (action) {

				case Window_File_Popup::PRESSED_LOAD: {
 		
					run_song_load_menu();
				} break;

				case Window_File_Popup::PRESSED_SAVE_CURRENT: {

					if (song->variables.filename=="") break;
	                                file_manager->save_module((char*)song->variables.filename.c_str());
				} break;
				case Window_File_Popup::PRESSED_SAVE_AS: {

	                                run_song_save_menu();
				} break;
				case Window_File_Popup::PRESSED_NEW: {

                                        okcancel_dialog = new Dialog_OkCancel("Proceed to erase all the data...\n\nAre you sure? ",*kit);

					if (okcancel_dialog->get_action()==Dialog_OkCancel::OK) {
					
						realtime_keyboard.instrument_stop_all();
						realtime_keyboard.sample_stop_all();
					      	player->play_stop();

						variables_lock->grab();
						song->reset_data();
						variables_lock->release();

						update_all_widgets();
					}
                                        delete okcancel_dialog;

				} break;
				case Window_File_Popup::PRESSED_QUIT: {

					delete_event_impl(NULL);
				} break;
			}
			
		} break;
	}

	on_main_notebook_key_pressed(event);

	return handled;
}

gint Interface::on_main_notebook_key_pressed(GdkEventKey* event) {

	/* At times like this.. I cant help but bitch and yell.. I hate GTK. */
	/* I'll try to do this code as best as I can */
	
	enum {

		FILTER_ALL,
		FILTER_ALL_BUT_NUMBERS,
		FILTER_NOTHING
	};
	enum {

		IS_NUMBER,
		IS_LETTER,
		IS_OTHER
	};

	int filter_type = FILTER_NOTHING;
        bool do_filter=false;
	int key_type;

	if (((event->keyval>='a') && (event->keyval<='z')) || ((event->keyval>='A') && (event->keyval<='Z'))) {

		key_type=IS_LETTER;
	} else if ((event->keyval>='0') && (event->keyval<='9')) {

         	key_type=IS_NUMBER;
	} else {

         	key_type=IS_OTHER;
	}

	if (entry_main_song_name.has_focus()) filter_type=FILTER_ALL;

	switch (current_page) {

		case SAMPLE_LIST_PAGE: {
		/* ok... here we go */
			if (
				spinbutton_samples_glb_volume->has_focus() ||
				spinbutton_samples_def_volume->has_focus() ||
				spinbutton_samples_def_pan->has_focus() ||
				spinbutton_samples_vibrato_speed->has_focus() ||
				spinbutton_samples_vibrato_depth->has_focus() ||
				spinbutton_samples_vibrato_rate->has_focus() ||
				spinbutton_samples_loop_begin->has_focus() ||
				spinbutton_samples_loop_end->has_focus() ||
				spinbutton_samples_susloop_begin->has_focus() ||
				spinbutton_samples_susloop_end->has_focus()
				
			   ) filter_type=FILTER_ALL_BUT_NUMBERS;

			if (entry_samples_samplename.has_focus()) filter_type=FILTER_ALL;

			switch (filter_type) {

				case FILTER_NOTHING: {
					if ((key_type==IS_LETTER) || (key_type==IS_NUMBER)) {

						on_samples_piano_enabled_widgets_key_pressed(event);
			                        do_filter=true;
					}
				} break;
				case FILTER_ALL_BUT_NUMBERS: {
					if (key_type==IS_LETTER) {

						on_samples_piano_enabled_widgets_key_pressed(event);
			                        do_filter=true;
					}
				} break;
			}

			if (!clist_samples_list.has_focus() &&
			     !spinbutton_samples_loop_begin->has_focus() &&
			     !spinbutton_samples_loop_end->has_focus() &&	
			     !spinbutton_samples_susloop_begin->has_focus() &&
			     !spinbutton_samples_susloop_end->has_focus() ) {


				switch(event->keyval) {

					case GDK_Page_Up: {
						
						if (selected_sample>0) selected_sample--;
						clist_samples_list.row(selected_sample).select();
						update_selected_sample_info();
                                 		
					} break;
					case GDK_Page_Down: {

						if (selected_sample<MAX_SAMPLES-1) selected_sample++;
						clist_samples_list.row(selected_sample).select();
						update_selected_sample_info();
                                        } break;
				}					

			}
				

		/* yes this was ugly but.. */
		} break;

		case INSTRUMENT_LIST_PAGE: {
		/* ... it get WORSE! */
			if (

				spinbutton_instruments_volume_envelope_loop_begin->has_focus() ||
				spinbutton_instruments_volume_envelope_loop_end->has_focus() ||
				spinbutton_instruments_volume_envelope_susloop_begin->has_focus() ||
				spinbutton_instruments_volume_envelope_susloop_end->has_focus() ||
				spinbutton_instruments_volume_swing->has_focus() ||
				spinbutton_instruments_volume_fadeout->has_focus() ||
				spinbutton_instruments_pan_envelope_loop_begin->has_focus() ||
				spinbutton_instruments_pan_envelope_loop_end->has_focus() ||
				spinbutton_instruments_pan_envelope_susloop_begin->has_focus() ||
				spinbutton_instruments_pan_envelope_susloop_end->has_focus() ||
				spinbutton_instruments_pan_default_value->has_focus() ||
				spinbutton_instruments_pan_pitch_center->has_focus() ||
				spinbutton_instruments_frequency_envelope_loop_begin->has_focus() ||
				spinbutton_instruments_frequency_envelope_loop_end->has_focus() ||
				spinbutton_instruments_frequency_envelope_susloop_begin->has_focus() ||
				spinbutton_instruments_frequency_envelope_susloop_end->has_focus()

			) filter_type=FILTER_ALL_BUT_NUMBERS;
                        if (
				entry_instruments_name.has_focus() ||
                                entry_instrument_name.has_focus() ||
                                equivtable_instruments.im_focused
			) filter_type=FILTER_ALL;

			switch (filter_type) {

				case FILTER_NOTHING: {
					if ((key_type==IS_LETTER) || (key_type==IS_NUMBER)) {

                                                on_instruments_piano_enabled_widgets_key_pressed(event);
			                        do_filter=true;
					}
				} break;
				case FILTER_ALL_BUT_NUMBERS: {
					if (key_type==IS_LETTER) {

                                                on_instruments_piano_enabled_widgets_key_pressed(event);
			                        do_filter=true;
					}
				} break;
			}
		
			
			/* GAAHHH.. that was nasty!! */
		} break;
		case INFO_PAGE: {

			switch (event->keyval) {

                        	case GDK_Up:
				case GDK_Left: {

                                        if (editor.get_visual_channel()>0) editor.set_visual_channel(editor.get_visual_channel()-1);
					gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");
					view_data.queue_draw();
					view_pattern.queue_draw();
					return TRUE;
					
				}break;
                        	case GDK_Down:
				case GDK_Right: {

                                        if (editor.get_visual_channel()<PATTERN_WIDTH-1) editor.set_visual_channel(editor.get_visual_channel()+1);
					gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");
					view_data.queue_draw();
					view_pattern.queue_draw();
					return TRUE;
					
				}break;
				case 'Q':
				case GDK_F9: {

					editor.channel_mute_toggle(editor.get_visual_channel());
					update_volume_pan_list();
				} break;
				case 'S':
				case GDK_F10: {

					editor.channel_solo_toggle(editor.get_visual_channel());
					update_volume_pan_list();
				} break;
				case ' ': {

					editor.channel_mute_toggle(editor.get_visual_channel());
					update_volume_pan_list();
	                                if (editor.get_visual_channel()<(PATTERN_WIDTH-1)) editor.set_visual_channel(editor.get_visual_channel()+1);
					gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");
					view_data.queue_draw();
					view_pattern.queue_draw();
					return TRUE;
       				} break;

			}

		} break;
	}



        if (do_filter) {

         	if ((filter_type==FILTER_NOTHING) && ((key_type==IS_LETTER) || (key_type==IS_NUMBER))) {

                 	gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");
			return TRUE;
		}
         	if ((filter_type==FILTER_ALL_BUT_NUMBERS) && (key_type==IS_LETTER)) {

                 	gtk_signal_emit_stop_by_name(GTK_OBJECT(gtkobj()),"key_press_event");
			return TRUE;
		}
	}
	
	return 0;

}

gint Interface::on_main_notebook_key_released(GdkEventKey* event) {

	switch (current_page) {

		case SAMPLE_LIST_PAGE: {

			on_samples_piano_enabled_widgets_key_released(event);

		} break;
		case INSTRUMENT_LIST_PAGE: {

			on_instruments_piano_enabled_widgets_key_released(event);
		} break;
	}

	return 0;

}

void Interface::on_notebook_main_page_switch(Gtk::Notebook_Helpers::Page* p0,guint p1) {

	current_page=p1;
	notebook_main.grab_focus();

	switch (current_page) {

		case PATTERN_EDITOR_PAGE: {

			tracker.grab_focus();
		} break;

	}

}
