/***************************************************************************
                          file_reader.h  -  portable file reading class
                             -------------------
    begin                : Tue Jan 23 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILE_READER_H
#define FILE_READER_H

#include "stdio.h"
#include "typedefs.h"
/**
  *@author Juan Linietsky
  */

/******************************
 file_reader.h
 ----------

Some file read operations, abstracted
in a class for ease of use.
********************************/

class File_Reader {


	FILE *f;

	bool reader_in_use;
	bool error_ocurred;
	int error_type;

	bool perform_endian_swap;

	void check_for_errors();

	template<class T>
	void endian_swap(T a, T b) {

		T c;
		if  (perform_endian_swap) c=a; a=b; b=c;
	}

public:

	int open(char *p_filename);
	void close();
	void seek(Uint32 p_position);	
        int get_file_pos() { return ftell(f); };
	bool eof_reached();
	bool error_loading();

	Uint8 get_byte();
	void get_byte_array(Uint8 *p_dest,int p_elements);

	Uint16 get_word();
	Uint32 get_dword();

	// use this for files WRITTEN in _big_ endian machines (ie, amiga)
	// It's not about the current CPU type but file formats.
	void set_endian_conversion(bool p_swap) { perform_endian_swap=p_swap; }
        bool is_open() { return reader_in_use; };

	File_Reader();
	~File_Reader();
};

#endif
