/***************************************************************************
                          nsf_export.h  -  description
                             -------------------
    begin                : Sun Jan 20 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NSF_EXPORT_H
#define NSF_EXPORT_H

#include "sound_driver.h"
#include "mixer.h"
#include "player_data.h"
#include "file_writer.h"

/**
  *@author red
  */

class NSF_Export : public Sound_Driver,public Mixer  {


	struct Voice {
	
		int freq;
		int c5freq;
		Uint8 volume;
		Uint8 duty;
		Uint8 vibsweep;
		Uint8 vibdepth;
		
		Voice() {
		
			volume=0;
			duty=0;
		}
	
	} voice[4];


	File_Writer writer;
	int play_address;

	void write_header();
	
		
	void compare_and_branch_if_min(Uint16 address1,Uint16 address2,Sint8 branch);
	void compare_and_branch_if_eq(Uint16 address1,Uint16 address2,Sint8 branch);
	void load_song_ptr_in_a();	

	void update_voice_data(Uint8 p_voice, bool write_chunk=false);
	void update_voice_freq(Uint8 p_voice);
	void update_voice_vibrato(Uint8 p_voice);
	
	void write_byte(Uint8 p_byte);
	void write_address(Uint16 p_register_addr,Uint8 p_byte);

	int pos_counter;
	int current_bank;
	Player_Data *player;
	bool player_playing;
	bool player_stopped;
	bool dumping;
	
	string filename;
	
	float current_frame;
	float last_frame_written;
	
	void write_frame();

public:
	void request_player_data() {
	
		player->link_to_mixer(this);	
	}
	/********************/
	/* sound driver crap*/
	/********************/
   	
	int get_mix_frequency() {return 0; }; //pointless
	bool get_mix_stereo() {return false;} //pointless
	bool get_mix_16bits() {return false;} //pointless
	int get_mix_buffer_size() {return 0; }; //pointless

	string get_name() { return "NSF export"; };

	int init();
	bool finish();
	bool is_active() {return true; };
	bool update();

	/********************/
	/* mixer crap       */
	/********************/
	
	
	Uint32 write_bytes(Sint8* buf,Uint32 todo){ return 0;}; //pointless;
        virtual void link_player_data(Player_Data *p_player_data);

	/* External Control (player/program)*/
	void setup_voice(int p_voice_index,Sample_Data *p_sample_data,Sint32 p_start_index);
	void stop_voice(int p_voice_index);
	void set_voice_frequency(int p_voice_index,Uint32 p_freq);
	void set_voice_panning(int p_voice_index,int p_pan) {}; //useless!
	void set_voice_volume(int p_voice_index,int p_vol);
	void set_number_of_channels(int p_numb_channels) {}; //ignoring you
        void set_voice_vibrato(int p_voice_index,int p_speed,int p_depth);
	void set_voice_filter(int p_voice_index,Sint32 p_coef1, Sint32 p_coef2,Sint32 p_coef3,bool p_enabled) {};
        void set_voice_reverb_send(int p_voice_index,int p_reverb) {};

	/* External Control (sound driver)*/
	virtual void set_mix_frequency(int p_mix_frequency) {}; //not needed
        virtual void set_mix_stereo(bool p_mix_stereo) {}; // what for?
        virtual void set_mix_16bits(bool p_mix_16bits) {}; // why would i use this?
	
	/* Info retrieving */	
	virtual Sint32 get_voice_sample_pos_index(int p_voice_index) {return 0;}; // what sample?
	virtual int get_voice_panning_pos(int p_voice_index) {return 0;} // nintendo has no panning!
	virtual int get_voice_volume(int p_voice_index) {return 0;}// you dont need this!
	virtual Sample_Data *get_voice_sample_data_ptr(int p_voice_index){return NULL;}; // naah
	virtual bool is_voice_stopped(int p_voice_index){ return false; };// ded you are
        virtual int get_number_of_channels() { return 5; }; //that's my nes!	


	NSF_Export();
	~NSF_Export();
};

#endif
