/***************************************************************************
                          sound_driver_manager.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sound_driver_manager.h"

void Sound_Driver_Manager::register_driver(Sound_Driver* p_new_driver) {

	driver_list.push_back(p_new_driver);
	if (driver_list.size()==1) internal_driver_init();
}

int Sound_Driver_Manager::get_amount_of_drivers() {

	return driver_list.size();

}

string Sound_Driver_Manager::get_driver_name(int p_driver_index) {

	if ((p_driver_index<0) || ((unsigned)p_driver_index>=driver_list.size())) return "Invalid driver request";

	return driver_list[p_driver_index]->get_name();

}

int Sound_Driver_Manager::get_active_driver() {

	return active_driver_index;

}

void Sound_Driver_Manager::set_active_driver(int p_driver_index) {

	if ((p_driver_index<0) || ((unsigned)p_driver_index>=driver_list.size())) return;
	if (p_driver_index==active_driver_index) return;

	internal_lock->grab();

	if (driver_list[active_driver_index]->is_active()) {

			driver_list[active_driver_index]->finish();

	}
	
	active_driver_index=p_driver_index;
	internal_driver_init();

	internal_lock->release();

}
void Sound_Driver_Manager::stop_active_driver() {

	if (driver_list[active_driver_index]->is_active())
		driver_list[active_driver_index]->finish();

}

void Sound_Driver_Manager::poll_active_driver() {


	variables_lock->grab();
	internal_lock->grab();

        if (driver_list[active_driver_index]->is_active()) driver_list[active_driver_index]->update();

	internal_lock->release();
	variables_lock->release();

}

void Sound_Driver_Manager::reset_active_driver() {

	internal_lock->grab();

	if (driver_list[active_driver_index]->is_active()) {

		driver_list[active_driver_index]->finish();

	}

	internal_driver_init();

	internal_lock->release();
}

bool Sound_Driver_Manager::is_active_driver_active() {


	return driver_list[active_driver_index]->is_active();
}


void Sound_Driver_Manager::request_mix_frequency(int p_mix_frequency) {

	tmp_mix_frequency=p_mix_frequency;
	
        bool need_reinit=false;

	internal_lock->grab();

	if (driver_list[active_driver_index]->is_active()) {

		driver_list[active_driver_index]->finish();
  		need_reinit=true;

	}


	driver_list[active_driver_index]->request_mix_frequency(p_mix_frequency);

 	if (need_reinit)
		driver_list[active_driver_index]->init();

	internal_lock->release();
}

void Sound_Driver_Manager::request_mix_stereo(bool p_mix_stereo) {

	tmp_mix_stereo=p_mix_stereo;

        bool need_reinit=false;

	internal_lock->grab();

	if (driver_list[active_driver_index]->is_active()) {

		driver_list[active_driver_index]->finish();
  		need_reinit=true;

	}


	driver_list[active_driver_index]->request_mix_stereo(p_mix_stereo);

 	if (need_reinit)
		driver_list[active_driver_index]->init();

	internal_lock->release();

}


void Sound_Driver_Manager::request_mix_16bits(bool p_mix_16bits) {

	tmp_mix_16bits=p_mix_16bits;

        bool need_reinit=false;

	internal_lock->grab();

	if (driver_list[active_driver_index]->is_active()) {

			driver_list[active_driver_index]->finish();
	  		need_reinit=true;

	}

	driver_list[active_driver_index]->request_mix_16bits(p_mix_16bits);

	if (need_reinit)
		driver_list[active_driver_index]->init();

	internal_lock->release();

}

void Sound_Driver_Manager::request_buffer_size(int p_buffsize) {

	tmp_mix_buffsize=p_buffsize;

        bool need_reinit=false;

	internal_lock->grab();

	if (driver_list[active_driver_index]->is_active()) {

			driver_list[active_driver_index]->finish();
	  		need_reinit=true;

	}

 	
	driver_list[active_driver_index]->request_buffer_size(p_buffsize);

 	if (need_reinit)
		driver_list[active_driver_index]->init();

	internal_lock->release();

}

void Sound_Driver_Manager::internal_driver_init() {

	driver_list[active_driver_index]->request_mix_frequency(tmp_mix_frequency);
	driver_list[active_driver_index]->request_mix_stereo(tmp_mix_stereo);
	driver_list[active_driver_index]->request_mix_16bits(tmp_mix_16bits);
	driver_list[active_driver_index]->request_buffer_size(tmp_mix_buffsize);
	driver_list[active_driver_index]->init();
}
int Sound_Driver_Manager::get_mix_frequency() {

	return driver_list[active_driver_index]->get_mix_frequency();
}
bool Sound_Driver_Manager::get_mix_stereo() {

	return driver_list[active_driver_index]->get_mix_stereo();
}
bool Sound_Driver_Manager::get_mix_16bits() {

        return driver_list[active_driver_index]->get_mix_16bits();
}
int Sound_Driver_Manager::get_mix_buffer_size() {

        return driver_list[active_driver_index]->get_mix_buffer_size();
}

Sound_Driver_Manager::Sound_Driver_Manager(){
	
	tmp_mix_frequency=DEFAULT_MIX_FREQUENCY;
	tmp_mix_stereo=DEFAULT_MIX_STEREO;
	tmp_mix_16bits=DEFAULT_MIX_16BITS;
	tmp_mix_buffsize=DEFAULT_MIX_BUFFSIZE;

	active_driver_index=0;
}
Sound_Driver_Manager::~Sound_Driver_Manager(){
}
