// Sound_Driver_Win32.h: interface for the Sound_Driver_Win32 class.
//
// by James Martin, adapted by Juan Linietsky for Saturno
//////////////////////////////////////////////////////////////////////

#ifndef SOUND_DRIVER_WIN32_H
#define SOUND_DRIVER_WIN32_H

#ifdef __WIN32__

#include "sound_driver.h"

#define SOUNDBLOCKSIZE  100         // Size in millisecondsM
#define MINMIXSIZE      15          // Minimum milliseconds to mixM

#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <mmsystem.h>
#include <fcntl.h>
#include <malloc.h>
#include <dsound.h>
#include <stdio.h>
#include <stdlib.h>
#include <winsock.h>
#include <process.h>
#include "typedefs.h"




class Sound_Driver_Win32 : public Sound_Driver   {


	bool driver_ready;
         struct {
        	Uint16	HZ;	    // HZ of playback
        	Uint8	Bits;	    // Bits per sample, 8 or 16
        	Uint8	Stereo;     // TRUE if stereo, FALSE if not
        	} g_SoundFormat;    // Format of streaming sound

         LPDIRECTSOUNDBUFFER g_PrimaryBuffer;
        					// Primary sound buffer (not used
        					// directly)
         LPDIRECTSOUNDBUFFER g_SecondaryBuffer;
        					// Secondary sound buffer for mixing
        					// sound into
         Uint32 g_SecondaryBufferSize;	// Size of secondary buffer in bytes
         Uint32 g_MinimumMixBytes;	// MINMIXSIZE readjusted from ms to
        					// bytes
         Uint32 g_WritePosition;		// First byte not yet written to
         LPDIRECTSOUNDNOTIFY g_SecondaryBufferNotify;
        					// Notification object for secondary
        					// buffer

         HANDLE g_SoundNotify;	// Event to notify the sound thread
        					// that more mixing is required
         Uint8 g_SoundThreadExit; 	// FALSE = No exit requested
        					// TRUE = Exit requested
         Uint8 g_SoundThread;	// FALSE = Sound thread doesn't exist
        					// TRUE = Sound thread exists

         

         void * g_Context;




public:

	int get_mix_buffer_size();
	bool get_mix_16bits();
	bool get_mix_stereo();
	int get_mix_frequency();
	void request_buffer_size(int p_buffsize);
	void request_mix_16bits(bool p_mix_16bits);
	void request_mix_stereo(bool p_mix_stereo);
	void request_mix_frequency(int p_mix_frequency);
	bool update();
	bool finish();
	bool is_active();
	int init();
	Sound_Driver_Win32();
	virtual ~Sound_Driver_Win32();

	std::string get_name() { return "Win32 Sound Driver"; };

};

#endif // !defined(AFX_SOUND_DRIVER_WIN32_H__F680845D_6BDF_4937_971A_08E67695C5E2__INCLUDED_)
#endif