/*-----------------------------------------------------------------------
  File : cimgmatlab_cannyderiche.cpp

  Description: Example for the CImg plugin: cimgmatlab.h
  which allows to use CImg in order to develop matlab external
  functions (mex functions).
  User should be familiar with Matlab C/C++ mex function concepts,
  as this file is by no way a mex programming tutorial.

  This simple example implements a mex function that can be called 
  as 

  - v = cimgmatlab_cannyderiche(u,s)
  - v = cimgmatlab_cannyderiche(u,sx,sy)
  - v = cimgmatlab_cannyderiche(u,sx,sy,sz)

  The corresponding m-file is cimgmatlab_cannyderiche.m
    

  Copyright : Francois Lauze - http://www.itu.dk/people/francois
  This software is governed by the Gnu General Public License
  see http://www.gnu.org/copyleft/gpl.html 

  The plugin home page is at 
  http://www.itu.dk/people/francois/cimgmatlab.html

  for the compilation: using the mex utility provided with matlab, just 
  remember to add the -I flags with paths to CImg.h and/or cimgmatlab.h.
  The default lcc cannot be used, it is a C compiler and not a C++ one!
--------------------------------------------------------------------------*/


#include <mex.h>
#define cimg_plugin "plugins/cimgmatlab.h"
#include "../CImg.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    if (nrhs < 2) mexErrMsgTxt("No enough input arguments.");
    if (nrhs > 4) mexErrMsgTxt("Too many input arguments.");

    
	cimg_library::CImg<> u(prhs[0],true);
    if (nrhs == 2) {
        float s = (float)mxGetScalar(prhs[1]);
        plhs[0] = u.get_blur(s).toMatlab();
    } else if (nrhs == 3) {
        float sx = (float)mxGetScalar(prhs[1]);
        float sy = (float)mxGetScalar(prhs[2]);
        plhs[0] = u.get_blur(sx,sy,0).toMatlab();
    } else if (nrhs == 4) {
        float sx = (float)mxGetScalar(prhs[1]);
        float sy = (float)mxGetScalar(prhs[2]);
        float sz = (float)mxGetScalar(prhs[3]);
        plhs[0] = u.get_blur(sx,sy,sz).toMatlab();
    }
}
