/*
 * plugin_main.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  plugin_main.hpp   --  interface for CinePaint functionality
  
  Explicite CinePaint dependencies only in "plugin_main.cpp", here the
    interface to the outside via the two functions declared below. Well,
    encapsulation succeeded exept for `GPrecisionType' and "lib/wire/enums.h".
    Name "plugin_main.hpp" for the interface file ill-fated.
*/
#ifndef plugin_main_hpp
#define plugin_main_hpp

#include "br_defs.hpp"


#ifdef NO_CINEPAINT

bool cpaint_load_image (const char* fname) {} 
void cpaint_show_image (int W, int H, const uchar* buf, int) {}
                                                     // ^^^ nicht ganz perfekt
#else


extern "C" {
#include "lib/wire/enums.h"     // GPrecisionType
}

bool cpaint_load_image (const char* fname); 
void cpaint_show_image (int W, int H, const uchar* buf, GPrecisionType);


#endif  // NO_CINEPAINT
#endif  // plugin_main_hpp

// END OF FILE
