/*
   CIPE - encrypted IP over UDP tunneling

   crcgen.c - run a CRC32 over the input

   Copyright 1999 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: crcgen.c,v 1.3 2000/03/12 00:10:14 olaf Exp $ */

#include <stdio.h>
#include <unistd.h>

#define BUFS 4096

extern unsigned long crc32(const unsigned char *s, unsigned int len);

int main(int argc, char *argv[])
{
    unsigned long crc=0UL;
    if (argc<2)
        exit(1);
    if (argv[1][0]=='-') {
        char buf[BUFS];
        int n;
        n=read(0, buf, BUFS-1);
        if (n<0)
            exit(2);
        if (n>=BUFS)
            exit(3);
        crc=crc32(buf, n);
	buf[n]=0;
	printf("/* Configuration defines:%s*/\n", buf);
    } else {
        crc=crc32(argv[1], strlen(argv[1]));
    }
    printf("#define VERSION_MAGIC 0x%08lXUL\n", crc);
    return 0;
}
