/* TorusMod.c                               3/2001 */

/* Routines for investigating the moduli of 1-tori; to be called
from CirclePack.

Call from CirclePack with 
	"exec TorusMod"
Then send commands from within CirclePack using "mr TorusMod <cmd> ".

Call standalone from shell with
        "TorusMod -cmd"
then type commands from the keyboard.

makefile entry:
TM: TorusMod.o libCP_libs.a
	$(CC) TorusMod.o -o ${CP_BIN_DIR}/TM ${DEBUG} \
	$(XOPTIONS) ${INCLUDES} ${DEBUG} -lm

*/
 
/* ----- user specified variables set before compiling -------- */

#undef _KERNEL
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/resource.h>
#include "cp_types.h"
#include "cp_proto.h"

/* some global variables needed by library routines */
double toler=TOLER,okerr=OKERR;
int **face_org;

int cmdmode=0,read_key;

char emsgbuf[BUFSIZE],buf[BUFSIZE],next[BUFSIZE]; /* utility buffers. */
char data[2*BUFSIZE],*msgbuf;
char nextcmd[BUFSIZE],inmsg[BUFSIZE];
FILE *fp;
struct p_data *packdata;

/* procedure prototypes */
int sort_a_cmd(char *inmsg);
int parse_a_cmd(char *command);
int emsg();
int msg();

/* -------- main routine ----------- */

int main(int argc,char *argv[])
{
  int i;

		/* ---------- initialization --------------- */

  strcpy(emsgbuf,"ERROR: "); /* set up buffers */
  msgbuf=emsgbuf+7;
  fp=NULL;

  sprintf(msgbuf,"Hello, world, from TorusMod.");
  msg();

  if (!(packdata=(struct p_data *)
	calloc(1,sizeof(struct p_data))) 
      || !alloc_pack_space(packdata,5000,0))
    {
      sprintf(msgbuf,"TorusMod exited: problem creating pack space.");
      emsg();
      exit(0);
    }
  for (i=1;i<argc;i++)
    {
      if (!strncmp(argv[i],"-cmd",4)) /* command-line mode? */
	cmdmode=1;
    }

/* --- mini-notifier loop: continually check for input from stdin */

  printf("cmd: ");
  while (fgets(inmsg,BUFSIZE,stdin))
    {
      sort_a_cmd(inmsg);
    } 
  exit(2);

} /* end of main */

int sort_a_cmd(char *inmsg)
/* pick of individual commands in input stream, separated by ';' .*/
{
  int flag=1,n;
  char *command,local_stream[BUFSIZE],*token_ptr;

  strncpy(local_stream,inmsg,BUFSIZE-1);
  local_stream[BUFSIZE-1]='\0';
  token_ptr=local_stream;
  while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
  stripsp(token_ptr);
  while (flag && (n=strcspn(token_ptr,";"))>0)
    {
      flag=0;
      command=token_ptr;
      token_ptr += n;
      if (*(token_ptr)==';')
	{
	  *(token_ptr)='\0';
	  token_ptr += 1;
	  stripsp(token_ptr);
	}
      while (*(token_ptr)==';' || *(token_ptr)==' ') token_ptr++;
      stripsp(command);
      flag=parse_a_cmd(command); /* stops if parse returns 0 */
    } /* end of while */
  printf("cmd: ");
  return flag;
} /* sort_a_cmd */

int parse_a_cmd(char *command)
/* Handle the commands passed from sort_a_cmd */
{
  int flag=0,pnum;
  char *nextpoint,cmd[BUFSIZE];

  nextpoint=command;
  if (!grab_next(&nextpoint,cmd)) return 0; /* get command */
  strcpy(data,nextpoint); /* rest is data */
  switch (cmd[0])
    {
    case 'b':
      {
	if (!strncmp(cmd,"bye",3)) /* =========== exit */
	  {
	    sprintf(msgbuf,"bye");
	    msg();
	    if (fp) fclose(fp);
	    exit(5);
	  }
	break;
      }
    case 'r': 
      { 
	if (!strncmp(cmd,"read",4)) /* ========== read packing */ 
	  {
	    flag=0;
	    if (!cmdmode) /* required to get packing from parent. */
	      {
		if ((pnum=atoi(data))<0 || pnum>2
		    || !r_pack_read(packdata,pnum,0017) 
		    || !readpack(stdin,packdata)) 
		  {
		    sprintf(msgbuf,"TorusMod: read of pack p%d failed.",pnum);
		    emsg();
		  }
		else 
		  {
		    flag=packdata->status=1;
		    sprintf(msgbuf,"TorusMod: got packing p%d.",pnum);
		    msg();
		  }
	      }
	    else
	      {
		if ( (fp=fopen(next,"r"))==NULL
		     || !(read_key=readpack(fp,packdata)) )
		  {
		    sprintf(msgbuf,"TorusMod: read of %s failed.",next);
		    emsg();
		  }
		else 
		  {
		    flag=packdata->status=1;
		    sprintf(msgbuf,"TorusMod: got packing from %s.",next);
		    msg();
		  }
		if (fp) fclose(fp);
	      }
	    if (flag)
	      {
		if (packdata->faces!=NULL) 
		  {free(packdata->faces);packdata->faces=NULL;}
		complex_count(packdata,1);
		catalog_faces(packdata);
		return 1;
	      }
	  }
	break;
      }

    case 'x': /* experiment: send a command to CirclePack */
      {
	sprintf(msgbuf,"disp -p0 -w -cf b");
	r_cmsg(msgbuf);
	break;
      }
    case '?':
      {
	sprintf(msgbuf,"TorusMod commands are:\n"
		"   read <filename>\n"
		"   bye\n");
	msg();
	return 1;
      }
   } /* end of cmd switch */
  return 0;
} /* parse_a_cmd */

int emsg()
{
  if (!cmdmode)
    {
      stripsp(msgbuf);
      r_emsg(msgbuf);
    }
  else printf(emsgbuf);
  return 1;
}

int msg()
{
  if (!cmdmode) 
    {
      stripsp(msgbuf);
      r_msg(msgbuf);
    }
  else {printf(msgbuf);fsync((int)stdout);}
  return 1;
}

