#include "cp_types.h"
#include "cp_proto.h"

/* compute and store center/rad of last circle of face f in pack p; 
flag is optional index, else flag<0, use index_flag of f_data. */

int comp_center_face(struct p_data *p,int f,int flag)
{
  int j,k,v,indx;
  double o1,o2,o3;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  if (f<1 || f> p->facecount) return 0;
  if (flag<0 || flag>2) indx=p->faces[f].index_flag;
  else indx=flag;
  j=p->faces[f].vert[indx];
  k=p->faces[f].vert[(indx+1) % 3];
  v=p->faces[f].vert[(indx+2) % 3];
  if (p->overlap_status)
    {
      o1=pK_ptr[k].overlaps[nghb(p,k,v)];
      o2=pK_ptr[v].overlaps[nghb(p,v,j)];
      o3=pK_ptr[j].overlaps[nghb(p,j,k)];
    }
  else o1=o2=o3=1.0;

/* temp debug */
/*  if (v==17180 && j==17827 && k==13746)
      j=j;*/

  return (any_compcenter(p->hes,pR_ptr[j].center,pR_ptr[k].center,
		 &pR_ptr[v].center,pR_ptr[j].rad,pR_ptr[k].rad,
		 &pR_ptr[v].rad,o1,o2,o3));
} /* comp_center_face */








