/* cp_action.c  routines to handle the actions sent by the notifier. */

#include "cp_head.h"

char *datastr;
int canv1; /* holds canvas number, set in canvas_evt routine */
FILE *fp; 
Textsw_mark script_command;
char next[BUFSIZE];
extern Menu cmd_menu,pack_menu,screen_opt_menu,
  O_menu,R_menu,C_menu,K_menu,
  inquiry_menu,misc_menu,special_menu,color_menu,param_menu,
  screen_c_menu,disp_opt_menu;
extern void textsw_possibly_normalize(),textsw_set_selection();

int script_sw_notify_proc(Textsw textsw,Attr_avlist attributes)
{
  int pass_on = FALSE;	
  Attr_avlist attrs;
  extern void (*default_textsw_notify)();
  char filename[NAME_MAX];
  Textsw_index pos;

  for (attrs=attributes;*attrs;attrs=attr_next(attrs))
    {
      switch ((Textsw_action)(*attrs))
	{
	case TEXTSW_ACTION_LOADED_FILE: /* want to mark next command line */
	  {
	    sprintf(filename,"Script Window - ");
	    if (textsw_append_file_name(script_sw,filename)!=0)
	      strcat(filename,"(NONE)\0");
	    xv_set(script_frame,XV_LABEL,filename,0);
	    pos=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);
	    if ((int)pos==0) script_file_data_mark=script_file_cmd_mark
	       = script_file_path_mark
	       =(Textsw_mark)
	         textsw_add_mark(script_sw,pos,TEXTSW_MARK_DEFAULTS);
	    /* probably new file */
	    pass_on=TRUE;
	    break;
	  }
	case TEXTSW_ACTION_EDITED_FILE: /* indicate editing */
	  {
	    sprintf(filename,"Script Window - ");
	    if (textsw_append_file_name(script_sw,filename)!=0) 
	      /* no file name */
	      {
		strcat(filename,"(NONE)\0");
		pos=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);
		if ((int)pos < 6)   script_file_data_mark
			=script_file_cmd_mark
			=script_file_path_mark
			=(Textsw_mark)
			  textsw_add_mark(script_sw,pos,TEXTSW_MARK_DEFAULTS);
		/* probably starting empty file */
	      }
	    strcat(filename," (edited)\0");
	    xv_set(script_frame,XV_LABEL,filename,0);
	    pass_on=TRUE;
	    break;
	  }
	case TEXTSW_ACTION_EDITED_MEMORY: /* editing empty window */
	  {
	    sprintf(filename,"Script Window - (NONE) (edited)");
	    xv_set(script_frame,XV_LABEL,filename,0);
	    pass_on=TRUE;
	    break;
	  }
	default:
	  {
	    pass_on=TRUE;
	    break;
	  }
	} /* end of switch */
    } /* end of for */
  if ((int)xv_get(script_sw,TEXTSW_LENGTH) == 0)
    {
      sprintf(filename,"Script Window - (NONE)");
      xv_set(script_frame,XV_LABEL,filename,0);
    } 
  if (pass_on) default_textsw_notify(textsw,attributes);
  return 1;
} /* script_sw_notify_proc */	

char *find_script_data(char *datastr,int flag)
     /* Search forward in file to locate data following given <name>; 
loads buffer. flag 1=pack,2=path,3=cmds. Data must begin 
shortly after <name>. */ 
{
  int length,stop_flag=0,total;
  Textsw_index name1,name2,key2,first=(Textsw_index)0,
    last_plus_one,end_pos,lastpt;
  char *buffer,prefix[6];

  total=(int)xv_get(script_sw,TEXTSW_LENGTH);
  lastpt=name1=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);
  while (flag==1 && !stop_flag 
	 && (int)name1<total && (int)name1>=(int)lastpt) 
    /* search for pack data */
    {
      if (textsw_find_bytes(script_sw,&name1,&name2,datastr,
	 (int)strlen(datastr),0)<0 || (int)name1<(int)lastpt)
	{window_bell(script_sw);return NULL;}
      lastpt=name2;
      if (textsw_find_bytes(script_sw,&name2,&key2,"COUNT:",6,0)>=0
	  && ((int)name2-(int)name1)<=(strlen(datastr)+12) 
	  && (int)name2>=5)
	/* found name with nearby data */
	{
	  stop_flag=1;
	  xv_get(script_sw,TEXTSW_CONTENTS,
		 (Textsw_index)(name2-5),prefix,5);
	  prefix[5]='\0';
	  if (strcmp(prefix,"CHECK")==0) 
	    first=(Textsw_index)(name2-5);
	  else if(strcmp(prefix+1,"NODE")==0) 
	    first=(Textsw_index)(name2-4);
	  else {window_bell(script_sw);return NULL;}
	  /* malformed data */
	}
      name1=lastpt;
    }
  while (flag==2 && !stop_flag 
	 && (int)name1<total && (int)name1>=(int)lastpt) 
    /* search for path data */
    {
      if (textsw_find_bytes(script_sw,&name1,&name2,datastr,
			    (int)strlen(datastr),0)<0 || (int)name1<(int)lastpt)
	{window_bell(script_sw);return NULL;}
      lastpt=name2;
      if (textsw_find_bytes(script_sw,&name2,&key2,"PATH",4,0)>=0
	  && ((int)name2-(int)name1)<=(strlen(datastr)+8))
	/* found name with nearby data */
	{
	  stop_flag=1;
	  first=name2;
	}
      name1=lastpt;
    }
  while (flag==3 && !stop_flag 
	 && (int)name1<total && (int)name1>=(int)lastpt) 
    /* search for cmds data */
    {
      if (textsw_find_bytes(script_sw,&name1,&name2,datastr,
			    (int)strlen(datastr),0)<0 || (int)name1<(int)lastpt)
	{window_bell(script_sw);return NULL;}
      lastpt=name2;
      if (textsw_find_bytes(script_sw,&name2,&key2,"CMDS",4,0)>=0
	  && ((int)name2-(int)name1)<=(strlen(datastr)+8))
	/* found name with nearby data */
	{
	  stop_flag=1;
	  first=name2;
	}
      name1=lastpt;
    }
  if (!stop_flag || textsw_find_bytes(script_sw,&key2,&last_plus_one,
				      "END",3,0)<0)
    {window_bell(script_sw);return NULL;}
  /* malformed/missing data set */
  length=(int)last_plus_one-(int)first;
  buffer=(char *)malloc(length+2);
  end_pos=(Textsw_index)xv_get(script_sw,TEXTSW_CONTENTS,
			       (int)first,buffer,length);
  if (end_pos != (int)first+length)
    {window_bell(script_sw);return NULL;}
  buffer[length]='\n';buffer[length+1]='\0';
  return buffer;
} /* find_script_data */

int find_next_script_cmd(int direction,int ex_flag)
     /* finds and selects (or executes) next (or previous) command from 
insertion pt in script. Return -1 if command not found, else return 
index of first character. direction: 0=forward, 1=backward. */
{
  int cmd_length,cmd_shift;
  unsigned dir;
  Textsw_index	first,last_plus_one,pos,dummy;
  char *datastr;

  dir=(unsigned)direction;
  if (ex_flag) 
    first=(Textsw_index) xv_get(script_sw,TEXTSW_INSERTION_POINT);
  else first=textsw_find_mark(script_sw,script_file_cmd_mark);
  dummy=first;
  pos=textsw_find_bytes(script_sw,&dummy,&last_plus_one,
			"]:=",3,dir);
  if ( pos<0 || (dir==0 && pos < first) 
       || (dir==1 && pos >= first) ) 
    {
      (void) window_bell(script_sw);
      return -1;
    }
  first=dummy=last_plus_one;
  datastr=(char *)malloc(1024);
  pos=(Textsw_index) xv_get(script_sw,TEXTSW_CONTENTS,(int)first,
			    datastr,1023);
  if ((cmd_length=(int)pos - (int)first)<1024) 
    datastr[cmd_length]='\0';
  else datastr[1023]='\0';
  if (!cmd_search(datastr,&cmd_shift))
    /* didn't get anything */
    {
      (void) window_bell(script_sw);
      free(datastr);
      return -1;
    }
  dummy=dummy+(Textsw_index)cmd_shift;
  if (ex_flag) 
    {
      free(next_script_cmd);
      next_script_cmd=datastr;
      xv_set(script_sw,TEXTSW_INSERTION_POINT,dummy,0);
      textsw_possibly_normalize(script_sw,dummy);
      script_file_cmd_mark=(Textsw_mark)
	textsw_add_mark(script_sw,dummy,TEXTSW_MARK_DEFAULTS);
      return cmd_length;
    }
  textsw_set_selection(script_sw,first,dummy,1);
  textsw_possibly_normalize(script_sw,dummy);
  return 0;	
} /* find_next_script_cmd */

int exe_named_cmd(char *datastr,int *targ_p)
     /* Search script file, execute first cmd beginning '[datastr]:='.
If none found and datastr is not empty, execute first beginning 
'[datastr}:='. The curly bracket means the 
command won't be executed unless called explicitly with label. */
{
  long save_pos,start_pos;
  int cmd_length,cmd_shift,count=0,label_flag=0;
  char next[256],bracket[260],*cmdstr;
  Textsw_index	pos,first,last_plus_one;

  if (cmd_mode && !script_fp) return 0;
  cmd_search_depth++;
  stripsp(datastr);
  if (!grab_next(&datastr,next)) next[0]='\0';
  if (cmd_search_depth>10) 
    {
      cmd_search_depth--;
      return 0;
    }

  if (!cmd_mode) /* GUI mode */
    {
      first=(Textsw_index)0;
      sprintf(bracket,"[%s]:=",next);
      pos=textsw_find_bytes(script_sw,&first,&last_plus_one,
			    bracket,(int)strlen(bracket),0); 
      if (pos<0) /* not found, look for } */
	{
	  sprintf(bracket,"[%s}:=",next);
	  pos=textsw_find_bytes(script_sw,&first,&last_plus_one,
				bracket,(int)strlen(bracket),0); 
	  if (pos<0) /* still not found */
	    {
	      (void) window_bell(script_sw);
	      cmd_search_depth--;
	      return 0;
	    }
	}
      first=last_plus_one;
      cmdstr=(char *)calloc((size_t)(BUFSIZE+2),sizeof(char));
      pos=(Textsw_index) xv_get(script_sw,TEXTSW_CONTENTS,(int)first,
				cmdstr,BUFSIZE);
      if ((cmd_length=((int)pos - (int)first))<BUFSIZE) 
	cmdstr[cmd_length]='\0';
      else cmdstr[BUFSIZE+1]='\0';
      if (!cmd_search(cmdstr,&cmd_shift))
	/* didn't get anything */
	{
	  (void) window_bell(script_sw);
	  free(cmdstr);
	  cmd_search_depth--;
	  return 0;
	}
      cmdstr[cmd_shift]='\0';
    }
  else /* cmd mode */
    {
      label_flag=strlen(next); 
      save_pos=ftell(script_fp); /* save position in file */
      start_pos = (label_flag) ? 0 : save_pos; /* where to start search */

      sprintf(bracket,"%s]:=",next);
      if (find_token(script_fp,start_pos,&cmdstr,bracket)<0) /* no luck */
	{
	  sprintf(bracket,"%s}:=",next);
	  if (!label_flag 
	      || find_token(script_fp,start_pos,&cmdstr,bracket)<0)
	    /* didn't get anything */
	    {
	      if (cmdstr) free(cmdstr);
	      fseek(script_fp,save_pos,SEEK_SET);
	      cmd_search_depth--;
	      return 0;
	    }
	}
      if (label_flag) /* if labeled cmd, restore original file position */
	fseek(script_fp,save_pos,SEEK_SET);
    }
  count=sort_cmd(cmdstr,targ_p);
  cmd_search_depth--;
  free(cmdstr);
  return count;
} /* exe_named_cmd */

int cmd_proc(Panel_item item,Event *event)
/* cmd_menu actions.*/
{
  if (event_action(event)==ACTION_MENU && event_is_down(event))
    menu_show(cmd_menu,panel,event,0);
  else if (event_action(event)==ACTION_SELECT && event_is_down(event) )
    sort_cmd(cmd_history,&current_p);
  return 1;
} /* cmd_proc */

int cmd_line_proc(Panel_item item,Event *event)
{
  strcpy(buf,(char *)xv_get(cmd_item,PANEL_VALUE));
  sort_cmd(buf,&current_p);
  xv_set(cmd_item,PANEL_VALUE,"",0);
  return 1;
} /* cmd_line_proc */

int handle_cmd_proc(Menu menu,Menu_item menuitem)
{
  char *cmd_stream;
  int act=(int) xv_get(menuitem,MENU_VALUE);

  switch (act)
    {
    case 1: /* repeat last command */
      {sort_cmd(cmd_history,&current_p); return 1;} 
    case 2: /* execute selected command string */
      {
	if (!strlen(cmd_stream = get_selection(1))) return 1;
	if (sort_cmd(cmd_stream,&current_p)) strcpy(cmd_history,cmd_stream);
	/* if command seems to work, it is stored for later use. */
	return 1;
      }
    case 3: /* print `cmd_history' at end of scratch_sw */
      {
	sprintf(msgbuf,"\n"); strcat(msgbuf,cmd_history);strcat(msgbuf,"\n");
	smsg();
	return 1;
      } 
    } /* end of switch */
  return 1;
} /* handle_cmd_proc */

int pack_proc(Panel_item item,Event *event)
     /* pack_menu actions.*/
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(pack_menu,panel,event,0);return 1;}

int handle_path_io_proc(Menu menu,Menu_item menuitem)
{
  char *filename;
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!strlen(filename=get_selection(1)))
    {
      strcpy(msgbuf,"You must make a filename selection");
      emsg();
      return 1;
    }
  if (act==1) /* read */
    {
      sprintf(buf,"read_path %s",filename);
      handle_cmd(buf,&current_p);
      return 1;
    }
  else if (act==2)
    {
      if ((fp=fopen(buf,"r")) != NULL)
	{
	  sprintf(buf,"File %s already exists. Overwrite???",
		  filename);
	  fclose(fp);
	  if (!confirm_action(buf)) return 1;
	}
      sprintf(buf,"write_path %s",filename);
      handle_cmd(buf,&current_p);	
      return 1;
    }
  return 1;
} /* handle_path_io_proc */
		
int handle_write_proc(Menu menu,Menu_item menuitem)
{
  char *filename;
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!strlen(filename=get_selection(1)))
    {
      strcpy(msgbuf,"You must make a filename selection");
      emsg();
      return 1;
    }
  /* write directly to script file (or named file) */
  if (act == 6) 
    {
      sprintf(buf,"write -s %s",filename);
      handle_cmd(buf,&current_p);
      return 1;
    }
  set_packing_path();
  strcpy(buf,path);
  strcat(buf,filename);
  if ((fp=fopen(buf,"r")) != NULL)
    {
      sprintf(buf,"File %s already exists. Overwrite???",filename);
      fclose(fp);
      if (!confirm_action(buf)) return 1;
    }
  if (act==7)
    {
      sprintf(buf,"eucl_write %s",filename);
      handle_cmd(buf,&current_p);
      return 1;
    }
  strcpy(buf,"write");
  switch (act)
    {
    case 2: /* combinatoric info only */
      {strcat(buf," -c ");break;}
    case 3: /* minimal */
      {strcat(buf," -m ");break;}
    case 4: /* maximal */
      {strcat(buf," -M ");break;}
    case 5: /* efficient: no cents/angsums */
      {strcat(buf," -e ");break;}
    default: /* default */
      {strcat(buf," -d ");break;}
    }
  strcat(buf,filename);
  return (handle_cmd(buf,&current_p));
} /* handle_write_proc */

int handle_pack_proc(Menu menu,Menu_item menuitem)
{
  int p=current_p,p1,act=(int) xv_get(menuitem,MENU_VALUE);
  char *filename,*datastr;

  switch (act)
    {
    case 1:   /* select and read from file */
      {
	if (!strlen(filename = get_selection(1)))
	  {
	    strcpy(msgbuf,"You must make a filename selection.");
	    emsg();return 1;
	  }
	if (packdata[p].status)
	  {
	    sprintf(buf,"Overwrite active pack?");
	    if (!confirm_action(buf)) return 1;
	  }
	sprintf(buf,"read %s",filename);
	return (handle_cmd(buf,&current_p));
      }
    case 3:  /* copy to selected pack */
      {
	if (!strlen(datastr = get_selection(1))
	    || sscanf(datastr,"%d",&p1)!=1 || p1<0 || p1>=NUM_PACKS
	    || !packdata[current_p].status)
	  {
	    strcpy(msgbuf,"Data form: p. Copy active pack data to pack p. ");
	    emsg();return 1;
	  }
	if (packdata[p1].status)
	  {
	    sprintf(buf,"Pack %d already full. OK?",p1);
	    if (!confirm_action(buf)) return 1;
	  }
	sprintf(buf,"copy -p%d %d",current_p,p1);
	if (!handle_cmd(buf,&current_p)) {strcpy(msgbuf,"Copy failed");emsg();}
	return 1;
      }
    case 4: /* start new pack with a flower seed */
      {
	datastr = get_selection(1);
	if (packdata[p].status)
	  {
	    sprintf(buf,"Current pack has contents. Overwrite?");
	    if (!confirm_action(buf)) return 1;
	  }
	sprintf(buf,"seed %s",datastr);
	if (!handle_cmd(buf,&current_p)) 
	  {strcpy(msgbuf,"Seed failed to take.");emsg();}
	return 1;
      }
    case 5: /* read path from a file */
      {
	if (!strlen(filename = get_selection(1)))
	  {
	    strcpy(msgbuf,"You must select a filename containing the path.");
	    emsg();
	    return 1;
	  }
	sprintf(buf,"read_path %s",filename);
	return (handle_cmd(buf,&current_p));
      }
    } /* end of cases */
  return 1;
} /* pack_proc */

/* ------------------------ */

int screen_up_proc(Panel_item item,Event *event)
     /* screen_opt_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(screen_opt_menu,panel,event,0);return 1;}

int setup_proc() 
/* displays panel for setting various options */
{
  if (xv_get(setup_frame,WIN_SHOW))
    xv_set(setup_frame,WIN_SHOW,FALSE,0);
  else xv_set(setup_frame,WIN_SHOW,TRUE,0);
  return 1;
}

int handle_screen_up_proc(Menu menu,Menu_item menuitem)
{
  int pnum,act=(int) xv_get(menuitem,MENU_VALUE);

  if (act==0) return 1;
  pnum=act-1; 
  if (!packdata[pnum].status) 
    {sprintf(msgbuf,"Note: pack %d is empty.",pnum);msg();}
  canvas_life(pnum,1);
  return 1;
} /* screen_up_proc */

int cmd_up_proc(Panel_item item,Event *event)
{cmd_up(1);return 1;}

int cmd_up(int sflag)
     /* displays the cmd_frame, msg_frame, text_frame, and script 
frame if sflag . */
{
  xv_set(cmd_frame,WIN_SHOW,TRUE,0);
  xv_set(msg_frame,WIN_SHOW,TRUE,0);
  if (sflag) xv_set(text_frame,WIN_SHOW,TRUE,0);
  return 1;
} /* cmd_up_proc */

int script_up_proc()
/* open script_frame */
{
  if (xv_get(script_frame,WIN_SHOW))
    xv_set(script_frame,WIN_SHOW,FALSE,0);
  else {strcpy(buf,"script");handle_cmd(buf,&current_p);}
  return 1;
} /* script_up_proc */

/* ------------------------ */


/* ------------------------ */

int Radjust_proc(Panel_item item,Event *event)
     /* R_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(R_menu,panel,event,0);return 1;}

int handle_radjust_proc(Menu menu,Menu_item menuitem)
{
  int cp=current_p,act=(int) xv_get(menuitem,MENU_VALUE);
  double a,b;

  switch (act)
    {
    case 1: /* set one or more radii */
      {
  	if (!strlen(datastr=get_selection(1)))
	  {
	    strcpy(msgbuf,"You must select (decimal) radius "
		   "and vertex numbers.");
	    emsg();return 1;
	  }
	sprintf(buf,"set_rad %s",datastr);
	break;
      }
    case 2: /* set boundary radii to infinity (and adjust bdry 'aim'.)*/
      {
	if (packdata[cp].hes==0)
	  {
	    strcpy(msgbuf,"This is euclidean pack, can't set "
		   "radii to infinity.");
	    emsg();return 1;
	  }
	sprintf(buf,"set_rad -0.1 b");
	handle_cmd(buf,&current_p);
	sprintf(buf,"set_aim -0.1 b");
	break;
      }
    case 3: /* increment radii using inc_factor */
      {
  	if (!strlen(datastr=get_selection(1)))
	  {
	    strcpy(msgbuf,"You must select vertices to increment.");
	    emsg();return 1;
	  }
	sprintf(buf,"inc_rad %s",datastr);
	break;
      } 
    case 4:  /* Increment all finite bdry radii using inc_factor. */ 
      sprintf(buf,"inc_rad b");break;
    case 5: /* decrement radii using 1/inc_factor */
      {
  	if (!strlen(datastr=get_selection(1)))
	  {
	    strcpy(msgbuf,"You must select vertices to decrement.");
	    emsg();return 1;
	  }
	sprintf(buf,"dec_rad %s",datastr);
	break;
      }
    case 6:  /* Decrement all finite bdry radii using dec_factor. */ 
      sprintf(buf,"dec_rad b");break;
    case 7: /* set random radii */
      {
  	if (!strlen(datastr=get_selection(1)))
	  {
	    strcpy(msgbuf,"You must select vertices to randomize.");
	    emsg();return 1;
	  }
	sprintf(buf,"set_rand %s",datastr);
	break;
      }
    case 8: /* scale pack by a eucl_factor */
      sprintf(buf,"scale");break;
    case 9: /* create spiral packing using selected two parameters */
      {
	if (!strlen(datastr=get_selection(1)) 
	    || sscanf(datastr,"%lf %lf",&a,&b)!=2 || a<=0 || b<=0)
	  {strcpy(msgbuf,"Data form: a b. Select two "
		  "positive parameters.");emsg();return 1;}
	sprintf(buf,"spiral %s",datastr);
	if (!handle_cmd(buf,&current_p)) 
	  {strcpy(msgbuf,"Something went wrong with spiraling.");emsg();}
	return 1;
      }
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* handle_radjust_proc */

/* ------------------------ */

int Oadjust_proc(Panel_item item,Event *event)
     /* O_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(O_menu,panel,event,0);return 1;}

int handle_oadjust_proc(Menu menu,Menu_item menuitem)
{
  char buff[40];
  int act=(int) xv_get(menuitem,MENU_VALUE),p=current_p;
  double ang;

  switch (act)
    {
    case 1: /* set all overlaps */
      {
	if (!strlen(datastr = get_selection(1))) ang=0.0;
	else if (!sscanf(datastr,"%lf",&ang) || ang<0 || ang>0.500)
	  {
	    strcpy(msgbuf,"Selected overlap angle was not in [0,.5].");
	    emsg();return 1;
	  }
	sprintf(buff,"set_overlap %f",ang);
	break;
      }
    case 2: /* set selected overlaps, a + pairs v w */
      {	
	if (!strlen(datastr = get_selection(1)))
	  {
	    strcpy(msgbuf,"Data form: a v w.. angle a an list of node pairs.");
	    emsg();return 1;
	  }
	sprintf(buff,"set_overlap %s",datastr);
	break;
      }
    case 3: /* reset all to zero, free memory */
      {free_overlaps(&packdata[p]);return 1; }
    } /* end of switch */
  return (handle_cmd(buff,&current_p));
} /* handle_oadjust_proc */

/* ------------------------ */

int Cadjust_proc(Panel_item item,Event *event)
     /* C_menu actions.*/
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(C_menu,panel,event,0);return 1;}

int handle_cadjust_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);
	
  switch (act)
    {
    case 1: /* set to Andreev values (0 at bdry, 2pi interior) */
      {
	sprintf(buf,"set_aim -d");
	if (handle_cmd(buf,&current_p)) 
	  {strcpy(msgbuf,"Set aim values to default.");msg();}
	else 
	  {strcpy(msgbuf,"Something went wrong with setting "
		  "default aim values.");emsg();}
	return 1;
      }
    case 2: /* set selected aim values */
      {
	if (!strlen(datastr=get_selection(1)))
	  strcpy(buf,
		 "You must select (decimal) curvature, then "
		 "list vertex numbers.");
	sprintf(buf,"set_aim %s",datastr);
	return (handle_cmd(buf,&current_p));
      }
    case 3: /* reset all aims to current curvature values */
      sprintf(buf,"set_aim -c");break;
    case 4: /* reset interior aims to 2pi, bdry to -1 so they don't change.*/
      sprintf(buf,"set_aim -d");break;
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* Cadjust_proc */
	
/* ------------------------ */

int win_save_proc(Panel_item item,Event *event)
     /* save window locs/status? */
{save_workspace();return 1;}

int save_workspace() 
{
  int winopen,i;
  Rect rect;
  char wpname[NAME_MAX];
  FILE *wp;
  

  sprintf(buf,"Please confirm: Save your workspace?");
  if (!confirm_action(buf)) return 0;
  strcpy(wpname,home_dir);
  strcat(wpname,"/.packwp");
  if (!(wp=fopen(wpname,"w")))
    {
      sprintf(msgbuf,"Can't open %s to save window locations.",wpname);
      emsg();
      return 0;
    }
  fprintf(wp,"Save window locations for CirclePack\n\n");
  fprintf(wp,"   window        open?    x       y       w      h\n\n");

  frame_get_rect(base_frame,&rect);
  winopen=xv_get(base_frame,WIN_SHOW);
  fprintf(wp,"   base_frame:    %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(cmd_frame,&rect);
  winopen=xv_get(cmd_frame,WIN_SHOW);
  fprintf(wp,"   cmd_frame:    %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(msg_frame,&rect);
  winopen=xv_get(msg_frame,WIN_SHOW);
  fprintf(wp,"   msg_frame:    %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(script_frame,&rect);
  winopen=xv_get(script_frame,WIN_SHOW);
  fprintf(wp,"   script_frame: %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(setup_frame,&rect);
  winopen=xv_get(setup_frame,WIN_SHOW);
  fprintf(wp,"   setup_frame: %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(history_frame,&rect);
  winopen=xv_get(history_frame,WIN_SHOW);
  fprintf(wp,"   history_frame: %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(text_frame,&rect);
  winopen=xv_get(text_frame,WIN_SHOW);
  fprintf(wp,"   text_frame: %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  frame_get_rect(help_frame,&rect);
  winopen=xv_get(help_frame,WIN_SHOW);
  fprintf(wp,"   help_frame: %d      %d  %d  %d  %d\n",
	  winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);

  for (i=0;i<NUM_PACKS;i++)
    {
      frame_get_rect(canvas_frame[i],&rect);
      winopen=xv_get(canvas_frame[i],WIN_SHOW);
      fprintf(wp,"   canvas_frame[%d]: %d      %d  %d  %d  %d\n",i,
	      winopen,rect.r_left,rect.r_top,rect.r_width,rect.r_height);
    }

  fclose(wp);
  return 1;
} /* save_workspace */

int quit_proc(Panel_item item,Event *event)
     /* close up shop */
{quit(1);return 1;}

int quit(int flag)
     /* flag set means to confirm the quit command */
{
  if (cmd_mode) exit(2);
  if (flag)
    {
      sprintf(buf,"Confirm the QUIT (or use command 'Quit').");
      if (!confirm_action(buf)) return 1;
    }
  textsw_erase(msg_sw,0,TEXTSW_INFINITY);
  textsw_erase(scratch_sw,0,TEXTSW_INFINITY);
  textsw_erase(log_sw,0,TEXTSW_INFINITY);
  textsw_erase(script_sw,0,TEXTSW_INFINITY);
  xv_destroy_safe(base_frame); 
  exit(3);
  return 1;
} /* quit */

/* ------------------------ */

int help_proc()
/* popup help text window (read only) */
{
  if (xv_get(help_frame,WIN_SHOW))
    xv_set(help_frame,WIN_SHOW,FALSE,0);
  else xv_set(help_frame,WIN_SHOW,TRUE,0);
  return 1;
} /* help_proc */

/* ------------------------ */

int history_proc()
/* popup history text window */
{	if (xv_get(history_frame,WIN_SHOW))
  xv_set(history_frame,WIN_SHOW,FALSE,0);
 else xv_set(history_frame,WIN_SHOW,TRUE,0);
 textsw_possibly_normalize(log_sw,
   (Textsw_index) xv_get(log_sw,TEXTSW_INSERTION_POINT));
 return 1;
} /* history_proc */

/* ------------------------ */

int Kadjust_proc(Panel_item item,Event *event)
     /* K_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(K_menu,panel,event,0);return 1;}

int handle_kadjust_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  switch (act)
    {
    case 2: /* enclosing bdry circles */
      {
	if (!strlen(datastr = get_selection(1)))
	  {
	    strcpy(msgbuf,"Data: n v1 v2 ... Enclose vertices "
		   "with n added circles."); 
	    emsg();
	    return 1;
	  }
	sprintf(buf,"enclose %s",datastr);
	break;
      }	
    case 3: /* adjoin */
      {
	if (!strlen(datastr = get_selection(1))) *datastr='\0';
	sprintf(buf,"adjoin %s",datastr);
	break;
      }
    case 4: /* apply the cookie cutter */
      {sprintf(buf,"cookie");break; }
    case 7: /* swap node numbers */
      {
	if (!strlen(datastr=get_selection(0))) return 1;
	sprintf(buf,"swap %s",datastr);
	break;
      }
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* Kadjust_proc */

int handle_set_abc_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!strlen(datastr=get_selection(1))) return 1; 
  switch (act)
    {
    case 1: sprintf(buf,"alpha %s",datastr);break;
    case 2: sprintf(buf,"beta %s",datastr);break;
    case 3: sprintf(buf,"gamma %s",datastr);break;
    case 4: sprintf(buf,"node_active %s",datastr);break;
    } 
  return (handle_cmd(buf,&current_p));
} /* handle_set_abc_proc */

int handle_add_proc(Menu menu,Menu_item menuitem)
{
  int v,w,d,n,act=(int) xv_get(menuitem,MENU_VALUE);

  switch (act)
    {
    case 2: /* add layer of nodes to boundary segment;
	       start at v, end at w; new nodes d degree 
	       (to extent possible). */
      {
	if (!strlen(datastr=get_selection(1)) 
	    || sscanf(datastr,"%d %d %d",&v,&w,&d)!=3
	    || d<3 || d>MAX_PETALS 
	    || !packdata[current_p].packK_ptr[v].bdry_flag
	    || !packdata[current_p].packK_ptr[w].bdry_flag)
	  {
	    strcpy(msgbuf,"Data: `v w d', adds degree d circles "
		   "from bdry vertex v to w.");
	    emsg();return 1;
	  }
	sprintf(buf,"add_lay %d %d %d",v,w,d);
	break;
      }
    case 3: /* add n whole generations of degree d */
      {
	if (!strlen(datastr=get_selection(1)) 
	    || sscanf(datastr,"%d %d",&n,&d)!=2 
	    || n<1 || d<3 || d>MAX_PETALS+1)
	  {
	    strcpy(msgbuf,"Data: 'n d'. number n of generations "
		   "of degree d.");
	    emsg();return 1;
	  }
	sprintf(buf,"add_gen %d %d",n,d);
	break;
      }
    case 4: /* add ideal bdry point (new node surrounded by 
	       one of bdry comps) */
      {
	if (!strlen(datastr=get_selection(1)) 
	    || sscanf(datastr,"%d",&v)!=1 
	    || v<1 || v>packdata[current_p].nodecount 
	    || packdata[current_p].packK_ptr[v].bdry_flag)
	  {
	    strcpy(msgbuf,"Data: 'v'. v should be a boundary vertex.");
	    emsg();
	    return 1;
	  }
	sprintf(buf,"add_ideal %d",v);
	break;
      }	
    default: /* add bdry circle clkwise from v. */
      {
	if (!strlen(datastr = get_selection(1)))
	  {
	    strcpy(msgbuf,"Data form: v..  Adjoin circle to each "
		   "v and its clockwise neighbor."); 
	    emsg();return 1;
	  }
	sprintf(buf,"add_circle %s",datastr);
	break;
      }
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* handle_add_proc */

int handle_remove_proc(Menu menu,Menu_item menuitem)
{
  int v1,v2,act=(int) xv_get(menuitem,MENU_VALUE);

  switch (act)
    {
    case 1: /* remove bdry circle */
      {
	if (!strlen(datastr=get_selection(1)))
	  {
	    strcpy(msgbuf,"Data form: v. You must select a bdry vertex.");
	    emsg();return 1;
	  }
	sprintf(buf,"rm_cir %s",datastr);
	if (!handle_cmd(buf,&current_p))
	  {
	    strcpy(msgbuf,"Something went wrong removing bdry circle.");
	    emsg();
	  }
	return 1;
      }
    case 2: /* remove edge between bdry verts */
      {
	if (!strlen(datastr=get_selection(1)) 
	    || sscanf(datastr,"%d%d",&v1,&v2)!=2)
	  {strcpy(msgbuf,"you must select end verts of edge");emsg();}
	sprintf(buf,"rm_edge %d %d",v1,v2);
	if (handle_cmd(buf,&current_p))
	  {
	    sprintf(msgbuf,"REMOVED edge from %d to %d; p=%d",
		    v1,v2,current_p);
	    msg();
	    handle_cmd("Fix",&current_p);
	  }
	else 
	  {
	    strcpy(msgbuf,"Something went wrong removing edge.");
	    emsg();
	  }
	return 1;
      }
    } /* end of switch */
  return 1;
} /* handle_remove_proc */

/* ------------------------ */

int inquiry_proc(Panel_item item,Event *event)
     /*inquiry_menu acts. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(inquiry_menu,panel,event,0);return 1;}

int handle_inquiry_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE),code=1;

  if (!strlen(datastr=get_selection(1))) *datastr='\0';
  switch (act) {
  case 1: {code=1;break;} /* ?pack */
  case 2: {code=2;break;} /* ?vert */
  case 4: {code=20;break;} /* ?screen */
  case 5: {code=21;break;} } /* ?param */
  return (print_inq_data(&packdata[current_p],code,datastr));
} /* handle_inquiry_proc */

int handle_sel_inq_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!strlen(datastr=get_selection(1))) *datastr='\0';
  return (print_inq_data(&packdata[current_p],act+6,datastr));
} /* handle_sel_inq_proc */

int handle_spec_inq_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!strlen(datastr=get_selection(1))) *datastr='\0';
  return (print_inq_data(&packdata[current_p],act+24,datastr));
} /* handle_spec_inq_proc */

/* ------------------------ */

/* sel_print_proc is in `postp.c' */

int misc_proc(Panel_item item,Event *event)
     /* misc_menu actions. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(misc_menu,panel,event,0);return 1;}

int handle_misc_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!packdata[current_p].status)
    {
      sprintf(msgbuf,"Pack %d is empty.",current_p);
      emsg();return 1;
    }
  switch (act)
    {
    case 4: /* converts eucl to sph data */
      {sprintf(buf,"geom_to_s");break;}
    case 5: /* converts hyp to eucl data */
      {sprintf(buf,"geom_to_e");break;}
    case 6: /* converts hyp to hyp data */
      {sprintf(buf,"geom_to_h");break;}
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* misc_proc */

int handle_repack_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!packdata[current_p].status)
    {
      sprintf(msgbuf,"Pack %d is empty.",current_p);
      emsg();
      return 1;
    }
  switch (act)
    {
    case 2: /* adjust radii at selected (or active) nodes. */
      {
	if (!strlen(datastr = get_selection(1)))
	  {
	    strcpy(msgbuf,"Data form: v.. list of nodes.");
	    emsg();
	    return 1;
	  }
	sprintf(buf,"repack -v %s",datastr);
	break;
      } 
    default: /* repack, n passes. */
      {sprintf(buf,"repack %s",get_selection(0));break;}
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* handle_repack_proc */

int handle_fix_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!packdata[current_p].status)
    {
      sprintf(msgbuf,"Pack %d is empty.",current_p);
      emsg();
      return 1;
    }
  switch (act)
    {
    case 2: sprintf(buf,"fix -s");break; /* ang sums */
    case 3: sprintf(buf,"fix -c");break; /* centers */
    case 4: sprintf(buf,"fix -a");break; /* aims */
    case 5: sprintf(buf,"fix -K");break; /* combinatorics */
    case 6: sprintf(buf,"Fix");break;
    default: sprintf(buf,"fix");break;
    }
  return (handle_cmd(buf,&current_p));
} /* handle_fix_proc */

int handle_mob_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);
  double angle;
  complex cent;

  if (!packdata[current_p].status)
    {
      sprintf(msgbuf,"Pack %d is empty.",current_p);
      emsg();
      return 1;
    }
  switch (act)
    {
    case 1: /* apply Mobius to put vert v (or active) at origin */
      {
	if (strlen(datastr = get_selection(0)) > 4)
	  {
	    strcpy(msgbuf,"Data form: v. Select vertex "
		   "(default is the active vertex).");
	    emsg();
	    return 1;
	  }
	sprintf(buf,"center_vert %s",datastr);
	if (!handle_cmd(buf,&current_p)) 
	  {strcpy(msgbuf,"Mobius move failed.");emsg();}
	return 1;
      }
    case 2: /* apply Mobius to put selected pt at origin */
      {
	if (!strlen(datastr = get_selection(0)) 
	    || sscanf(datastr,"%lf %lf",&cent.re,&cent.im)!=2)
	  {
	    strcpy(msgbuf,"You must select real and imaginary parts."); 
	    emsg();
	    return 1;
	  }
	sprintf(buf,"center_point %s",datastr);
	if (!handle_cmd(buf,&current_p)) 
	  {strcpy(msgbuf,"Mobius move failed.");emsg();}
	return 1;
      }
    case 3: /* rotate by angle */
      {
	if (!strlen(datastr = get_selection(1))
	    || sscanf(datastr,"%lf",&angle)!=1)
	  {
	    strcpy(msgbuf,"You must select rotation angle."); 
	    emsg();
	    return 1;
	  }
	angle *= M_PI;
	sprintf(buf,"rotate %f",angle);
	if (!handle_cmd(buf,&current_p)) 
	  {strcpy(msgbuf,"Rotate operation failed.");emsg();}
	return 1;
      }
    case 4: /* apply Mob */
      {
	if (!strlen(datastr = get_selection(0)))
	  {
	    strcpy(msgbuf,"Data: v.. select vertices"); 
	    emsg();
	    return 1;
	  }
	sprintf(buf,"Mobius %s",datastr);
	return (handle_cmd(buf,&current_p)); 
      }
    case 5: /* apply Mob inverse */
      {
	if (!strlen(datastr = get_selection(0)))
	  {
	    strcpy(msgbuf,"Data: v.. select vertices"); 
	    emsg();
	    return 1;
	  }
	sprintf(buf,"Mobius_inv %s",datastr);
	return (handle_cmd(buf,&current_p)); 
      }
    } /* end of switch */
  return 1;
} /* handle_mob_proc */

/* ------------------------ */

int special_proc(Panel_item item,Event *event)
     /* special_menu acts. These routines are in 'specialp.c' so 
they can be changed easily. */
{if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(special_menu,panel,event,0);return 1;}

int handle_special_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (act>7) return 1; /* inactive routines */
  if (!strlen(datastr = get_selection(0))) *datastr='\0';
  sprintf(buf,"special%d %s",act,datastr);
  return (handle_cmd(buf,&current_p));
} /* special_proc */

/* ------------------------ */

int color_proc(Panel_item item,Event *event)
     /* color choices */
{ if (event_action(event)==ACTION_MENU && event_is_down(event))
  menu_show(color_menu,panel,event,0);return 1;}

int handle_cir_color_proc(Menu menu,Menu_item menuitem)
{
  int act = xv_get(menuitem,MENU_VALUE);

  if (!strlen(datastr=get_selection(1))) *datastr='\0';
  switch(act)
    {
    case 1: 
      color_circles(&packdata[current_p],5,datastr); return 1; /* foreground */
    case 2: 
      color_circles(&packdata[current_p],4,datastr); return 1; /* background */
    case 3: 
      color_circles(&packdata[current_p],1,datastr); return 1; /* radii */
    case 4: 
      color_circles(&packdata[current_p],3,datastr); return 1; /* comp to q */
    case 5: 
      color_circles(&packdata[current_p],6,datastr); return 1; /* code,list */
    case 6:
      color_circles(&packdata[current_p],7,datastr); return 1; /* copy */
    case 7:
      color_circles(&packdata[current_p],8,datastr); return 1; /* model curv */
    }
  return 1;
} /* handle_cir_color_proc */

int handle_face_color_proc(Menu menu,Menu_item menuitem)
{
  int act = xv_get(menuitem,MENU_VALUE);

  if (!strlen(datastr=get_selection(1))) *datastr='\0';
  switch(act)
    {
    case 1: 
      color_faces(&packdata[current_p],5,datastr); return 1; /* foreground */
    case 2: 
      color_faces(&packdata[current_p],4,datastr); return 1; /* background */
    case 3: 
      color_faces(&packdata[current_p],1,datastr); return 1; /* area */
    case 4: 
      color_faces(&packdata[current_p],3,datastr); return 1; /* comp to q */
    case 5: 
      color_faces(&packdata[current_p],6,datastr); return 1; /* col code,list */
    case 6:
      color_faces(&packdata[current_p],7,datastr); return 1; /* copy */
    }
  return 1;
} /* handle_cir_color_proc */

/* --------------- beginning of procedures from parameter panel */

int factor_inc_proc(Panel_item item,int value,Event *event)
     /* change value of factor using slider. inc_factor should lie 
between 1 and 2. */
{double v=.01*value,l=log(2.0);inc_factor=exp(v*l);return 1;} 

int eucl_factor_proc(Panel_item item,int value,Event *event)
     /* change value of Euclidean scaling factor using slider */
{eucl_factor=value*.01;return 1;} 

int fill_pattern_proc(Panel_item item,int value,Event *event)
     /* sets fill pattern for mono */
{
  fill_mode=value;
  switch (value)
    {
    case 0: /* grey (default) */
      XSetFillStyle(display,gc_fill,FillStippled);return 1;
    case 1: /* white */
      XSetFillStyle(display,gc_fill,FillSolid);return 1;

    } /* end of switch */
  panel_set(fill_pattern,PANEL_VALUE,value,0);
  return 1;
} /* fill_pattern_proc */

/* -----------  end of procedures from parameter panel */

int active_p_proc(Panel_item item,int value,Event *event)
     /* changes current pack */
{ chg_active_pack(value);return 1;}

int chg_active_pack(int pnum)
     /* change active pack to pnum */
{
  if (pnum==current_p) return 1;
  if (!cmd_mode && (int)xv_get(canvas_frame[pnum],WIN_SHOW))
    {
      xv_set(canvas_frame[pnum],WIN_SHOW,TRUE,0);
      set_cursor(&screendata[current_p],screendata[current_p].ms_flag);
    }
  live_node[current_p]=live_face[current_p]=0;
  current_p=pnum;
  if (!cmd_mode) 
    {
      xv_set(active_pack_item,PANEL_VALUE,current_p,0);
      set_cursor(&screendata[current_p],screendata[current_p].ms_flag);
    }
  return 1;
} /* chg_active_pack */

int pack_num(struct p_data *p)
     /* return pack number from pointer */
{int i;for (i=0;i<NUM_PACKS;i++) if (&packdata[i]==p) return i;return 0;}

int screen_num(struct s_data *q)
     /* return screen number from pointer */
{int i;for (i=0;i<NUM_PACKS;i++) if (&screendata[i]==q) return i;return 0;}


/* ================ notify procedures for setting parameters ======*/

int param_proc(Panel_item item,Event *event)
     /* param_menu setting.*/
{
  if (event_action(event)==ACTION_MENU && event_is_down(event))
    menu_show(param_menu,setup_frame,event,0);
  return 1;
} /* param_proc */

int handle_param_proc(Menu menu,Menu_item menuitem)
{
  int act=(int) xv_get(menuitem,MENU_VALUE);

  if (!strlen(datastr=get_selection(1))) return 1;
  switch (act)
    {
    case 1: sprintf(buf,"set_cycle %s",datastr);break;
    case 2: sprintf(buf,"set_accur %s",datastr);break;
    case 3: sprintf(buf,"set_toler %s",datastr);break;
    case 4: sprintf(buf,"set_err %s",datastr);break;
    case 5: sprintf(buf,"set_iter %s",datastr);break;
    case 6: sprintf(buf,"set_post_size %s",datastr);break;
    case 7: sprintf(buf,"set_brush %s",datastr);break;
    default: return 1;
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
}

int close_setup_proc(Panel_item item,Event *event)
{xv_set(setup_frame,WIN_SHOW,FALSE,0);return 1;}
	
int canvas_life(int pnum,int act)
     /* open/close canvas number pnum if act=1/0. Assume screen not
yet open and pack is active. */
{
  switch (act)
    {
    case 0: /* close */
      {
	xv_set(screen_frame[pnum],WIN_SHOW,FALSE,0);
	panel_set(manip_item[pnum],PANEL_VALUE,0,0);
	xv_set(manip_frame[pnum],FRAME_CMD_PIN_STATE,FRAME_CMD_PIN_OUT,
	       WIN_SHOW,FALSE,0);
	xv_set(canvas_frame[pnum],WIN_SHOW,FALSE,0);
	screendata[pnum].ms_flag=live_node[pnum]=live_face[pnum]=0;
	Flush();
	break;
      }
    case 1: /* open canvas */
      {
	xv_set(canvas_frame[pnum],WIN_SHOW,TRUE,0);
	screendata[pnum].ms_flag=live_node[pnum]=live_face[pnum]=0;
	break;
      }
    } /* end of switch */
  return 1;
} /* canvas_life */

int screen_toggles_proc(Panel_item item,int value,Event *event)
{
  int i,snum=-1;

  for (i=0;i<NUM_PACKS;i++) if (item==u_cir_flag[i]) {snum=i;break;}
  if (snum<0) return 1;
  if (value==0) screendata[snum].unitcircle=1;
  else screendata[snum].unitcircle=0;
  return 1;
} /* screen_toggles_proc */

int screen_coord_proc(Panel_item item,int value,Event *event)
{
  int i,snum=-1;

  for (i=0;i<NUM_PACKS;i++) if (item==coord_flag[i]) {snum=i;break;}
  if (snum<0) return 1;
  if (value==0) screendata[snum].coord_flag=0;
  else screendata[snum].coord_flag=1;
  return 1;
} /* screen_coord_proc */

int reset_proc(Panel_item item,Event *event)
{
  int i,pnum=-1;

  for (i=0;i<NUM_PACKS;i++) if (item==rset[i]) {pnum=i;break;}
  if (pnum<0) return 1;
  reset_screen(packdata[pnum].screen);
  return 1;
} /* reset_proc */

int close_popup_proc(Panel_item item,Event *event)
{
  int i,snum=-1;

  for (i=0;i<NUM_PACKS;i++) if (item==clsup[i]) {snum=i;break;}
  if (snum<0) return 1;
  xv_set(screen_frame[snum],WIN_SHOW,FALSE,0);
  return 1;
}

int screen_factor_proc(Panel_item item,int value,Event *event)
     /* sets factor for screen resizing - larger factor 
means smaller picture (more on screen)*/
{
  double v=.01*value,l=log(2.0);
  int i,pnum=-1;

  for (i=0;i<NUM_PACKS;i++) if (item==sfac[i]) {pnum=i;break;}
  if (pnum<0) return 1;
  screendata[pnum].factor = exp((-v)*l);
  return 1;
}  /* screen_factor_proc */

int screen_size_proc(Panel_item item,Event *event)
     /* screen resizing based on current factor; keeps center fixed. */
{
  double hx,hy,cx,cy,factor;
  int i,snum=-1;
  struct s_data *q;

  for (i=0;i<NUM_PACKS;i++) if (item==ssize[i]) {snum=i;break;}
  if (snum<0) return 1;
  q=&screendata[snum];
  factor=q->factor;
  cx=(q->box.lx+q->box.rx)*0.5; 
  cy=(q->box.ly+q->box.ry)*0.5;
  hx=(q->box.rx-q->box.lx)*factor*0.5; 
  hy=(q->box.ry-q->box.ly)*factor*0.5;
  q->box.lx =cx-hx;
  q->box.rx =cx+hx;
  q->box.ly =cy-hy;
  q->box.ry =cy+hy;
  return 1;
} /* screen_size_proc */

int screen_c_proc(Panel_item item,Event *event)
     /* for centering screen on vertex number or given point */
{
  int i,pnum=-1;

  if (event_action(event)==ACTION_MENU && event_is_down(event))
    {
      for (i=0;i<NUM_PACKS;i++) if (item==scent[i]) {pnum=i;break;}
      if (pnum<0) return 1;
      canv1=pnum;
      menu_show(screen_c_menu,screen_frame[pnum],event,0);
    }
  return 1;
}

int handle_c_menu_proc(Menu menu,Menu_item menuitem)
     /* for centering screen */
{
  int act=(int)xv_get(menuitem,MENU_VALUE),v,pnum;
  struct p_data *p;
	
  pnum=canv1;
  p=&packdata[pnum];
  switch (act)
    {
    case 1:  /* have selected vertex number, else use active node */
      {
	if (( 
	     (strlen(datastr = get_selection(0)) && sscanf(datastr,"%d",&v)) 
	     || (v=p->active_node)
	     )
	    && v>0 && v<=p->nodecount 
	    )
	  {
	    sprintf(buf,"focus -v %d",v);
	    return (handle_cmd(buf,&pnum));
	  }
      }
    case 2: /* select real and imaginary parts for center */
      /* fixup: selection service hasn't been working for years. */
      {
	if (!strlen(datastr = get_selection(1)))
	  {
	    strcpy(msgbuf,"You must select real and imaginary parts."); 
	    emsg();
	    return 1;
	  }
      }
    } /* end of switch */
  return 1;
} /* handle_c_menu_proc */
	
int s_display_proc(Panel_item item,Event *event)
{
  int i,pnum=-1;
	
  for (i=0;i<NUM_PACKS;i++) if (item==sdp[i]) {pnum=i;break;}
  if (pnum<0) return 1;
  clear_canvas(&screendata[pnum]);
  disp_screen(&packdata[pnum],
	      packdata[pnum].screen->cflag_opt,
	      packdata[pnum].screen->fflag_opt,0);
  return 1;
} /* s_display_proc */

int base_resize_proc(Window window,Event *event,Notify_arg arg)
{ 
  Rect rect;

  if (event_action(event)!=WIN_RESIZE) return 1;
  frame_get_rect(base_frame,&rect);
  rect.r_top+=xv_get(base_frame,XV_HEIGHT)+5;
  rect.r_width=(short)xv_get(base_frame,XV_WIDTH);
  /*	xv_set(cmd_frame,
	WIN_X,(int)rect.r_left,
	WIN_Y,(int)rect.r_top,
	XV_WIDTH,(int)rect.r_width,
	XV_HEIGHT,30,
	0);
  */
  return 1;
} /* base_resize_proc */	

int canvas_s_proc(Window window,Event *event,Notify_arg arg)
{ 
  int i,snum=-1,width,height;
  double midpt,halfwidth;
  struct s_data *q;

  if (event_action(event)!=WIN_RESIZE) return 1; 
  /* ?? catches too many events ?? */
  for (i=0;i<NUM_PACKS;i++) if (window==canvas_frame[i]) {snum=i; break;}
  if (snum<0) return 1;
  q=&screendata[snum];
  if ((width=(int)xv_get(window,XV_WIDTH))<100) width=100;
  if (width>MAX_PIXEL) width=MAX_PIXEL;
  if ((height=(int)xv_get(window,XV_HEIGHT))<100) height=100;
  if (height>MAX_PIXEL) height=MAX_PIXEL;
  if (q->pix_box.rx!=width 
      || q->pix_box.ry!=height)
    {
      SetForeground(bgcolor,0);
      FillRectangle(q->xpm,0,0,MAX_PIXEL,MAX_PIXEL); /* clear canvas */
      SetForeground(fgcolor,0);
      q->pix_box.rx=width; q->pix_box.ry=height;
      /* keep same center, same real height; adjust real width */
      midpt=(q->box.lx+q->box.rx)/2;
      halfwidth=(q->box.ry-q->box.ly)
	*width/height/2.0;
      q->box.lx=midpt-halfwidth;
      q->box.rx=midpt+halfwidth;
      display_call(&packdata[snum]," ");
    }
  return 1;
} /* canvas_s_proc */

int cl_pr_proc(Frame c_frame)
{ 
  int i,pnum=-1;

  for (i=0;i<NUM_PACKS;i++) if (c_frame==canvas_frame[i]) {pnum=i; break;}
  if (pnum<0) return 1; 
  canvas_life(pnum,0);
  return 1;
} /* cl_pr_proc */

int canvas_num1(Canvas canv)
     /* returns number of canvas, 0 to NUM_PACKS-1 */
{int i;for (i=0;i<NUM_PACKS;i++) if (canv==canvas[i]) return i;return -1;}

int canv_paint_num(Canvas canv)
     /* returns number of canvas_paint_window, 0-3 */
{int i;for (i=0;i<NUM_PACKS;i++) if (canv==canvas_paint_window(canvas[i])) 
  return i;
 return -1;
} /* canvas_paint_num */

int canvas_repaint_proc(Canvas canvas,Xv_Window pw,Display *display,
			Window xid,Xv_xrectlist *xrects)
{
  int h,w;
  struct s_data *q;

  q=packdata[canvas_num1(canvas)].screen;
  w=q->pix_box.rx-q->pix_box.lx;
  h=q->pix_box.ry-q->pix_box.ly;
  XCopyArea(display,q->xpm,xid,gc,0,0,w,h,0,0);
  Flush();
  return 1;
}

int scr_popup_proc(Menu menu,Menu_item menuitem)
{
  int snum=canv1;

  if (!packdata[snum].status) 
    {sprintf(msgbuf,"pack %d is empty",snum);emsg();return 1;}
  if (screen_frame[snum])
    xv_set(screen_frame[snum],WIN_SHOW,TRUE,0);
  return 1;
} /* scr_popup_proc */

int cir_com_proc(Menu menu,Menu_item menuitem)
     /* display open circles and complex */
{
  int snum=canv1;

  if (!packdata[snum ].status) 
    {sprintf(msgbuf,"pack %d is empty",snum);emsg();return 1;}
  screendata[snum].cflag_opt=screendata[snum].fflag_opt=1;
  sprintf(buf,"disp -p%d ",snum);
  return (handle_cmd(buf,&current_p));
} /* cir_com_proc */

int clr_proc(Menu menu,Menu_item menuitem)
{
  int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

  if (!packdata[snum].status) 
    {sprintf(msgbuf,"pack %d is empty",snum);emsg();return 1;}
  sprintf(buf,"disp -p%d -w",snum);
  handle_cmd(buf,&current_p);
  if (act==2) return 1;
  sprintf(buf,"disp -p%d ",snum);
  return (handle_cmd(buf,&current_p));
} /* clr_proc */

int circles_ofs_proc(Menu menu,Menu_item menuitem)
{
  int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

  if (!packdata[snum].status) 
    {sprintf(msgbuf,"pack %d is empty",snum);emsg();return 1;}
  switch (act)
    {
    case 1:
      { 
	screendata[snum].cflag_opt=1; /*open circles*/
	screendata[snum].fflag_opt=0;
	sprintf(buf,"disp -p%d",snum);break;
      }
    case 2: 
      {
	screendata[snum].cflag_opt=3; /*filled circles*/
	screendata[snum].fflag_opt=0;
	sprintf(buf,"disp -p%d",snum);break;
      }
    case 3: 
      {
	if (!strlen(datastr=get_selection(0)))
	  {strcpy(msgbuf,"You must select vertex numbers. ");
	  emsg();return 1;}
	sprintf(buf,"disp -p%d -cf %s",snum,datastr);
	break;
      }
    case 4: {sprintf(buf,"disp -p%d -cf m",snum);break;} /* marked circles */
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* circles_ofs_proc */

int complex_ofs_proc(Menu menu,Menu_item menuitem)
{
  int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

  if (!packdata[snum].status) 
    {sprintf(msgbuf,"pack %d is empty",snum);emsg();return 1;}
  switch (act)
    {
    case 1: 
      {
	screendata[snum].fflag_opt=1; /*open complex*/
	screendata[snum].cflag_opt=0;
	sprintf(buf,"disp -p%d",snum);break;
      }
    case 2:
      {
	screendata[snum].fflag_opt=3; /*filled complex*/
	screendata[snum].cflag_opt=0;
	sprintf(buf,"disp -p%d",snum);break;
      }
    case 3: 
      {
	if (!strlen(datastr=get_selection(0)))
	  {strcpy(msgbuf,"You must select face indices.");emsg();return 1;}
	sprintf(buf,"disp -p%d -ff %s",snum,datastr);
	break;
      }
    case 4: {sprintf(buf,"disp -p%d -ff m",snum);break;} /* marked faces */
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* complex_ofs_proc */

int label_proc(Menu menu,Menu_item menuitem)
{
  int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);
  char *header;

  if (!packdata[snum].status) 
    {sprintf(msgbuf,"Pack %d is empty",snum);emsg();return 1;}
  switch (act)
    {
    case 1: /* label circles */
      sprintf(buf,"disp -p%d -nc",snum);break;
    case 2: /* label faces */
      sprintf(buf,"disp -p%d -nf",snum);break;
    case 3: /* caption */
      {
	if (!strlen(header=get_selection(0)))
	  {
	    strcpy(msgbuf,"You must select the desired caption. ");
	    emsg();return 1;
	  }
	sprintf(buf,"disp -p%d -t %s",snum,header);
      }
    } /* end of switch */
  return (handle_cmd(buf,&current_p));
} /* label_proc */

int output_proc(Menu menu,Menu_item menuitem)
{
  int snum=canv1,act=(int)xv_get(menuitem,MENU_VALUE);

  if (!packdata[snum].status) 
    {sprintf(msgbuf,"pack %d is empty",snum);emsg();return 1;}
  switch (act)
    {
    case 2: {sprintf(buf,"print -p%d",snum); 
    handle_cmd(buf,&current_p);
    break; }
    } /* end of switch */
  return 1;
} /* output_proc */

int canvas_evt(Canvas canv,Event *event)
     /* handle mouse events in canvas  */
{
  int count,snum=canv_paint_num(canv),node,i1,i2,newnode,sflag;
  int face,w1=0,w2=0,k,colr,i,cflag,fflag,v,n0,indx,front;
  double a;
  char named_cmd[31],buff[12];
  complex comppt,sph_pt;
  XPoint *Xptr;
  struct Pathlist *trace,*newspot;
  struct Vertlist *vtrace,*nodelist=NULL,*vvtrace;
  struct Edgelist *flip_flag;
  struct p_data *p;
  struct s_data *q;
  struct K_data *pK_ptr;
  
  canv1=snum;	
  p=&packdata[snum];
  q=p->screen;
  sflag=p->screen->ms_flag;
  cflag=packdata[current_p].screen->cflag_opt;
  fflag=packdata[current_p].screen->fflag_opt;
  
  switch (event_id(event)) /* switch on event from canvas menu */
    {

      /*=============== RIGHT BUTTON =====================*/

    case MS_RIGHT:
      {
	if (!p->status) return 1;
	if ((b_flip || r_flip) 
	    && event_right_is_down(event)) /* abandon flip */
	  {
	    free(b_flip);free(r_flip);b_flip=r_flip=NULL;
	    return 1;
	  }
	menu_show(disp_opt_menu,canvas[snum],event,0);
	break;
      }

      /*=============== MIDDLE BUTTON =====================*/

    case MS_MIDDLE:
      {
	if ( event_middle_is_down(event) && sflag==0 && /* display faces */
	     (nodelist=tri_search(p,(int)event->ie_locx,
	       (int)event->ie_locy)) ) 
	  {
	    vtrace=nodelist;
	    do
	      {
		node=vtrace->v; 
		vtrace=vtrace->next;
		/* draw filled face */
		draw_any_face(p,node,fflag | 3,FG_COLOR,
			      p->faces[node].color,1);
		/* put index in scratch window */
		if (p->faces[node].plot_flag)
		  {
		    sprintf(msgbuf," %d ",node);
		    smsg();
		    /* if 'shift', then mark face */
		    if (event_shift_is_down(event)) 
		      p->faces[node].mark++;
		    /* if pressing 'v', then add verts to pack vlist */
		    if (list_ready) 
		      {
			if (!p->flist) 
			  {
			    p->flist=(struct Vertlist *)
			      calloc(1,sizeof(struct Vertlist));
			    p->flist->v=node;
			  }
			else
			  {
			    vvtrace=p->flist;
			    while (vvtrace->next) vvtrace=vvtrace->next;
			    vvtrace->next=(struct Vertlist *)
			      calloc(1,sizeof(struct Vertlist));
			    vvtrace->v=node;
			  }
		      }
		  }
	      } /* end of do */
	    while (vtrace!=NULL);
	    vert_free(&nodelist);
	  }
	else if (event_middle_is_down(event) && sflag==9 /* projection mode */
		 && (nodelist=tri_search(p,(int)event->ie_locx,
					 (int)event->ie_locy)) ) 
	  while (nodelist!=NULL) /* just use first acceptable face */
	    {
	      if (nodelist->v != live_face[snum]) 
		{
		  vert_free(&(nodelist->next));  /* use only one */
		  draw_any_face(p,nodelist->v,fflag | 19,FG_COLOR,FG_COLOR,1);
		  if (snum!=current_p) live_face[snum]=nodelist->v;
		  if (p->vertex_map) /* draw if translation exists */
		    {
		      if ((i=face_translation(p,nodelist->v,
					      &packdata[current_p])))
			{
			  nodelist->v=i;
			  if ((i=layout_facelist(&packdata[current_p],
						 fflag | 19,&nodelist,1,
						 live_face[current_p],SHOW)))
			    live_face[current_p]=i;
			}
		    }
		  else if ((i=layout_facelist(&packdata[current_p],
					      fflag | 19,&nodelist,1,
					      live_face[current_p],SHOW)))
		    live_face[current_p]=i;
		}
	      else /* throw this entry away */
		{
		  vtrace=nodelist;
		  nodelist=nodelist->next;
		  free(vtrace);
		}
	    } /* end of while */
	else if (event_middle_is_down(event) && sflag==2 /* add/enfold mode */
		 && (nodelist=cir_search(p,(int)event->ie_locx,
					 (int)event->ie_locy)) )
	  {
	    /* note: in add/enfold mode, middle button enfolds, left adds.*/
	    node=nodelist->v;
	    vert_free(&nodelist);
	    sprintf(buf,"enclose -p%d 0 %d",snum,node);
	    if (handle_cmd(buf,&current_p))
	      {
		i1=p->packK_ptr[node].flower[0];
		i2=p->packK_ptr[node].
		  flower[p->packK_ptr[node].num-1];
		draw_edge(p,i1,i2,FG_COLOR,1);
	      }
	  }
	break;
      }


      /*=============== LEFT BUTTON =====================*/

    case MS_LEFT:
      {
	if (!sflag && (b_flip || r_flip) 
	    && event_left_is_down(event)) /* select verts for 
					   Whitehead moves */
	  {
	    pK_ptr=p->packK_ptr;
	    if ((nodelist=cir_search(p,
		   (int)event->ie_locx,(int)event->ie_locy)) )
	      {
		if (b_flip) {flip_flag=b_flip;colr=60;}
		else {flip_flag=r_flip;colr=180;}
				/* which flag? */
		if (!flip_flag->v) /* selecting first vert */
		  {
		    flip_flag->v=nodelist->v;
		    vert_free(&nodelist);
		    return 1;
		  }
		else if (!flip_flag->w) /* selecting second vert */
		  {
		    flip_flag->w=nodelist->v;
		    vert_free(&nodelist);
		    if ((k=nghb(p,flip_flag->v,flip_flag->w))<0
			|| (pK_ptr[flip_flag->v].bdry_flag
			    && pK_ptr[flip_flag->w].bdry_flag) )
		      {flip_flag->w=0;return 1;}
		    /* find common nghbs */
		    if (!pK_ptr[flip_flag->v].bdry_flag 
			|| k<pK_ptr[flip_flag->v].num)
		      w1=pK_ptr[flip_flag->v].flower[k+1];
		    if ((k=nghb(p,flip_flag->w,flip_flag->v))
			<pK_ptr[flip_flag->w].num
			|| !pK_ptr[flip_flag->w].bdry_flag)
		      w2=pK_ptr[flip_flag->w].flower[k+1];
		    /* color and mark */
		    pK_ptr[flip_flag->v].color
		      =pK_ptr[flip_flag->w].color
		      =pK_ptr[w1].color=pK_ptr[w2].color=colr;
		    pK_ptr[flip_flag->v].mark
		      =pK_ptr[flip_flag->w].mark
		      =pK_ptr[w1].mark=pK_ptr[w2].mark=1;
		    /* execute commands */
		    sprintf(buf,"flip -p%d %d %d",
			    snum,flip_flag->v,flip_flag->w);
		    handle_cmd(buf,&current_p);
		    sprintf(buf,"mark -p%d -cw {c: d == 6}",snum);
		    handle_cmd(buf,&current_p);
		    if ((p->euler==1 || p->euler==2) 
			&& p->genus==0) /* simply connected */
		      {
			sprintf(buf,"repack -p%d",snum);
			handle_cmd(buf,&current_p);
			sprintf(buf,"fix -p%d",snum);
			handle_cmd(buf,&current_p);
			sprintf(buf,"disp -p%d -w -cf m -f",snum);
			handle_cmd(buf,&current_p);
		      }
		    else
		      {
			sprintf(buf,"disp -p%d -w -c -cf m",snum);
			handle_cmd(buf,&current_p);
		      }
		  }
	      }
	    /* abandon selection process */
	    free(b_flip);free(r_flip);b_flip=r_flip=NULL;
	    return 1;
	  }
	if (sflag==8) /* add to path */
	  {
	    pix_to_r((int)event->ie_locx,(int)event->ie_locy,
		     &comppt,q->pix_box,q->box);
	    newspot=(struct Pathlist *)calloc(1,
					      sizeof(struct Pathlist));
	    newspot->x=comppt.re;newspot->y=comppt.im;
	    if (newpath==NULL) {newpath=newspot; return 1;}
	    else
	      {
		count=2;
		trace=newpath;
		while (trace->next!=NULL) 
		  {
		    trace=trace->next;
		    count++;
		  }
		if (fabs(trace->x-newspot->x)>okerr
		    || fabs(trace->y-newspot->y)>okerr)
		  trace->next=newspot;
	      }
	    Xptr=path_XPoints(q,newpath,&count);
	    DrawLines(q->xid,Xptr,count,fgcolor);
	    DrawLines(q->xpm,Xptr,count,fgcolor);
	    free(Xptr);
	    return 1;
	  }		
	if (sflag==5 && event_left_is_down(event)) 
	  /* determine coords of cursor */
	  {
	    pix_to_r((int)event->ie_locx,(int)event->ie_locy,
		     &comppt,q->pix_box,q->box);
	    if (p->hes>0) /* if the sphere, print (theta/phi)
			     coords (plus usual x,y) */
	      {
		if ((a=comppt.re*comppt.re+comppt.im*comppt.im)>=1.0)
		  /* point not on sphere */
		  {
		    sprintf(msgbuf,"\nPoint not on sphere.\n (x y) = %f %f ",
			    comppt.re,comppt.im);
		  }
		else
		  {
		    sph_pt=proj_vec_to_sph(sqrt(1.0-a),comppt.re,comppt.im);
		    sph_pt=ss_view(q,sph_pt,-1,&front);
		    sprintf(msgbuf,"\n (theta phi) = (%f %f)\n (x y) = %f %f ",
			    sph_pt.re,sph_pt.im, comppt.re,comppt.im);
		  }
	      }
	    else sprintf(msgbuf,"\n (x y) = %f %f ",comppt.re,comppt.im); 
	           /* eucl/hyp */
	    smsg();
	    return 1;
	  }
	if ( event_left_is_down(event) && 
	     (nodelist=cir_search(p,(int)event->ie_locx,
		 (int)event->ie_locy)) ) 
	  {
	    vtrace=nodelist;
	    do
	      {
		node=vtrace->v; 
		vtrace=vtrace->next;
		switch (sflag) 
		  {
		  case 0: /* desensitized mouse */
		    {
		      p->active_node=node;
		      /* draw circle number */
		      draw_cir_number(p,node,node,1);
		      /* put index in scratch window */
		      sprintf(msgbuf," %d ",node);
		      smsg();
		      /* if 'shift', then mark face */
		      if (event_shift_is_down(event)) 
			p->packK_ptr[node].mark++;
		      /* if pressing 'v', then add verts to pack vlist */
		      if (list_ready) 
			{
			  if (!p->vlist) 
			    {
			      p->vlist=(struct Vertlist *)
				calloc(1,sizeof(struct Vertlist));
			      p->vlist->v=node;
			    }
			  else
			    {
			      vvtrace=p->vlist;
			      while (vvtrace->next) vvtrace=vvtrace->next;
			      vvtrace->next=(struct Vertlist *)
				calloc(1,sizeof(struct Vertlist));
			      vvtrace->v=node;
			    }
			}
		      break;
		    }
		  case 1: /* change size */
		    { /* not implemented yet */ break;}
		  case 2: /* add circle */
		    {
		      sprintf(buf,"add_circle -p%d %d",snum,node);
		      handle_cmd(buf,&current_p);
		      newnode=p->nodecount;
		      face=1;
		      while ( face<=p->facecount 
			      && (find_index(p,face,newnode)<0) )
			face++;
		      v=p->faces[face].vert[
			(indx=(p->faces[face].index_flag+2)%3)];
		      n0=nghb(p,v,p->faces[face].vert[(indx+1)%3]);
		      fancy_comp_center(p,v,n0,n0,1,0,1,1,toler);
		      p->packK_ptr[newnode].color=FG_COLOR;
		      draw_any_circle(p,newnode,1,FG_COLOR,FG_COLOR,1);
		      sprintf(buf,"disp -p%d -e ",snum);
		      for (i=0;i<p->packK_ptr[node].num;i++)
			{
			  sprintf(buff,"%d %d %d %d ",
				  node,p->packK_ptr[node].flower[i],
				  p->packK_ptr[node].flower[i],
				  p->packK_ptr[node].flower[i+1]);
			  strcat(buf,buff);
			}
		      sprintf(buff,"%d %d",node,
			p->packK_ptr[node].flower[p->packK_ptr[node].num]);
		      strcat(buf,buff);
		      handle_cmd(buf,&current_p);
		      break;
		    }
		  case 3: /* delete circle; only does first from the list. */
		    {
		      sprintf(buf,"rm_circle -p%d %d",snum,node);
		      if (handle_cmd(buf,&current_p))
			{
			  clear_canvas(q);
			  disp_screen(p,q->cflag_opt,q->fflag_opt,0);
			  sprintf(msgbuf,"Removed circle %d from "
				  "pack %d.",node,snum);
			  msg();
			}
		      vert_free(&nodelist);
		      return 1;
		    }
		  case 6: /* increment radius */
		    {
		      sprintf(buf,"inc_rad -p%d %d",snum,node);
		      handle_cmd(buf,&current_p);
		      draw_any_circle(p,node,1,FG_COLOR,FG_COLOR,1);
		      break;
		    }
		  case 7: /* decrement radius */
		    {
		      sprintf(buf,"dec_rad -p%d %d",snum,node);
		      handle_cmd(buf,&current_p);
		      draw_any_circle(p,node,1,FG_COLOR,FG_COLOR,1);
		      break;
		    }
		  case 9: /* draw circles */
		    {
		      if ( /* node!=live_node[snum] && */ node>0 
			   && node<=packdata[current_p].nodecount)
			{
			  draw_any_circle(p,node,3,FG_COLOR,FG_COLOR,1);
			  /* draw on domain canvas (q) */
			  if (p->vertex_map)
			    {
			      if ((i=vertex_translation(p->vertex_map,node)))
				draw_any_circle(&packdata[current_p],
				  i,cflag | 19,FG_COLOR,
				  packdata[current_p].packK_ptr[i].color,1);
			    }
			  else draw_any_circle(&packdata[current_p],
			       node,cflag | 19,FG_COLOR,
			       packdata[current_p].packK_ptr[node].color,1);
			  /* draw on range (projected) canvas (= active) */
			  live_node[snum]=node;
			}
		      break;
		    }			
		  } /* end of switch on ms_flag */
	      } /* end of do */
	    while (vtrace!=NULL);
	    vert_free(&nodelist);
	  } /* end of if */	
	break;	
      } /* end of MS_LEFT case */

      /*=============== DRAG =====================*/

    case LOC_DRAG:
      {
	if (sflag==8 && event_left_is_down(event)) 
	  /* add to path */
	  {
	    pix_to_r((int)event->ie_locx,(int)event->ie_locy,
		     &comppt,q->pix_box,q->box);
	    newspot=(struct Pathlist *)calloc(1,
					      sizeof(struct Pathlist));
	    newspot->x=comppt.re;newspot->y=comppt.im;
	    if (newpath==NULL) {newpath=newspot; return 1;}
	    else
	      {
		count=2;
		trace=newpath;
		while (trace->next!=NULL) 
		  {
		    trace=trace->next;
		    count++;
		  }
		trace->next=newspot;
	      }
	    Xptr=path_XPoints(q,newpath,&count);
	    DrawLines(q->xid,Xptr,count,fgcolor);
	    DrawLines(q->xpm,Xptr,count,fgcolor);
	    free(Xptr);
	    return 1;
	  }
	else if (sflag==9) 
	  {
	    if (event_middle_is_down(event) &&
		(nodelist=tri_search(p,(int)event->ie_locx,
				     (int)event->ie_locy)) 
		&& (node=nodelist->v) != live_face[snum]
		&& node<=packdata[current_p].facecount) 
	      {
		vert_free(&(nodelist->next));  /* use only one */
		draw_any_face(p,nodelist->v,3,FG_COLOR,FG_COLOR,1);
		live_face[snum]= layout_facelist(&packdata[current_p],
		  fflag | 19,&nodelist,1,live_face[snum],SHOW);
	      }
	    else if (event_left_is_down(event) &&
		     (nodelist=cir_search(p,(int)event->ie_locx,
		       (int)event->ie_locy)) && nodelist->v!=live_node[snum])
	      {
		vtrace=nodelist;
		do
		  {
		    node=vtrace->v;
		    if (node>0 && node<=packdata[current_p].nodecount)
		      {
			draw_any_circle(p,node,3,FG_COLOR,FG_COLOR,1);
			if (p->vertex_map)
			  {
			    if ((i=vertex_translation(p->vertex_map,node)))
			      draw_any_circle(&packdata[current_p],i,
				cflag | 19,FG_COLOR,
				packdata[current_p].packK_ptr[node].color,1);
			  }
			else draw_any_circle(&packdata[current_p],node,
			       cflag | 19,FG_COLOR,
			       packdata[current_p].packK_ptr[node].color,1);
			live_node[snum]=node;
		      }
		    vtrace=vtrace->next;
		  }
		while (vtrace!=NULL);
		vert_free(&nodelist);
	      }
	  }
	break;
      } /* end LOC_DRAG */

    } /* end of 'event' switch */

  /*========= keyboard events while canvas is focus ==============*/

  if ((event_id(event)>='A' && event_id(event)<='z')
      || (event_id(event)>='0' && event_id(event)<='9'))
    /* if upper/lower case letter or number is pressed */
    {
      if(event_is_up(event))  /* look in current script, execute 
				 first cmd with pressed key as
				 its full name (if there is one) */
	{
	  named_cmd[0]=event_id(event);
	  named_cmd[1]='\0';
	  if (!exe_named_cmd(named_cmd,&snum))
	    /* two special actions: Whitehead moves */
	    /* two players: b and r (blue and red). 
	       Pressing key when in canvas initiates 
	       Whitehead move; then two vertices are selected 
	       with LEFT_MOUSE to complete it */
	    {
	      if (event_id(event)=='B')
		{
		  if (r_flip) {free(r_flip);r_flip=NULL;}
		  if (b_flip) {free(b_flip);b_flip=NULL;}
		  b_flip=(struct Edgelist *)
		    calloc(1,sizeof(struct Edgelist));
		  b_flip->v=b_flip->w=0;
		}
	      else if (event_id(event)=='R')
		{
		  if (b_flip) {free(b_flip);b_flip=NULL;}
		  if (r_flip) {free(r_flip);r_flip=NULL;}
		  r_flip=(struct Edgelist *)
		    calloc(1,sizeof(struct Edgelist));
		  r_flip->v=r_flip->w=0;
		}
	      else if (event_id(event)=='v') /* make canvas sensative
						so vert/face numbers will 
						be added to vlist/flist. */
		{
		  if (list_ready) 
		    {
		      list_ready=0;
		      sprintf(msgbuf,"list sensitive = off");
		      msg();
		    }
		  else 
		    {
		      list_ready=1;
		      sprintf(msgbuf,"list sensitive = on");
		      msg();
		    }
		}
	      
	    }
	}
    }
  else if (event_is_up(event) && event_is_key_top(event) 
	   && event_id(event)>=KEY_TOP(1)
	   && event_id(event)<=KEY_TOP(10))
    {
      if (ftn_keys[event_id(event)-KEY_TOP(1)+1])
	sort_cmd(ftn_keys[event_id(event)-KEY_TOP(1)+1],&snum);
    }
  return 1;
} /* canvas_evt */



/* ======================== related routines =======================*/

int mark(struct p_data *p,int i)
     /* display node number of circle, make it the active_node. 
Repeating erases number. */
{
  int x,y;
  complex normpt;
  char num[8];

  sprintf(num,"%d",i);
  r_to_pix(p->packR_ptr[(p->active_node=i)].center,&normpt,
	   p->screen->pix_box,p->screen->box);
  x=(int)normpt.re;
  if (i>10) x -= 5;
  if (i>100) x -= 5; /* shift a little for better positioning */
  y=(int)normpt.im;
  /*	XSetFunction(display,gc,GXcopy);*/
  DrawString(p->screen->xid,x,y,num,strlen(num));
  /*	XSetFunction(display,gc,GXcopy);*/
  return 1;
} /* mark */
		
int manip_proc(Panel_item item,int value,Event *event)
     /* for manipulation menu */
{
  int snum=0,count;
  XPoint *Xptr;
  struct Pathlist *trace;
  struct p_data *p;
  struct s_data *q;

  /* ms_flag codes: 
     0 = desensitized mouse
     1 = changing size of circles (not yet implemented)
     2 = add/enfold at bdry circle
     3 = deleting bdry circle
     5 = crosshairs for coords 
     6 = increment radii
     7 = decrement radii
     8 = drawing path
     9 = projection mode
  */

  while (item!=manip_item[snum] && snum<NUM_PACKS) snum++;
  if (snum==NUM_PACKS) return 1;
  q=packdata[snum].screen;
  p=&packdata[snum];
	
  switch(value)
    {
    case 1: /* add/enfold circles */ {set_cursor(q,2);return 1;}
    case 3: /* delete circles */ {set_cursor(q,3);return 1;}
    case 4: /* increment radii */ {set_cursor(q,6);return 1;}
    case 5: /* decrement radii */ {set_cursor(q,7);return 1;}
    case 6:
    case 7: /* start path */
      {
	path_free(&newpath);
	/* display the alpha circle */
	draw_any_circle(p,p->alpha,3,FG_COLOR,FG_COLOR,1);
	set_cursor(q,8);
	return 1;
      }
    case 8: /* accept path and desensitize */
      {
	if (q->ms_flag!=8) return 1;
	if (newpath==NULL) break;
	count=1;
	trace=newpath;
	while (trace->next!=NULL) {trace=trace->next;count++;}
	if (count>=3)
	  {
	    if (trace->x!=newpath->x || trace->y!=newpath->y)
	      {
		trace->next=(struct Pathlist *)calloc
		  (1,sizeof(struct Pathlist));
		trace->next->x=newpath->x;
		trace->next->y=newpath->y;
		count++;
		Xptr=path_XPoints(q,newpath,&count);
		DrawLines(q->xid,Xptr,count,fgcolor);
		DrawLines(q->xpm,Xptr,count,fgcolor);
		free(Xptr);
	      } /* make sure path closes up */
	    path_free(&pathlist);
	    pathlist=newpath;
	    pathlength=count;
	  }
	newpath=NULL;
	break;
      } /* break to desensitize mouse */
    case 9: /* show coords */ {set_cursor(q,5);return 1;}
    case 10: /* project faces. ie, draw on active pack */
      {
	set_cursor(q,9);
	live_face[snum]=0;
	return 1;
      }
    } /* end of switch */

  /* desensitize mouse */

  set_cursor(q,0);
  live_node[snum]=live_face[snum]=0; 
  return 1;
} /* manip_proc */

int show_manip_frame_proc(Menu menu,Menu_item menuitem)
{  
  int x,y;
  Rect rect;

  frame_get_rect(canvas_frame[canv1],&rect);
  y=(int)rect.r_top;
  x=(int)(rect.r_left+rect.r_width+5);
  xv_set(manip_frame[canv1],WIN_X,x,WIN_Y,y,WIN_SHOW,TRUE,0);
  return 1;
} 

int ms_repack_proc(Menu menu,Menu_item menuitem)
{
  if (packdata[canv1].locks) return 1;
  riffle_call(&packdata[canv1],totalpasses,1,1);
  return (comp_pack_centers(&packdata[canv1],0,0,2,okerr));
}

int show_path_proc(Menu menu,Menu_item menuitem)
{
  sprintf(buf,"disp -p%d -g",canv1);
  return (handle_cmd(buf,&current_p));
}

int quicksave_proc(Menu menu,Menu_item menuitem)
{
  char filename[128],holdname[128];

  strcpy(holdname,packdata[canv1].file_name);
  set_packing_path();
  strcpy(filename,path);
  sprintf(buf,"tmp%d.p",canv1);
  strcat(filename,buf);
  if (open_and_write(&packdata[canv1],filename,0017))
    strcpy(packdata[canv1].file_name,holdname); 
  else {strcpy(msgbuf,"quicksave has failed.");emsg();}
  strcpy(packdata[canv1].file_name,holdname);
  return 1;
} /* quicksave_proc */

int manip_frame_done_proc(Frame subframe)
{
  int q=0;
	
  while (subframe!=manip_frame[q] && q<NUM_PACKS) q++;
  if (q==NUM_PACKS) return 1;
  live_node[q]=live_face[q]=0; 
  set_cursor(&screendata[q],0);
  xv_set(subframe,FRAME_CMD_PIN_STATE,FRAME_CMD_PIN_OUT,
	 XV_SHOW,FALSE,0);
  return 1;
} /* manip_frame_done_proc */

int set_packing_path()
/* update global string 'path' from config window */
{
  int n;
  char stuff[BUFSIZE];

  if (!cmd_mode) 
    strcpy(packing_dir_name,(char *)xv_get(dir_name_item,PANEL_VALUE));
  stripsp(packing_dir_name);
  stuff[0]='\0';
  if (!strncmp(packing_dir_name,"$HOME",5)
      || (packing_dir_name[0]=='~') )
    {
      strcpy(stuff,home_dir);
      if (packing_dir_name[0]=='~') strcat(stuff,packing_dir_name+1);
      else strcat(stuff,packing_dir_name+5);
    }
  else strcat(stuff,packing_dir_name);
  sprintf(path,"%s",stuff);
  if ((n=strlen(path))>0 && path[n-1]!='/') strcat(path,"/");
  return 1;
} /* set_packing_path */  	

long find_token(FILE *fp,long pos,char **string,char *token)
     /* starting at position pos, find token in file, return
	line following it. Return -1 on error or failure, else
	return position following returned string. */
{
  int n,m,i;
  char *buff,*hit;

  *string=NULL;
  if (!fp || (n=strlen(token))>34 || n==0
      || pos < 0 || fseek(fp,pos,SEEK_SET)) 
    return -1;
  buff=(char *)calloc((size_t)(BUFSIZE+2),sizeof(char));
  buff[BUFSIZE+1]='\0';

  fgets(buff,BUFSIZE,fp);
  hit=NULL;
  while (!(hit=strstr(buff,token)) && fgets(buff,BUFSIZE,fp))
    hit=NULL;
  if (hit) /* found token */
    {
      hit += strlen(token);
      i=0;
      do
	{
	  *(buff+i)=*(hit+i);
	  i++;
	} while (hit[i]!='\0' && hit[i]!='\n' && i<=BUFSIZE);
      *(buff+i)='\0';
      while (buff[(n=strlen(buff)-1)]=='\\' && (m=(BUFSIZE-n)) > 1
	     && fgets((buff+n+1),m,fp)) 
	/* line continuations? Replace \ by space and concatenate. */
	{
	  buff[n]=' ';
	  buff[strlen(buff)-1]='\0'; /* get rid of \n */
	}
      *string=buff;
      return (long)ftell(fp);
    }
  free(buff);
  return (long)(-1);
} /* find_token */
  
int find_name(FILE *fp,char *name,long *pos)
     /* search file from current location for 'name',
	look for key word at beginning of one of next
	5 lines: return 
	1 = NODECOUNT, 2 = CHECKCOUNT, 3 = PATH,
	4 = CMDS, -1 = error; 
	file position following name is given in 'pos',
        but file position is reset to original. */
{
  int len,i,flag=0;
  long save_pos,spot;
  char buff[BUFSIZE],next[BUFSIZE],*hit,*ptr;

  if (!fp || (len=strlen(name))<1 || len>128)
    return -1;
  save_pos=spot=ftell(fp);
  
  hit=NULL;
  while (!hit && fgets(buff,BUFSIZE,fp))
    {
      if ((hit=strstr(buff,name))) /* found name */
	{
	  spot=spot+(int)(hit-buff)+len;
	  fseek(fp,spot,SEEK_SET);
	  for (i=1;i<=5;i++)
	    {
	      ptr=&(buff[0]);
	      if (fgets(buff,BUFSIZE,fp) && grab_next(&ptr,next))
		{
		  if (!strncmp(next,"NODECOUNT",9))
		    flag=1;
		  else if (!strncmp(next,"CHECKCOUNT",10))
		    flag=2;
		  else if (!strncmp(next,"PATH",4))
		    flag=3;
		  else if (!strncmp(next,"CMDS",4))
		    flag=4;
		}
	      if (flag) i=6; /* bomb out */
	    }
	  if (!flag) /* didn't find a key word */
	      hit=NULL;
	  else fseek(fp,spot,SEEK_SET);
	}
      if (!hit) spot=ftell(fp);
    } /* end of while */
  fseek(fp,save_pos,SEEK_SET);
  if (flag)
    {
      *pos=spot;
      return flag;
    }
  return -1;
} /* find_name */











