#include "cp_types.h"
#include "cp_proto.h"

/* Routines for drawing euclidean objects */

/* Drawing flag scheme: flags indicate drawing instructions
   for objects -- circles/lines/faces. Bits set as follows:
      1  ->  draw object?
      2  ->  fill? (4 and 16 imply 2, also)
      4  ->  off = foreground, on = background 
             (applies to interior, not border, overriden by bit 16)
      8  ->  border color? (off = foreground, on = recorded color)
      16 ->  interior color? (default set by bit 4, on --> recorded color)
      32 ->  display label?

Eg.  flag=3: filled object, in foreground
     flag=9: open object, border in (recorded) color
             (for 'edge', this gives colored edge)
     flag=19: filled in color, border in foreground
     flag=27: filled, border and interior in color
     flag=15: filled with background, border in color
     flag=32: label only (face or circle)

Normally, flag for each type of object; often, when passed on to
subroutine, you may need to pass color code too:
Eg. (cflag, ecol, ccol) for circle flag, border color code, int color 
code. */

int alist[200];

int kline(struct s_data *q,complex end1,complex end2,int col,int show)
{
  int x1,x2,y1,y2,n=0;
  complex n1,n2;
  
  if ((end1.re==end2.re && end1.im==end2.im) || 
      line_ck(end1,end2,q->box))
    {
      r_to_pix(end1,&n1,q->pix_box,q->box);
      r_to_pix(end2,&n2,q->pix_box,q->box);
      while ((fabs(n1.re)>2000.0 || fabs(n1.im)>2000.0 
	      || fabs(n2.re)>2000.0 || fabs(n2.im)>2000.0) && n<5)
	{
	  if (fabs(n1.re)>2000.0 || fabs(n1.im)>2000.0)
	    {
	      n++;
	      n1.re=(n1.re+2*n2.re)/3.0;
	      n1.im=(n1.im+2*n2.im)/3.0;
	    }
	  if (fabs(n2.re)>2000.0 || fabs(n2.im)>2000.0)
	    {
	      n++;
	      n2.re=(n2.re+2*n1.re)/3.0;
	      n2.im=(n2.im+2*n1.im)/3.0;
	    }
	} /* shorten if line extremely long */
      x1=n1.re;y1=n1.im;
      x2=n2.re;y2=n2.im;
      if (col!=FG_COLOR)
	DrawLine(q->xpm,x1,y1,x2,y2,colors[col]);
      else DrawLine(q->xpm,x1,y1,x2,y2,fgcolor);
      if (show) refresh_canvas(q);
      return 1;
    }
  return 0;
} /* kline */

int e_triangle(struct s_data *q,complex p1,complex p2,complex p3,
	       int fflag,int ecol,int fcol,int show)
{
  complex normpt;
  XPoint pts[4];

  r_to_pix(p1,&normpt,q->pix_box,q->box);
  pts[0].x=pts[3].x=(short)normpt.re; 
  pts[0].y=pts[3].y=(short)normpt.im;
  r_to_pix(p2,&normpt,q->pix_box,q->box);
  pts[1].x=(short)normpt.re; pts[1].y=(short)normpt.im;
  r_to_pix(p3,&normpt,q->pix_box,q->box);
  pts[2].x=(short)normpt.re; pts[2].y=(short)normpt.im;
  if (fflag & 2) 
    {
      if (!(fflag & 16))
	{
	  fcol=FG_COLOR;
	  if (fflag & 4) fcol=BG_COLOR;
	}
      FillPolygon(q->xpm,pts,4,colors[fcol]);
    }
  if (!(fflag & 8)) ecol=FG_COLOR;
  DrawLines(q->xpm,pts,4,colors[ecol]);

  if (show) refresh_canvas(q);
  return 1;
} /* e_triangle */
	
int e_polygon(struct p_data *p,struct Vertlist *vertlist,
	      int fflag,int ecol,int fcol,int show)
{
  int numpts,N[1],i,tlist[1000],v,w;
  complex a,b,normpt;
  XPoint pts[1000];
  struct Vertlist *vtrace;
  struct R_data *pR_ptr;

  pR_ptr=p->packR_ptr;
  N[0]=0;
  if (!(vtrace=vertlist) || !(vtrace->next)) return 0;
  /* build up tlist */
  while (vtrace && vtrace->next
	 && (v=vtrace->v)>0 && v<=p->nodecount
	 && (w=vtrace->next->v)>0 && w<=p->nodecount
	 && N[0] < 490 )
    {
      if (v!=w) /* eat repeats */
	{
	  a=pR_ptr[v].center;	
	  b=pR_ptr[w].center;
	  r_to_pix(a,&normpt,p->screen->pix_box,
		   p->screen->box);
	  alist[0]=normpt.re;alist[1]=normpt.im;
	  r_to_pix(b,&normpt,p->screen->pix_box,
		   p->screen->box);
	  alist[2]=normpt.re;alist[3]=normpt.im;
	  numpts = 2;
	  for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[i];
	  N[0] += numpts;
	}
      vtrace=vtrace->next;
    } /* end of while */
  for (i=0;i<N[0];i++)
    {
      pts[i].x=(short)tlist[i*2];
      pts[i].y=(short)tlist[i*2+1];
    }
  if (fflag & 2)  /* want filled */
    {
      if (!(fflag & 16))
	{
	  fcol=FG_COLOR;
	  if (fflag & 4) fcol=BG_COLOR;
	}
      FillPolygon(p->screen->xpm,pts,N[0],colors[fcol]);
    }
  if (!(fflag & 8)) ecol=FG_COLOR;
  DrawLines(p->screen->xpm,pts,N[0],colors[ecol]);

  if (show) refresh_canvas(p->screen);
  return 1;
} /* e_polygon */

