#include "cp_types.h"
#include "cp_proto.h"

/* set transforms for spherical graphing */

int sphere_view(struct s_data *q,char *datastr)
{
	int i,j;
	double ax=0.0,ay=0.0,az=0.0;

	stripsp(datastr);
	if (*datastr=='-')
	 {
			/* default settings */
		if (*(datastr+1)=='d') 
		 {
			for (i=0;i<3;i++) 
			 {
				for (j=0;j<3;j++)
					q->disp_trans[i][j]=
					q->disp_inv_trans[i][j]=0.0;
				q->disp_trans[i][i]=
				   q->disp_inv_trans[i][i]=1.0;
			 }
			sph_rotation(0.0,-0.1*M_PI,-0.03*M_PI,
				q->disp_trans,
				q->disp_inv_trans);
		 }
		else if (*(datastr+1)=='i') /* incr change */
		 {
			if (sscanf(datastr+2,"%lf %lf %lf",&ax,&ay,&az)>0)
			 {
			   sph_rotation(ax*M_PI,ay*M_PI,az*M_PI,
				q->disp_trans,
				q->disp_inv_trans);
			 }
		 }
		return 1;
	 }
	if (sscanf(datastr,"%lf %lf %lf",&ax,&ay,&az)>0)
	 {
		for (i=0;i<3;i++) 
		 {
			for (j=0;j<3;j++)
				q->disp_trans[i][j]=
				q->disp_inv_trans[i][j]=0.0;
			q->disp_trans[i][i]=
			   q->disp_inv_trans[i][i]=1.0;
		 }
		sph_rotation(ax*M_PI,ay*M_PI,az*M_PI,
			q->disp_trans,
			q->disp_inv_trans);
	 }
	return 1;
} /* sphere_view */
